/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.restful.api;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.metadata.hive.dto.MetadataQueryParam;
import org.apache.linkis.metadata.restful.remote.DataSourceRestfulRemote;
import org.apache.linkis.metadata.service.DataSourceService;
import org.apache.linkis.metadata.service.HiveMetaWithPermissionService;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"data source restful api"})
@RestController
@RequestMapping(path={"/datasource"})
public class DataSourceRestfulApi
implements DataSourceRestfulRemote {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceRestfulApi.class);
    @Autowired
    DataSourceService dataSourceService;
    @Autowired
    HiveMetaWithPermissionService hiveMetaWithPermissionService;

    @Override
    @ApiOperation(value="queryDatabaseInfo", notes="query database info", response=Message.class)
    @RequestMapping(path={"dbs"}, method={RequestMethod.GET})
    public Message queryDatabaseInfo(HttpServletRequest req) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"get dbs");
        try {
            JsonNode dbs = this.dataSourceService.getDbs(userName);
            return Message.ok((String)"").data("dbs", (Object)dbs);
        }
        catch (Exception e) {
            logger.error("Failed to get database(\u83b7\u53d6\u6570\u636e\u5e93\u5931\u8d25)", (Throwable)e);
            return Message.error((String)"Failed to get database(\u83b7\u53d6\u6570\u636e\u5e93\u5931\u8d25)", (Throwable)e);
        }
    }

    @ApiOperation(value="queryPartitionExists", notes="query partition exists", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="database", dataType="String", value="database"), @ApiImplicitParam(name="table", dataType="String", value="table"), @ApiImplicitParam(name="partition", dataType="String", value="table")})
    @RequestMapping(path={"partitionExists"}, method={RequestMethod.GET})
    public Message partitionExists(@RequestParam(value="database") String database, @RequestParam(value="table") String table, @RequestParam(value="partition") String partition, HttpServletRequest req) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"query partition exists");
        try {
            if (StringUtils.isBlank((CharSequence)database)) {
                return Message.error((String)"'database' is missing[\u7f3a\u5c11\u6570\u636e\u5e93]");
            }
            if (StringUtils.isBlank((CharSequence)table)) {
                return Message.error((String)"'table' is missing[\u7f3a\u5c11\u8868\u540d]");
            }
            if (StringUtils.isBlank((CharSequence)partition)) {
                return Message.error((String)"'partition' is missing[\u7f3a\u5c11\u5206\u533a\u540d]");
            }
            MetadataQueryParam queryParam = MetadataQueryParam.of(userName).withDbName(database).withTableName(table).withPartitionName(partition);
            boolean res = this.dataSourceService.partitionExists(queryParam);
            return Message.ok((String)"").data("partitionExists", (Object)res);
        }
        catch (Exception e) {
            logger.error("Failed to examine whether a partition exists(\u68c0\u67e5\u5206\u533a\u662f\u5426\u5b58\u5728\u5931\u8d25)", (Throwable)e);
            return Message.error((String)"Failed to examine whether a partition exists (\u68c0\u67e5\u5206\u533a\u662f\u5426\u5b58\u5728\u5931\u8d25)", (Throwable)e);
        }
    }

    @Override
    @ApiOperation(value="queryDbsWithTables", notes="query dbs with tables", response=Message.class)
    @RequestMapping(path={"all"}, method={RequestMethod.GET})
    public Message queryDbsWithTables(HttpServletRequest req) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"get all db and tables");
        try {
            JsonNode dbs = this.dataSourceService.getDbsWithTables(userName);
            return Message.ok((String)"").data("dbs", (Object)dbs);
        }
        catch (Exception e) {
            logger.error("Failed to queryDbsWithTables", (Throwable)e);
            return Message.error((String)"Failed to queryDbsWithTables", (Throwable)e);
        }
    }

    @Override
    @ApiOperation(value="queryTables", notes="query tables", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="database", dataType="String", value="database")})
    @RequestMapping(path={"tables"}, method={RequestMethod.GET})
    public Message queryTables(@RequestParam(value="database", required=false) String database, HttpServletRequest req) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"get tables");
        MetadataQueryParam queryParam = MetadataQueryParam.of(userName).withDbName(database);
        try {
            JsonNode tables = this.dataSourceService.queryTables(queryParam);
            return Message.ok((String)"").data("tables", (Object)tables);
        }
        catch (Exception e) {
            logger.error("Failed to queryTables", (Throwable)e);
            return Message.error((String)"Failed to queryTables", (Throwable)e);
        }
    }

    @Override
    @ApiOperation(value="queryTableMeta", notes="query table meta", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="database", dataType="String", value="database"), @ApiImplicitParam(name="table", dataType="String", value="table")})
    @RequestMapping(path={"columns"}, method={RequestMethod.GET})
    public Message queryTableMeta(@RequestParam(value="database", required=false) String database, @RequestParam(value="table", required=false) String table, HttpServletRequest req) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("get columns of table " + table));
        MetadataQueryParam queryParam = MetadataQueryParam.of(userName).withDbName(database).withTableName(table);
        try {
            JsonNode columns = this.hiveMetaWithPermissionService.getColumnsByDbTableNameAndOptionalUserName(queryParam);
            return Message.ok((String)"").data("columns", (Object)columns);
        }
        catch (Exception e) {
            logger.error("Failed to get data table structure(\u83b7\u53d6\u6570\u636e\u8868\u7ed3\u6784\u5931\u8d25)", (Throwable)e);
            return Message.error((String)"Failed to get data table structure(\u83b7\u53d6\u6570\u636e\u8868\u7ed3\u6784\u5931\u8d25)", (Throwable)e);
        }
    }

    @Override
    @ApiOperation(value="sizeOf", notes="size Of", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="database", dataType="String", value="database"), @ApiImplicitParam(name="table", dataType="String", value="table"), @ApiImplicitParam(name="partition", dataType="String")})
    @RequestMapping(path={"size"}, method={RequestMethod.GET})
    public Message sizeOf(@RequestParam(value="database", required=false) String database, @RequestParam(value="table", required=false) String table, @RequestParam(value="partition", required=false) String partition, HttpServletRequest req) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"get size ");
        MetadataQueryParam queryParam = MetadataQueryParam.of(userName).withDbName(database).withTableName(table).withPartitionName(partition);
        try {
            JsonNode sizeNode = StringUtils.isBlank((CharSequence)partition) ? this.dataSourceService.getTableSize(queryParam) : this.dataSourceService.getPartitionSize(queryParam);
            return Message.ok((String)"").data("sizeInfo", (Object)sizeNode);
        }
        catch (Exception e) {
            logger.error("Failed to get table partition size(\u83b7\u53d6\u8868\u5206\u533a\u5927\u5c0f\u5931\u8d25)", (Throwable)e);
            return Message.error((String)"Failed to get table partition size(\u83b7\u53d6\u8868\u5206\u533a\u5927\u5c0f\u5931\u8d25)", (Throwable)e);
        }
    }

    @Override
    @ApiOperation(value="partitions", notes="partitions", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="database", dataType="String", value="database"), @ApiImplicitParam(name="table", dataType="String", value="table")})
    @RequestMapping(path={"partitions"}, method={RequestMethod.GET})
    public Message partitions(@RequestParam(value="database", required=false) String database, @RequestParam(value="table", required=false) String table, HttpServletRequest req) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("get partitions of " + table));
        MetadataQueryParam queryParam = MetadataQueryParam.of(userName).withDbName(database).withTableName(table);
        try {
            JsonNode partitionNode = this.dataSourceService.getPartitions(queryParam);
            return Message.ok((String)"").data("partitionInfo", (Object)partitionNode);
        }
        catch (Exception e) {
            logger.error("Failed to get table partition(\u83b7\u53d6\u8868\u5206\u533a\u5931\u8d25)", (Throwable)e);
            return Message.error((String)"Failed to get table partition(\u83b7\u53d6\u8868\u5206\u533a\u5931\u8d25)", (Throwable)e);
        }
    }
}

