/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.hive.dto;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MetadataQueryParam {
    private String userName;
    private String dbName;
    private String tableName;
    private String partitionName;
    private String sdId;
    private List<String> roles;

    public static MetadataQueryParam of(String userName) {
        return new MetadataQueryParam(userName);
    }

    public MetadataQueryParam() {
        this.roles = new ArrayList<String>();
    }

    public MetadataQueryParam(String username) {
        this.userName = username;
        this.roles = new ArrayList<String>();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public MetadataQueryParam withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public MetadataQueryParam withDbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public MetadataQueryParam withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public MetadataQueryParam withRoles(List<String> roles) {
        if (roles != null && !roles.isEmpty()) {
            this.roles.addAll(roles);
        }
        return this;
    }

    public MetadataQueryParam withRole(String role) {
        if (StringUtils.isNotBlank((CharSequence)role)) {
            this.roles.add(role);
        }
        return this;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public MetadataQueryParam withPartitionName(String partitionName) {
        this.partitionName = partitionName;
        return this;
    }

    public String getSdId() {
        return this.sdId;
    }

    public void setSdId(String sdId) {
        this.sdId = sdId;
    }

    public MetadataQueryParam withSdId(String sdId) {
        this.sdId = sdId;
        return this;
    }
}

