/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLServerSocket;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.TFrontendService;
import org.apache.kyuubi.util.NamedThreadFactory;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]b!\u0002\t\u0012\u0003\u0003Q\u0002\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u000b!\u0003A\u0011A%\t\u00111\u0003\u0001R1A\u0005V5C\u0001B\u0015\u0001\t\u0006\u0004%)f\u0015\u0005\b/\u0002\u0001\r\u0011\"\u0005Y\u0011\u001d\u0001\u0007\u00011A\u0005\u0012\u0005Daa\u001a\u0001!B\u0013I\u0006\"\u00035\u0001\u0001\u0004\u0005\r\u0011\"\u0003T\u0011%I\u0007\u00011AA\u0002\u0013%!\u000eC\u0005m\u0001\u0001\u0007\t\u0011)Q\u0005)\"AQ\u000e\u0001EC\u0002\u0013E3\u000bC\u0003o\u0001\u0011\u0005s\u000eC\u0003y\u0001\u0011%\u0011\u0010C\u0004\u00022\u0001!\t%a\r\t\u000f\u0005U\u0002\u0001\"\u0015\u00024\t1BKQ5oCJLhI]8oi\u0016tGmU3sm&\u001cWM\u0003\u0002\u0013'\u000591/\u001a:wS\u000e,'B\u0001\u000b\u0016\u0003\u0019Y\u00170^;cS*\u0011acF\u0001\u0007CB\f7\r[3\u000b\u0003a\t1a\u001c:h\u0007\u0001\u0019R\u0001A\u000e ]Y\u0002\"\u0001H\u000f\u000e\u0003EI!AH\t\u0003!Q3%o\u001c8uK:$7+\u001a:wS\u000e,\u0007C\u0001\u0011,\u001d\t\t\u0013&D\u0001#\u0015\t\u0019C%\u0001\u0004uQJLg\r\u001e\u0006\u0003K\u0019\n1A\u001d9d\u0015\t\u0011rE\u0003\u0002)+\u0005!\u0001.\u001b<f\u0013\tQ#%A\u0006U\u00072K5+\u001a:wS\u000e,\u0017B\u0001\u0017.\u0005\u0015Ie-Y2f\u0015\tQ#\u0005\u0005\u00020i5\t\u0001G\u0003\u00022e\u0005!A.\u00198h\u0015\u0005\u0019\u0014\u0001\u00026bm\u0006L!!\u000e\u0019\u0003\u0011I+hN\\1cY\u0016\u0004\"a\u000e\u001d\u000e\u0003MI!!O\n\u0003\u000f1{wmZ5oO\u0006!a.Y7f!\taTI\u0004\u0002>\u0007B\u0011a(Q\u0007\u0002\u007f)\u0011\u0001)G\u0001\u0007yI|w\u000e\u001e \u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0002\rA\u0013X\rZ3g\u0013\t1uI\u0001\u0004TiJLgn\u001a\u0006\u0003\t\u0006\u000ba\u0001P5oSRtDC\u0001&L!\ta\u0002\u0001C\u0003;\u0005\u0001\u00071(\u0001\u0006tKJ4XM\u001d%pgR,\u0012A\u0014\t\u0004\u001fB[T\"A!\n\u0005E\u000b%AB(qi&|g.A\u0004q_J$h*^7\u0016\u0003Q\u0003\"aT+\n\u0005Y\u000b%aA%oi\u000611/\u001a:wKJ,\u0012!\u0017\t\u0004\u001fBS\u0006CA._\u001b\u0005a&BA,^\u0015\t\u0019S#\u0003\u0002`9\n9AkU3sm\u0016\u0014\u0018AC:feZ,'o\u0018\u0013fcR\u0011!-\u001a\t\u0003\u001f\u000eL!\u0001Z!\u0003\tUs\u0017\u000e\u001e\u0005\bM\u001a\t\t\u00111\u0001Z\u0003\rAH%M\u0001\bg\u0016\u0014h/\u001a:!\u0003-y\u0016m\u0019;vC2\u0004vN\u001d;\u0002\u001f}\u000b7\r^;bYB{'\u000f^0%KF$\"AY6\t\u000f\u0019L\u0011\u0011!a\u0001)\u0006aq,Y2uk\u0006d\u0007k\u001c:uA\u0005Q\u0011m\u0019;vC2\u0004vN\u001d;\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0002ca\")\u0011\u000f\u0004a\u0001e\u0006!1m\u001c8g!\t\u0019h/D\u0001u\u0015\t)8#\u0001\u0004d_:4\u0017nZ\u0005\u0003oR\u0014!bS=vk\nL7i\u001c8g\u0003I9W\r^*feZ,'oU*M'>\u001c7.\u001a;\u0015\u001bi\f\t!!\u0002\u0002\n\u00055\u0011\u0011CA\u000e!\tYh0D\u0001}\u0015\tiX,A\u0005ue\u0006t7\u000f]8si&\u0011q\u0010 \u0002\u000e)N+'O^3s'>\u001c7.\u001a;\t\r\u0005\rQ\u00021\u0001<\u00031YW-_*u_J,\u0007+\u0019;i\u0011\u0019\t9!\u0004a\u0001w\u0005\u00012.Z=Ti>\u0014X\rU1tg^|'\u000f\u001a\u0005\u0007\u0003\u0017i\u0001\u0019\u0001(\u0002\u0019-,\u0017p\u0015;pe\u0016$\u0016\u0010]3\t\r\u0005=Q\u00021\u0001O\u0003EYW-_*u_J,\u0017\t\\4pe&$\b.\u001c\u0005\b\u0003'i\u0001\u0019AA\u000b\u0003Y!\u0017n]1mY><X\rZ*tYB\u0013x\u000e^8d_2\u001c\b\u0003\u0002\u001f\u0002\u0018mJ1!!\u0007H\u0005\r\u0019V\r\u001e\u0005\b\u0003;i\u0001\u0019AA\u0010\u0003MIgn\u00197vI\u0016\u001c\u0015\u000e\u001d5feN+\u0018\u000e^3t!\u0015\t\t#a\u000b<\u001d\u0011\t\u0019#a\n\u000f\u0007y\n)#C\u0001C\u0013\r\tI#Q\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti#a\f\u0003\u0007M+\u0017OC\u0002\u0002*\u0005\u000b1A];o)\u0005\u0011\u0017AC:u_B\u001cVM\u001d<fe\u0002")
public abstract class TBinaryFrontendService
extends TFrontendService {
    private Option<String> serverHost;
    private int portNum;
    private int actualPort;
    private final String name;
    private Option<TServer> server;
    private int _actualPort;
    private volatile byte bitmap$0;

    private Option<String> serverHost$lzycompute() {
        TBinaryFrontendService tBinaryFrontendService = this;
        synchronized (tBinaryFrontendService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serverHost = this.conf().get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_BINARY_BIND_HOST());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serverHost;
    }

    @Override
    public final Option<String> serverHost() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.serverHost$lzycompute();
        }
        return this.serverHost;
    }

    private int portNum$lzycompute() {
        TBinaryFrontendService tBinaryFrontendService = this;
        synchronized (tBinaryFrontendService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.portNum = BoxesRunTime.unboxToInt(this.conf().get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_BINARY_BIND_PORT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.portNum;
    }

    @Override
    public final int portNum() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.portNum$lzycompute();
        }
        return this.portNum;
    }

    public Option<TServer> server() {
        return this.server;
    }

    public void server_$eq(Option<TServer> x$1) {
        this.server = x$1;
    }

    private int _actualPort() {
        return this._actualPort;
    }

    private void _actualPort_$eq(int x$1) {
        this._actualPort = x$1;
    }

    private int actualPort$lzycompute() {
        TBinaryFrontendService tBinaryFrontendService = this;
        synchronized (tBinaryFrontendService) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.actualPort = this._actualPort();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.actualPort;
    }

    @Override
    public int actualPort() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.actualPort$lzycompute();
        }
        return this.actualPort;
    }

    @Override
    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        try {
            TServerSocket tServerSocket;
            int minThreads = BoxesRunTime.unboxToInt(conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_MIN_WORKER_THREADS()));
            int maxThreads = BoxesRunTime.unboxToInt(conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_MAX_WORKER_THREADS()));
            long keepAliveTime = BoxesRunTime.unboxToLong(conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_WORKER_KEEPALIVE_TIME()));
            ThreadPoolExecutor executor = new ThreadPoolExecutor(minThreads, maxThreads, keepAliveTime, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory(new StringBuilder(12).append(this.name).append("Handler-Pool").toString(), false));
            TTransportFactory transFactory = this.authFactory().getTTransportFactory();
            TProcessorFactory tProcFactory = this.authFactory().getTProcessorFactory(this);
            if (this.isServer() && BoxesRunTime.unboxToBoolean(conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_BINARY_SSL_ENABLED()))) {
                Option keyStorePath = (Option)((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_PATH()));
                Option keyStorePassword = (Option)((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_PASSWORD()));
                Option keyStoreType = (Option)((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_TYPE()));
                Option keyStoreAlgorithm = (Option)((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_ALGORITHM()));
                Set<String> disallowedSslProtocols = conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_BINARY_SSL_DISALLOWED_PROTOCOLS());
                Seq<String> includeCipherSuites = conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_BINARY_SSL_INCLUDE_CIPHER_SUITES());
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(34).append(KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_PATH().key()).append(" not configured for SSL connection").toString());
                }
                if (keyStorePassword.isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(34).append(KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_PASSWORD().key()).append(" not configured for SSL connection").toString());
                }
                tServerSocket = this.getServerSSLSocket((String)keyStorePath.get(), (String)keyStorePassword.get(), keyStoreType, keyStoreAlgorithm, disallowedSslProtocols, includeCipherSuites);
            } else {
                tServerSocket = new TServerSocket(new ServerSocket(this.portNum(), -1, this.serverAddr()));
            }
            TServerSocket tServerSocket2 = tServerSocket;
            this._actualPort_$eq(tServerSocket2.getServerSocket().getLocalPort());
            int maxMessageSize = BoxesRunTime.unboxToInt(conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_MAX_MESSAGE_SIZE()));
            int requestTimeout = (int)BoxesRunTime.unboxToLong(conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_LOGIN_TIMEOUT()));
            int beBackoffSlotLength = (int)BoxesRunTime.unboxToLong(conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_LOGIN_BACKOFF_SLOT_LENGTH()));
            TThreadPoolServer.Args args = ((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)tServerSocket2).processorFactory(tProcFactory).transportFactory(transFactory).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory()).inputProtocolFactory((TProtocolFactory)new TBinaryProtocol.Factory(true, true, (long)maxMessageSize, (long)maxMessageSize))).requestTimeout(requestTimeout).requestTimeoutUnit(TimeUnit.MILLISECONDS).beBackoffSlotLength(beBackoffSlotLength).beBackoffSlotLengthUnit(TimeUnit.MILLISECONDS).executorService((ExecutorService)executor);
            this.server_$eq(new Some<TThreadPoolServer>(new TThreadPoolServer(args)));
            this.server().foreach((Function1<TServer, Object> & Serializable & scala.Serializable)x$1 -> {
                x$1.setServerEventHandler((TServerEventHandler)new TFrontendService.FeTServerEventHandler(this));
                return BoxedUnit.UNIT;
            });
            this.info((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Initializing ").append($this.name).append(" on ").append(this.serverAddr().getHostName()).append(":").append(this._actualPort()).append(" with").append(" [").append(minThreads).append(", ").append(maxThreads).append("] worker threads").toString());
        }
        catch (Throwable e) {
            this.error((Function0<Object>)(Function0<Throwable> & Serializable & scala.Serializable)() -> e);
            throw new KyuubiException(new StringBuilder(43).append("Failed to initialize frontend service on ").append(this.serverAddr()).append(":").append(this.portNum()).append(".").toString(), e);
        }
        super.initialize(conf);
    }

    private TServerSocket getServerSSLSocket(String keyStorePath, String keyStorePassword, Option<String> keyStoreType, Option<String> keyStoreAlgorithm, Set<String> disallowedSslProtocols, Seq<String> includeCipherSuites) {
        TServerSocket tServerSocket;
        block0: {
            TSSLTransportFactory.TSSLTransportParameters params = includeCipherSuites.nonEmpty() ? new TSSLTransportFactory.TSSLTransportParameters("TLS", (String[])includeCipherSuites.toArray(ClassTag$.MODULE$.apply(String.class))) : new TSSLTransportFactory.TSSLTransportParameters();
            params.setKeyStore(keyStorePath, keyStorePassword, (String)keyStoreAlgorithm.getOrElse((Function0<String> & Serializable & scala.Serializable)() -> KeyManagerFactory.getDefaultAlgorithm()), (String)keyStoreType.getOrElse((Function0<String> & Serializable & scala.Serializable)() -> KeyStore.getDefaultType()));
            tServerSocket = TSSLTransportFactory.getServerSocket((int)this.portNum(), (int)0, (InetAddress)this.serverAddr(), (TSSLTransportFactory.TSSLTransportParameters)params);
            ServerSocket serverSocket = tServerSocket.getServerSocket();
            if (!(serverSocket instanceof SSLServerSocket)) break block0;
            SSLServerSocket sSLServerSocket = (SSLServerSocket)serverSocket;
            Set lowerDisallowedSslProtocols = disallowedSslProtocols.map((Function1<String, String> & Serializable & scala.Serializable)x$2 -> x$2.toLowerCase(Locale.ROOT), Set$.MODULE$.canBuildFrom());
            String[] enabledProtocols = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])sSLServerSocket.getEnabledProtocols())).flatMap((Function1<String, Iterable> & Serializable & scala.Serializable)protocol -> {
                if (lowerDisallowedSslProtocols.contains(protocol.toLowerCase(Locale.ROOT))) {
                    this.debug((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Disabling SSL Protocol: ").append((String)protocol).toString());
                    return Option$.MODULE$.option2Iterable(None$.MODULE$);
                }
                return Option$.MODULE$.option2Iterable(new Some<String>((String)protocol));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            sSLServerSocket.setEnabledProtocols(enabledProtocols);
            this.info((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(37).append("SSL Server Socket enabled protocols: ").append(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])enabledProtocols)).mkString(",")).toString());
        }
        return tServerSocket;
    }

    @Override
    public void run() {
        try {
            if (this.isServer()) {
                this.info((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Starting and exposing JDBC connection at: jdbc:hive2://").append(this.connectionUrl()).append("/").toString());
            }
            this.server().foreach((Function1<TServer, Object> & Serializable & scala.Serializable)x$3 -> {
                x$3.serve();
                return BoxedUnit.UNIT;
            });
        }
        catch (InterruptedException interruptedException) {
            this.error((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(15).append(this.getName()).append(" is interrupted").toString());
        }
        catch (Throwable t) {
            this.error((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Error starting ").append(this.getName()).toString(), t);
            System.exit(-1);
        }
    }

    @Override
    public void stopServer() {
        this.server().foreach((Function1<TServer, Object> & Serializable & scala.Serializable)x$4 -> {
            x$4.stop();
            return BoxedUnit.UNIT;
        });
        this.server_$eq(None$.MODULE$);
    }

    public TBinaryFrontendService(String name) {
        this.name = name;
        super(name);
        this.server = None$.MODULE$;
    }
}

