/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.figshare;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.OAuth2AccessToken;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.BasicUserProfile;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.definition.OAuth20ProfileDefinition;
import org.pac4j.oauth.profile.figshare.FigShareProfile;

public class FigShareProfileDefinition
extends OAuth20ProfileDefinition<FigShareProfile, OAuth20Configuration> {
    public static final String LAST_NAME = "last_name";

    public FigShareProfileDefinition() {
        super(x -> new FigShareProfile());
        this.primary(LAST_NAME, (AttributeConverter)Converters.STRING);
    }

    @Override
    public String getProfileUrl(OAuth2AccessToken accessToken, OAuth20Configuration configuration) {
        return "https://api.figshare.com/v2/account";
    }

    @Override
    public FigShareProfile extractUserProfile(String body) {
        FigShareProfile profile = (FigShareProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            if (this.getProfileId() != null) {
                profile.setId(ProfileHelper.sanitizeIdentifier((BasicUserProfile)profile, (Object)JsonHelper.getElement(json, this.getProfileId())));
            }
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }
}

