/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.credentials.authenticator;

import com.github.scribejava.core.exceptions.OAuthException;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.credentials.OAuthCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class OAuthAuthenticator<C extends OAuthCredentials, O extends OAuthConfiguration>
implements Authenticator<C> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected O configuration;
    protected IndirectClient client;

    protected OAuthAuthenticator(O configuration, IndirectClient client) {
        CommonHelper.assertNotNull((String)"client", (Object)client);
        CommonHelper.assertNotNull((String)"configuration", configuration);
        this.configuration = configuration;
        this.client = client;
    }

    public void validate(C credentials, WebContext context) {
        try {
            this.retrieveAccessToken(context, (OAuthCredentials)((Object)credentials));
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected abstract void retrieveAccessToken(WebContext var1, OAuthCredentials var2);
}

