/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.trace;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.knox.gateway.trace.TraceInput;
import org.apache.knox.gateway.trace.TraceUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class TraceRequest
extends HttpServletRequestWrapper {
    private static final Logger log = LogManager.getLogger((String)"org.apache.knox.gateway.http.request");
    private static final Logger headLog = LogManager.getLogger((String)"org.apache.knox.gateway.http.request.headers");
    private ServletInputStream input;

    TraceRequest(HttpServletRequest request) {
        super(request);
        if (log.isTraceEnabled()) {
            this.traceRequestDetails();
        }
    }

    public synchronized ServletInputStream getInputStream() throws IOException {
        if (log.isTraceEnabled()) {
            if (this.input == null) {
                this.input = new TraceInput(super.getInputStream());
            }
            return this.input;
        }
        return super.getInputStream();
    }

    private void traceRequestDetails() {
        StringBuilder sb = new StringBuilder();
        TraceUtil.appendCorrelationContext(sb);
        sb.append("|Request=").append(this.getMethod()).append(' ').append(this.getRequestURI());
        String qs = this.getQueryString();
        if (qs != null) {
            sb.append('?').append(qs);
        }
        this.appendHeaders(sb);
        log.trace(sb.toString());
    }

    private void appendHeaders(StringBuilder sb) {
        if (headLog.isTraceEnabled()) {
            Enumeration names = this.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Enumeration values = this.getHeaders(name);
                while (values.hasMoreElements()) {
                    String value = (String)values.nextElement();
                    sb.append(String.format(Locale.ROOT, "%n\tHeader[%s]=%s", name, value));
                }
            }
        }
    }
}

