/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.audit.log4j.appender;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.knox.gateway.audit.log4j.appender.JdbmQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="JdbmStoreAndForwardAppender", category="Core", elementType="appender")
public class JdbmStoreAndForwardAppender
extends AbstractAppender {
    private Thread forwarder;
    private JdbmQueue<LogEvent> queue;
    private Logger forward;

    private JdbmStoreAndForwardAppender(String name, Filter filter, String file) {
        super(name, filter, null);
        try {
            this.queue = new JdbmQueue(new File(file));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.forward = (Logger)LogManager.getLogger((String)"audit.forward");
        this.forward.setAdditive(false);
        this.forwarder = new Forwarder();
        this.forwarder.setDaemon(true);
        this.forwarder.start();
    }

    @PluginFactory
    public static JdbmStoreAndForwardAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="file") String file) {
        return new JdbmStoreAndForwardAppender(name, filter, file);
    }

    public void append(LogEvent event) {
        try {
            this.queue.enqueue(event);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.queue.stop();
            this.forwarder.join();
            this.queue.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.stop();
    }

    private class Forwarder
    extends Thread {
        private Forwarder() {
        }

        @Override
        public void run() {
            AtomicBoolean done = new AtomicBoolean(false);
            while (!done.get()) {
                try {
                    JdbmStoreAndForwardAppender.this.queue.process(event -> {
                        try {
                            if (event == null) {
                                done.set(true);
                            } else {
                                for (Appender appender : JdbmStoreAndForwardAppender.this.forward.getAppenders().values()) {
                                    appender.append(event);
                                }
                            }
                            return true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return false;
                        }
                    });
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

