/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.Handle;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.TypePath;
import org.eclipse.persistence.internal.libraries.asm.util.ASMifiable;
import org.eclipse.persistence.internal.libraries.asm.util.Printer;

public class ASMifier
extends Printer {
    private static final int ACCESS_CLASS = 262144;
    private static final int ACCESS_FIELD = 524288;
    private static final int ACCESS_INNER = 0x100000;
    private static final int ACCESS_MODULE = 0x200000;
    private static final String ANNOTATION_VISITOR = "annotationVisitor";
    private static final String ANNOTATION_VISITOR0 = "annotationVisitor0 = ";
    private static final String NEW_OBJECT_ARRAY = ", new Object[] {";
    private static final String END_ARRAY = " });\n";
    private static final String END_PARAMETERS = ");\n\n";
    private static final String VISIT_END = ".visitEnd();\n";
    private static final Map<Integer, String> CLASS_VERSIONS;
    protected final String name;
    protected final int id;
    protected Map<Label, String> labelNames;

    public ASMifier() {
        this(393216, "classWriter", 0);
        if (this.getClass() != ASMifier.class) {
            throw new IllegalStateException();
        }
    }

    protected ASMifier(int n, String string, int n2) {
        super(n);
        this.name = string;
        this.id = n2;
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "Prints the ASM code to generate the given class.\nUsage: ASMifier [-debug] <fully qualified class name or class file name>";
        ASMifier.main(string, new ASMifier(), stringArray);
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        String string4;
        if (string == null) {
            string4 = "module-info";
        } else {
            int n3 = string.lastIndexOf(47);
            if (n3 == -1) {
                string4 = string;
            } else {
                this.text.add("package asm." + string.substring(0, n3).replace('/', '.') + ";\n");
                string4 = string.substring(n3 + 1).replace('-', '_');
            }
        }
        this.text.add("import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;\n");
        this.text.add("import org.eclipse.persistence.internal.libraries.asm.Attribute;\n");
        this.text.add("import org.eclipse.persistence.internal.libraries.asm.ClassReader;\n");
        this.text.add("import org.eclipse.persistence.internal.libraries.asm.ClassWriter;\n");
        this.text.add("import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;\n");
        this.text.add("import org.eclipse.persistence.internal.libraries.asm.Handle;\n");
        this.text.add("import org.eclipse.persistence.internal.libraries.asm.Label;\n");
        this.text.add("import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;\n");
        this.text.add("import org.eclipse.persistence.internal.libraries.asm.Opcodes;\n");
        this.text.add("import org.eclipse.persistence.internal.libraries.asm.Type;\n");
        this.text.add("import org.eclipse.persistence.internal.libraries.asm.TypePath;\n");
        this.text.add("public class " + string4 + "Dump implements Opcodes {\n\n");
        this.text.add("public static byte[] dump () throws Exception {\n\n");
        this.text.add("ClassWriter classWriter = new ClassWriter(0);\n");
        this.text.add("FieldVisitor fieldVisitor;\n");
        this.text.add("MethodVisitor methodVisitor;\n");
        this.text.add("AnnotationVisitor annotationVisitor0;\n\n");
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visit(");
        String string5 = CLASS_VERSIONS.get(n);
        if (string5 != null) {
            this.stringBuilder.append(string5);
        } else {
            this.stringBuilder.append(n);
        }
        this.stringBuilder.append(", ");
        this.appendAccessFlags(n2 | 0x40000);
        this.stringBuilder.append(", ");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(", ");
        if (stringArray != null && stringArray.length > 0) {
            this.stringBuilder.append("new String[] {");
            for (int i = 0; i < stringArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? " " : ", ");
                this.appendConstant(stringArray[i]);
            }
            this.stringBuilder.append(" }");
        } else {
            this.stringBuilder.append("null");
        }
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitSource(String string, String string2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visitSource(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public Printer visitModule(String string, int n, String string2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("ModuleVisitor moduleVisitor = classWriter.visitModule(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(n | 0x200000);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier("moduleVisitor", 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visitOuterClass(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public ASMifier visitClassAnnotation(String string, boolean bl) {
        return this.visitAnnotation(string, bl);
    }

    @Override
    public ASMifier visitClassTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation(n, typePath, string, bl);
    }

    @Override
    public void visitClassAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visitInnerClass(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(n | 0x100000);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public ASMifier visitField(int n, String string, String string2, String string3, Object object) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n");
        this.stringBuilder.append("fieldVisitor = classWriter.visitField(");
        this.appendAccessFlags(n | 0x80000);
        this.stringBuilder.append(", ");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(", ");
        this.appendConstant(object);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier("fieldVisitor", 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    @Override
    public ASMifier visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n");
        this.stringBuilder.append("methodVisitor = classWriter.visitMethod(");
        this.appendAccessFlags(n);
        this.stringBuilder.append(", ");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(", ");
        if (stringArray != null && stringArray.length > 0) {
            this.stringBuilder.append("new String[] {");
            for (int i = 0; i < stringArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? " " : ", ");
                this.appendConstant(stringArray[i]);
            }
            this.stringBuilder.append(" }");
        } else {
            this.stringBuilder.append("null");
        }
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier("methodVisitor", 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    @Override
    public void visitClassEnd() {
        this.text.add("classWriter.visitEnd();\n\n");
        this.text.add("return classWriter.toByteArray();\n");
        this.text.add("}\n");
        this.text.add("}\n");
    }

    @Override
    public void visitMainClass(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitMainClass(");
        this.appendConstant(string);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitPackage(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitPackage(");
        this.appendConstant(string);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitRequire(String string, int n, String string2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitRequire(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(n | 0x200000);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitExport(String string, int n, String ... stringArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitExport(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(n | 0x200000);
        if (stringArray != null && stringArray.length > 0) {
            this.stringBuilder.append(", new String[] {");
            for (int i = 0; i < stringArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? " " : ", ");
                this.appendConstant(stringArray[i]);
            }
            this.stringBuilder.append(" }");
        }
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitOpen(String string, int n, String ... stringArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitOpen(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(n | 0x200000);
        if (stringArray != null && stringArray.length > 0) {
            this.stringBuilder.append(", new String[] {");
            for (int i = 0; i < stringArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? " " : ", ");
                this.appendConstant(stringArray[i]);
            }
            this.stringBuilder.append(" }");
        }
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitUse(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitUse(");
        this.appendConstant(string);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitProvide(String string, String ... stringArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitProvide(");
        this.appendConstant(string);
        this.stringBuilder.append(",  new String[] {");
        for (int i = 0; i < stringArray.length; ++i) {
            this.stringBuilder.append(i == 0 ? " " : ", ");
            this.appendConstant(stringArray[i]);
        }
        this.stringBuilder.append(END_ARRAY);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitModuleEnd() {
        this.text.add("moduleVisitor.visitEnd();\n");
    }

    @Override
    public void visit(String string, Object object) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(ANNOTATION_VISITOR).append(this.id).append(".visit(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(object);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitEnum(String string, String string2, String string3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(ANNOTATION_VISITOR).append(this.id).append(".visitEnum(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public ASMifier visitAnnotation(String string, String string2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append("AnnotationVisitor annotationVisitor").append(this.id + 1).append(" = annotationVisitor");
        this.stringBuilder.append(this.id).append(".visitAnnotation(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier(ANNOTATION_VISITOR, this.id + 1);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    @Override
    public ASMifier visitArray(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n");
        this.stringBuilder.append("AnnotationVisitor annotationVisitor").append(this.id + 1).append(" = annotationVisitor");
        this.stringBuilder.append(this.id).append(".visitArray(");
        this.appendConstant(string);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier(ANNOTATION_VISITOR, this.id + 1);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    @Override
    public void visitAnnotationEnd() {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(ANNOTATION_VISITOR).append(this.id).append(VISIT_END);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public ASMifier visitFieldAnnotation(String string, boolean bl) {
        return this.visitAnnotation(string, bl);
    }

    @Override
    public ASMifier visitFieldTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation(n, typePath, string, bl);
    }

    @Override
    public void visitFieldAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    @Override
    public void visitFieldEnd() {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(VISIT_END);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitParameter(String string, int n) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitParameter(");
        ASMifier.appendString(this.stringBuilder, string);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(n);
        this.text.add(this.stringBuilder.append(");\n").toString());
    }

    @Override
    public ASMifier visitAnnotationDefault() {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.name).append(".visitAnnotationDefault();\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    @Override
    public ASMifier visitMethodAnnotation(String string, boolean bl) {
        return this.visitAnnotation(string, bl);
    }

    @Override
    public ASMifier visitMethodTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation(n, typePath, string, bl);
    }

    @Override
    public ASMifier visitAnnotableParameterCount(int n, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitAnnotableParameterCount(").append(n).append(", ").append(bl).append(");\n");
        this.text.add(this.stringBuilder.toString());
        return this;
    }

    @Override
    public ASMifier visitParameterAnnotation(int n, String string, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.name).append(".visitParameterAnnotation(").append(n).append(", ");
        this.appendConstant(string);
        this.stringBuilder.append(", ").append(bl).append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    @Override
    public void visitMethodAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    @Override
    public void visitCode() {
        this.text.add(this.name + ".visitCode();\n");
    }

    @Override
    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        this.stringBuilder.setLength(0);
        switch (n) {
            case -1: 
            case 0: {
                this.declareFrameTypes(n2, objectArray);
                this.declareFrameTypes(n3, objectArray2);
                if (n == -1) {
                    this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_NEW, ");
                } else {
                    this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_FULL, ");
                }
                this.stringBuilder.append(n2).append(NEW_OBJECT_ARRAY);
                this.appendFrameTypes(n2, objectArray);
                this.stringBuilder.append("}, ").append(n3).append(NEW_OBJECT_ARRAY);
                this.appendFrameTypes(n3, objectArray2);
                this.stringBuilder.append('}');
                break;
            }
            case 1: {
                this.declareFrameTypes(n2, objectArray);
                this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_APPEND,").append(n2).append(NEW_OBJECT_ARRAY);
                this.appendFrameTypes(n2, objectArray);
                this.stringBuilder.append("}, 0, null");
                break;
            }
            case 2: {
                this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_CHOP,").append(n2).append(", null, 0, null");
                break;
            }
            case 3: {
                this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_SAME, 0, null, 0, null");
                break;
            }
            case 4: {
                this.declareFrameTypes(1, objectArray2);
                this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_SAME1, 0, null, 1, new Object[] {");
                this.appendFrameTypes(1, objectArray2);
                this.stringBuilder.append('}');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitInsn(int n) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitInsn(").append(OPCODES[n]).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitIntInsn(int n, int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitIntInsn(").append(OPCODES[n]).append(", ").append(n == 188 ? TYPES[n2] : Integer.toString(n2)).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitVarInsn(int n, int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitVarInsn(").append(OPCODES[n]).append(", ").append(n2).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitTypeInsn(int n, String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitTypeInsn(").append(OPCODES[n]).append(", ");
        this.appendConstant(string);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitFieldInsn(").append(OPCODES[n]).append(", ");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    @Deprecated
    public void visitMethodInsn(int n, String string, String string2, String string3) {
        if (this.api >= 327680) {
            super.visitMethodInsn(n, string, string2, string3);
            return;
        }
        this.doVisitMethodInsn(n, string, string2, string3, n == 185);
    }

    @Override
    public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        if (this.api < 327680) {
            super.visitMethodInsn(n, string, string2, string3, bl);
            return;
        }
        this.doVisitMethodInsn(n, string, string2, string3, bl);
    }

    private void doVisitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitMethodInsn(").append(OPCODES[n]).append(", ");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(", ");
        this.stringBuilder.append(bl ? "true" : "false");
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitInvokeDynamicInsn(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(handle);
        this.stringBuilder.append(", new Object[]{");
        for (int i = 0; i < objectArray.length; ++i) {
            this.appendConstant(objectArray[i]);
            if (i == objectArray.length - 1) continue;
            this.stringBuilder.append(", ");
        }
        this.stringBuilder.append("});\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitJumpInsn(int n, Label label) {
        this.stringBuilder.setLength(0);
        this.declareLabel(label);
        this.stringBuilder.append(this.name).append(".visitJumpInsn(").append(OPCODES[n]).append(", ");
        this.appendLabel(label);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitLabel(Label label) {
        this.stringBuilder.setLength(0);
        this.declareLabel(label);
        this.stringBuilder.append(this.name).append(".visitLabel(");
        this.appendLabel(label);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitLdcInsn(Object object) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitLdcInsn(");
        this.appendConstant(object);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitIincInsn(int n, int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitIincInsn(").append(n).append(", ").append(n2).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitTableSwitchInsn(int n, int n2, Label label, Label ... labelArray) {
        int n3;
        this.stringBuilder.setLength(0);
        for (n3 = 0; n3 < labelArray.length; ++n3) {
            this.declareLabel(labelArray[n3]);
        }
        this.declareLabel(label);
        this.stringBuilder.append(this.name).append(".visitTableSwitchInsn(").append(n).append(", ").append(n2).append(", ");
        this.appendLabel(label);
        this.stringBuilder.append(", new Label[] {");
        for (n3 = 0; n3 < labelArray.length; ++n3) {
            this.stringBuilder.append(n3 == 0 ? " " : ", ");
            this.appendLabel(labelArray[n3]);
        }
        this.stringBuilder.append(END_ARRAY);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        int n;
        this.stringBuilder.setLength(0);
        for (n = 0; n < labelArray.length; ++n) {
            this.declareLabel(labelArray[n]);
        }
        this.declareLabel(label);
        this.stringBuilder.append(this.name).append(".visitLookupSwitchInsn(");
        this.appendLabel(label);
        this.stringBuilder.append(", new int[] {");
        for (n = 0; n < nArray.length; ++n) {
            this.stringBuilder.append(n == 0 ? " " : ", ").append(nArray[n]);
        }
        this.stringBuilder.append(" }, new Label[] {");
        for (n = 0; n < labelArray.length; ++n) {
            this.stringBuilder.append(n == 0 ? " " : ", ");
            this.appendLabel(labelArray[n]);
        }
        this.stringBuilder.append(END_ARRAY);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitMultiANewArrayInsn(String string, int n) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitMultiANewArrayInsn(");
        this.appendConstant(string);
        this.stringBuilder.append(", ").append(n).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public ASMifier visitInsnAnnotation(int n, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation("visitInsnAnnotation", n, typePath, string, bl);
    }

    @Override
    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.stringBuilder.setLength(0);
        this.declareLabel(label);
        this.declareLabel(label2);
        this.declareLabel(label3);
        this.stringBuilder.append(this.name).append(".visitTryCatchBlock(");
        this.appendLabel(label);
        this.stringBuilder.append(", ");
        this.appendLabel(label2);
        this.stringBuilder.append(", ");
        this.appendLabel(label3);
        this.stringBuilder.append(", ");
        this.appendConstant(string);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public ASMifier visitTryCatchAnnotation(int n, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation("visitTryCatchAnnotation", n, typePath, string, bl);
    }

    @Override
    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitLocalVariable(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(", ");
        this.appendLabel(label);
        this.stringBuilder.append(", ");
        this.appendLabel(label2);
        this.stringBuilder.append(", ").append(n).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public Printer visitLocalVariableAnnotation(int n, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl) {
        int n2;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.name).append(".visitLocalVariableAnnotation(").append(n);
        if (typePath == null) {
            this.stringBuilder.append(", null, ");
        } else {
            this.stringBuilder.append(", TypePath.fromString(\"").append(typePath).append("\"), ");
        }
        this.stringBuilder.append("new Label[] {");
        for (n2 = 0; n2 < labelArray.length; ++n2) {
            this.stringBuilder.append(n2 == 0 ? " " : ", ");
            this.appendLabel(labelArray[n2]);
        }
        this.stringBuilder.append(" }, new Label[] {");
        for (n2 = 0; n2 < labelArray2.length; ++n2) {
            this.stringBuilder.append(n2 == 0 ? " " : ", ");
            this.appendLabel(labelArray2[n2]);
        }
        this.stringBuilder.append(" }, new int[] {");
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.stringBuilder.append(n2 == 0 ? " " : ", ").append(nArray[n2]);
        }
        this.stringBuilder.append(" }, ");
        this.appendConstant(string);
        this.stringBuilder.append(", ").append(bl).append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    @Override
    public void visitLineNumber(int n, Label label) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitLineNumber(").append(n).append(", ");
        this.appendLabel(label);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitMaxs(int n, int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitMaxs(").append(n).append(", ").append(n2).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitMethodEnd() {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(VISIT_END);
        this.text.add(this.stringBuilder.toString());
    }

    public ASMifier visitAnnotation(String string, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.name).append(".visitAnnotation(");
        this.appendConstant(string);
        this.stringBuilder.append(", ").append(bl).append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    public ASMifier visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation("visitTypeAnnotation", n, typePath, string, bl);
    }

    public ASMifier visitTypeAnnotation(String string, int n, TypePath typePath, String string2, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.name).append(".").append(string).append("(").append(n);
        if (typePath == null) {
            this.stringBuilder.append(", null, ");
        } else {
            this.stringBuilder.append(", TypePath.fromString(\"").append(typePath).append("\"), ");
        }
        this.appendConstant(string2);
        this.stringBuilder.append(", ").append(bl).append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    public void visitAttribute(Attribute attribute) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("// ATTRIBUTE ").append(attribute.type).append('\n');
        if (attribute instanceof ASMifiable) {
            if (this.labelNames == null) {
                this.labelNames = new HashMap<Label, String>();
            }
            this.stringBuilder.append("{\n");
            StringBuffer stringBuffer = new StringBuffer();
            ((ASMifiable)((Object)attribute)).asmify(stringBuffer, "attribute", this.labelNames);
            this.stringBuilder.append(stringBuffer.toString());
            this.stringBuilder.append(this.name).append(".visitAttribute(attribute);\n");
            this.stringBuilder.append("}\n");
        }
        this.text.add(this.stringBuilder.toString());
    }

    protected ASMifier createASMifier(String string, int n) {
        return new ASMifier(393216, string, n);
    }

    private void appendAccessFlags(int n) {
        boolean bl = true;
        if ((n & 1) != 0) {
            this.stringBuilder.append("ACC_PUBLIC");
            bl = false;
        }
        if ((n & 2) != 0) {
            this.stringBuilder.append("ACC_PRIVATE");
            bl = false;
        }
        if ((n & 4) != 0) {
            this.stringBuilder.append("ACC_PROTECTED");
            bl = false;
        }
        if ((n & 0x10) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            if ((n & 0x200000) == 0) {
                this.stringBuilder.append("ACC_FINAL");
            } else {
                this.stringBuilder.append("ACC_TRANSITIVE");
            }
            bl = false;
        }
        if ((n & 8) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_STATIC");
            bl = false;
        }
        if ((n & 0x20) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            if ((n & 0x40000) == 0) {
                if ((n & 0x200000) == 0) {
                    this.stringBuilder.append("ACC_SYNCHRONIZED");
                } else {
                    this.stringBuilder.append("ACC_TRANSITIVE");
                }
            } else {
                this.stringBuilder.append("ACC_SUPER");
            }
            bl = false;
        }
        if ((n & 0x40) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            if ((n & 0x80000) == 0) {
                if ((n & 0x200000) == 0) {
                    this.stringBuilder.append("ACC_BRIDGE");
                } else {
                    this.stringBuilder.append("ACC_STATIC_PHASE");
                }
            } else {
                this.stringBuilder.append("ACC_VOLATILE");
            }
            bl = false;
        }
        if ((n & 0x80) != 0 && (n & 0xC0000) == 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_VARARGS");
            bl = false;
        }
        if ((n & 0x80) != 0 && (n & 0x80000) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_TRANSIENT");
            bl = false;
        }
        if ((n & 0x100) != 0 && (n & 0xC0000) == 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_NATIVE");
            bl = false;
        }
        if ((n & 0x4000) != 0 && (n & 0x1C0000) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_ENUM");
            bl = false;
        }
        if ((n & 0x2000) != 0 && (n & 0x140000) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_ANNOTATION");
            bl = false;
        }
        if ((n & 0x400) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_ABSTRACT");
            bl = false;
        }
        if ((n & 0x200) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_INTERFACE");
            bl = false;
        }
        if ((n & 0x800) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_STRICT");
            bl = false;
        }
        if ((n & 0x1000) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_SYNTHETIC");
            bl = false;
        }
        if ((n & 0x20000) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_DEPRECATED");
            bl = false;
        }
        if ((n & 0x8000) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            if ((n & 0x40000) == 0) {
                this.stringBuilder.append("ACC_MANDATED");
            } else {
                this.stringBuilder.append("ACC_MODULE");
            }
            bl = false;
        }
        if (bl) {
            this.stringBuilder.append('0');
        }
    }

    protected void appendConstant(Object object) {
        if (object == null) {
            this.stringBuilder.append("null");
        } else if (object instanceof String) {
            ASMifier.appendString(this.stringBuilder, (String)object);
        } else if (object instanceof Type) {
            this.stringBuilder.append("Type.getType(\"");
            this.stringBuilder.append(((Type)object).getDescriptor());
            this.stringBuilder.append("\")");
        } else if (object instanceof Handle) {
            this.stringBuilder.append("new Handle(");
            Handle handle = (Handle)object;
            this.stringBuilder.append("Opcodes.").append(HANDLE_TAG[handle.getTag()]).append(", \"");
            this.stringBuilder.append(handle.getOwner()).append("\", \"");
            this.stringBuilder.append(handle.getName()).append("\", \"");
            this.stringBuilder.append(handle.getDesc()).append("\", ");
            this.stringBuilder.append(handle.isInterface()).append(")");
        } else if (object instanceof Byte) {
            this.stringBuilder.append("new Byte((byte)").append(object).append(')');
        } else if (object instanceof Boolean) {
            this.stringBuilder.append((Boolean)object != false ? "Boolean.TRUE" : "Boolean.FALSE");
        } else if (object instanceof Short) {
            this.stringBuilder.append("new Short((short)").append(object).append(')');
        } else if (object instanceof Character) {
            this.stringBuilder.append("new Character((char)").append((int)((Character)object).charValue()).append(')');
        } else if (object instanceof Integer) {
            this.stringBuilder.append("new Integer(").append(object).append(')');
        } else if (object instanceof Float) {
            this.stringBuilder.append("new Float(\"").append(object).append("\")");
        } else if (object instanceof Long) {
            this.stringBuilder.append("new Long(").append(object).append("L)");
        } else if (object instanceof Double) {
            this.stringBuilder.append("new Double(\"").append(object).append("\")");
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.stringBuilder.append("new byte[] {");
            for (int i = 0; i < byArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(byArray[i]);
            }
            this.stringBuilder.append('}');
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            this.stringBuilder.append("new boolean[] {");
            for (int i = 0; i < blArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(blArray[i]);
            }
            this.stringBuilder.append('}');
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            this.stringBuilder.append("new short[] {");
            for (int i = 0; i < sArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append("(short)").append(sArray[i]);
            }
            this.stringBuilder.append('}');
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            this.stringBuilder.append("new char[] {");
            for (int i = 0; i < cArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append("(char)").append((int)cArray[i]);
            }
            this.stringBuilder.append('}');
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            this.stringBuilder.append("new int[] {");
            for (int i = 0; i < nArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(nArray[i]);
            }
            this.stringBuilder.append('}');
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            this.stringBuilder.append("new long[] {");
            for (int i = 0; i < lArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(lArray[i]).append('L');
            }
            this.stringBuilder.append('}');
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            this.stringBuilder.append("new float[] {");
            for (int i = 0; i < fArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(fArray[i]).append('f');
            }
            this.stringBuilder.append('}');
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            this.stringBuilder.append("new double[] {");
            for (int i = 0; i < dArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(dArray[i]).append('d');
            }
            this.stringBuilder.append('}');
        }
    }

    private void declareFrameTypes(int n, Object[] objectArray) {
        for (int i = 0; i < n; ++i) {
            if (!(objectArray[i] instanceof Label)) continue;
            this.declareLabel((Label)objectArray[i]);
        }
    }

    private void appendFrameTypes(int n, Object[] objectArray) {
        block9: for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.stringBuilder.append(", ");
            }
            if (objectArray[i] instanceof String) {
                this.appendConstant(objectArray[i]);
                continue;
            }
            if (objectArray[i] instanceof Integer) {
                switch ((Integer)objectArray[i]) {
                    case 0: {
                        this.stringBuilder.append("Opcodes.TOP");
                        continue block9;
                    }
                    case 1: {
                        this.stringBuilder.append("Opcodes.INTEGER");
                        continue block9;
                    }
                    case 2: {
                        this.stringBuilder.append("Opcodes.FLOAT");
                        continue block9;
                    }
                    case 3: {
                        this.stringBuilder.append("Opcodes.DOUBLE");
                        continue block9;
                    }
                    case 4: {
                        this.stringBuilder.append("Opcodes.LONG");
                        continue block9;
                    }
                    case 5: {
                        this.stringBuilder.append("Opcodes.NULL");
                        continue block9;
                    }
                    case 6: {
                        this.stringBuilder.append("Opcodes.UNINITIALIZED_THIS");
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            this.appendLabel((Label)objectArray[i]);
        }
    }

    protected void declareLabel(Label label) {
        String string;
        if (this.labelNames == null) {
            this.labelNames = new HashMap<Label, String>();
        }
        if ((string = this.labelNames.get(label)) == null) {
            string = "label" + this.labelNames.size();
            this.labelNames.put(label, string);
            this.stringBuilder.append("Label ").append(string).append(" = new Label();\n");
        }
    }

    protected void appendLabel(Label label) {
        this.stringBuilder.append(this.labelNames.get(label));
    }

    static {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(196653, "V1_1");
        hashMap.put(46, "V1_2");
        hashMap.put(47, "V1_3");
        hashMap.put(48, "V1_4");
        hashMap.put(49, "V1_5");
        hashMap.put(50, "V1_6");
        hashMap.put(51, "V1_7");
        hashMap.put(52, "V1_8");
        hashMap.put(53, "V9");
        hashMap.put(54, "V10");
        CLASS_VERSIONS = Collections.unmodifiableMap(hashMap);
    }
}

