/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.search.persistentSearch;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.controls.search.persistentSearch.PersistentSearchContainer;
import org.apache.directory.api.ldap.model.message.controls.ChangeType;
import org.apache.directory.api.ldap.model.message.controls.PersistentSearch;
import org.apache.directory.api.ldap.model.message.controls.PersistentSearchImpl;

public class PersistentSearchDecorator
extends ControlDecorator<PersistentSearch>
implements PersistentSearch {
    private int psearchSeqLength;
    private static final Asn1Decoder DECODER = new Asn1Decoder();

    public PersistentSearchDecorator(LdapApiService codec) {
        this(codec, (PersistentSearch)new PersistentSearchImpl());
    }

    public PersistentSearchDecorator(LdapApiService codec, PersistentSearch control) {
        super(codec, control);
    }

    public int computeLength() {
        int changeTypesLength = 2 + BerValue.getNbBytes((int)this.getChangeTypes());
        int changesOnlyLength = 3;
        int returnRCsLength = 3;
        this.psearchSeqLength = changeTypesLength + changesOnlyLength + returnRCsLength;
        return 1 + TLV.getNbBytes((int)this.psearchSeqLength) + this.psearchSeqLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_08000_CANNOT_PUT_A_PDU_IN_NULL_BUFFER, (Object[])new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes((int)this.psearchSeqLength));
        BerValue.encode((ByteBuffer)buffer, (int)this.getChangeTypes());
        BerValue.encode((ByteBuffer)buffer, (boolean)this.isChangesOnly());
        BerValue.encode((ByteBuffer)buffer, (boolean)this.isReturnECs());
        return buffer;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.valueLength = this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put(UniversalTag.SEQUENCE.getValue());
                buffer.put(TLV.getBytes((int)this.psearchSeqLength));
                BerValue.encode((ByteBuffer)buffer, (int)this.getChangeTypes());
                BerValue.encode((ByteBuffer)buffer, (boolean)this.isChangesOnly());
                BerValue.encode((ByteBuffer)buffer, (boolean)this.isReturnECs());
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    private PersistentSearch getPersistentSearch() {
        return (PersistentSearch)this.getDecorated();
    }

    public void setChangesOnly(boolean changesOnly) {
        this.getPersistentSearch().setChangesOnly(changesOnly);
    }

    public boolean isChangesOnly() {
        return this.getPersistentSearch().isChangesOnly();
    }

    public void setReturnECs(boolean returnECs) {
        this.getPersistentSearch().setReturnECs(returnECs);
    }

    public boolean isReturnECs() {
        return this.getPersistentSearch().isReturnECs();
    }

    public void setChangeTypes(int changeTypes) {
        this.getPersistentSearch().setChangeTypes(changeTypes);
    }

    public int getChangeTypes() {
        return this.getPersistentSearch().getChangeTypes();
    }

    public boolean isNotificationEnabled(ChangeType changeType) {
        return this.getPersistentSearch().isNotificationEnabled(changeType);
    }

    public void enableNotification(ChangeType changeType) {
        this.getPersistentSearch().enableNotification(changeType);
    }

    public void disableNotification(ChangeType changeType) {
        this.getPersistentSearch().disableNotification(changeType);
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        PersistentSearchContainer container = new PersistentSearchContainer(this.getCodecService(), this);
        DECODER.decode(bb, (Asn1Container)container);
        return this;
    }
}

