/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.writer.ProgressCodeWriter;
import com.sun.istack.tools.DefaultAuthenticator;
import com.sun.tools.ws.ToolVersion;
import com.sun.tools.ws.api.TJavaGeneratorExtension;
import com.sun.tools.ws.processor.generator.CustomExceptionGenerator;
import com.sun.tools.ws.processor.generator.GeneratorBase;
import com.sun.tools.ws.processor.generator.JwsImplGenerator;
import com.sun.tools.ws.processor.generator.SeiGenerator;
import com.sun.tools.ws.processor.generator.ServiceGenerator;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.modeler.wsdl.ConsoleErrorReporter;
import com.sun.tools.ws.processor.modeler.wsdl.WSDLModeler;
import com.sun.tools.ws.processor.util.DirectoryUtil;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.resources.WsdlMessages;
import com.sun.tools.ws.util.WSDLFetcher;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.ErrorReceiverFilter;
import com.sun.tools.ws.wscompile.FilerCodeWriter;
import com.sun.tools.ws.wscompile.JavaCompilerHelper;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wscompile.Plugin;
import com.sun.tools.ws.wscompile.WSCodeWriter;
import com.sun.tools.ws.wscompile.WsimportListener;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wsdl.parser.MetadataFinder;
import com.sun.tools.ws.wsdl.parser.WSDLInternalizationLogic;
import com.sun.tools.xjc.util.NullStream;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.util.ServiceFinder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.EntityResolver;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class WsimportTool {
    private static final String JAXWS_MODULE = "java.xml.ws";
    private static final String WSIMPORT = "wsimport";
    private final PrintStream out;
    private final Container container;
    protected WsimportOptions options = new WsimportOptions();

    public WsimportTool(OutputStream outputStream) {
        this(outputStream, null);
    }

    public WsimportTool(OutputStream outputStream, Container container) {
        this.out = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
        this.container = container;
    }

    public boolean run(String[] stringArray) {
        Listener listener = new Listener();
        Receiver receiver = new Receiver(listener);
        return this.run(stringArray, listener, receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean run(String[] stringArray, Listener listener, Receiver receiver) {
        int n;
        for (String string : stringArray) {
            if (string.equals("-version")) {
                listener.message(WscompileMessages.WSIMPORT_VERSION(ToolVersion.VERSION.MAJOR_VERSION));
                return true;
            }
            if (!string.equals("-fullversion")) continue;
            listener.message(WscompileMessages.WSIMPORT_FULLVERSION(ToolVersion.VERSION.toString()));
            return true;
        }
        try {
            Model iOException;
            block25: {
                this.parseArguments(stringArray, listener, receiver);
                try {
                    iOException = this.buildWsdlModel(listener, receiver);
                    if (iOException != null) break block25;
                    n = 0;
                    return n != 0;
                }
                catch (IOException xMLStreamException) {
                    receiver.error(xMLStreamException);
                    n = 0;
                    return n != 0;
                }
                catch (XMLStreamException bl) {
                    receiver.error(bl);
                    n = 0;
                    return n != 0;
                }
            }
            if (!this.generateCode(listener, receiver, iOException, true)) {
                n = 0;
                return n != 0;
            }
            if (!this.options.nocompile && !this.compileGeneratedClasses(receiver, listener)) {
                listener.message(WscompileMessages.WSCOMPILE_COMPILATION_FAILED());
                boolean iOException2 = false;
                return iOException2;
            }
            try {
                if (this.options.clientjar != null) {
                    this.addClassesToGeneratedFiles();
                    this.jarArtifacts(listener);
                }
            }
            catch (IOException weAreDone) {
                receiver.error(weAreDone);
                n = 0;
                this.deleteGeneratedFiles();
                if (!this.options.disableAuthenticator) {
                    DefaultAuthenticator.reset();
                }
                return n != 0;
            }
        }
        catch (Options.WeAreDone badCommandLineException) {
            this.usage(badCommandLineException.getOptions());
        }
        catch (BadCommandLineException badCommandLineException) {
            if (badCommandLineException.getMessage() != null) {
                System.out.println(badCommandLineException.getMessage());
                System.out.println();
            }
            this.usage(badCommandLineException.getOptions());
            n = 0;
            return n != 0;
        }
        finally {
            this.deleteGeneratedFiles();
            if (!this.options.disableAuthenticator) {
                DefaultAuthenticator.reset();
            }
        }
        return !receiver.hadError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void deleteGeneratedFiles() {
        HashSet<File> hashSet = new HashSet<File>();
        if (this.options.clientjar != null) {
            boolean bl;
            Iterable<File> iterable = this.options.getGeneratedFiles();
            Iterable<File> iterable2 = iterable;
            synchronized (iterable2) {
                for (File file2 : iterable) {
                    if (file2.getName().endsWith(".java")) continue;
                    bl = file2.delete();
                    if (this.options.verbose && !bl) {
                        System.out.println(MessageFormat.format("{0} could not be deleted.", file2));
                    }
                    hashSet.add(file2.getParentFile());
                }
            }
            for (File file : hashSet) {
                void var4_7;
                while (var4_7.list() != null && var4_7.list().length == 0 && !var4_7.equals(this.options.destDir)) {
                    File file2;
                    file2 = var4_7.getParentFile();
                    bl = var4_7.delete();
                    if (this.options.verbose && !bl) {
                        System.out.println(MessageFormat.format("{0} could not be deleted.", var4_7));
                    }
                    File file3 = file2;
                }
            }
        }
        if (!this.options.keep) {
            this.options.removeGeneratedFiles();
        }
    }

    private void addClassesToGeneratedFiles() throws IOException {
        Iterable<File> iterable = this.options.getGeneratedFiles();
        final ArrayList arrayList = new ArrayList();
        for (File file : iterable) {
            if (!file.getName().endsWith(".java")) continue;
            String string = DirectoryUtil.getRelativePathfromCommonBase(file.getParentFile(), this.options.sourceDir);
            final String string2 = file.getName().substring(0, file.getName().indexOf(".java"));
            File file2 = new File(this.options.destDir, string);
            if (!file2.exists()) continue;
            file2.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    if (string.equals(string2 + ".class") || string.startsWith(string2 + "$") && string.endsWith(".class")) {
                        arrayList.add(new File(file, string));
                        return true;
                    }
                    return false;
                }
            });
        }
        for (File file : arrayList) {
            this.options.addGeneratedFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jarArtifacts(WsimportListener wsimportListener) throws IOException {
        File file = new File(this.options.clientjar);
        if (!file.isAbsolute()) {
            file = new File(this.options.destDir, this.options.clientjar);
        }
        if (!this.options.quiet) {
            wsimportListener.message(WscompileMessages.WSIMPORT_ARCHIVING_ARTIFACTS(file));
        }
        BufferedInputStream bufferedInputStream = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JarOutputStream jarOutputStream = new JarOutputStream(fileOutputStream);
        try {
            String string = this.options.destDir.getCanonicalPath();
            for (File file2 : this.options.getGeneratedFiles()) {
                int n;
                if (file2.getName().endsWith(".java")) continue;
                if (this.options.verbose) {
                    wsimportListener.message(WscompileMessages.WSIMPORT_ARCHIVE_ARTIFACT(file2, this.options.clientjar));
                }
                String string2 = file2.getCanonicalPath().substring(string.length() + 1).replace(File.separatorChar, '/');
                fileInputStream = new FileInputStream(file2);
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                JarEntry jarEntry = new JarEntry(string2);
                jarOutputStream.putNextEntry(jarEntry);
                byte[] byArray = new byte[1024];
                while ((n = bufferedInputStream.read(byArray)) != -1) {
                    jarOutputStream.write(byArray, 0, n);
                }
            }
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            finally {
                if (jarOutputStream != null) {
                    jarOutputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }
    }

    protected void parseArguments(String[] stringArray, Listener listener, Receiver receiver) throws BadCommandLineException {
        this.options.parseArguments(stringArray);
        this.options.validate();
        if (this.options.debugMode) {
            listener.enableDebugging();
        }
        this.options.parseBindings(receiver);
    }

    protected Model buildWsdlModel(Listener listener, final Receiver receiver) throws BadCommandLineException, XMLStreamException, IOException {
        WSDLModeler wSDLModeler;
        Model model;
        Object object;
        if (!this.options.disableAuthenticator) {
            /*
             * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
             */
            class AuthListener
            implements DefaultAuthenticator.Receiver {
                private final boolean isFatal;

                AuthListener(boolean bl) {
                    this.isFatal = bl;
                }

                public void onParsingError(String string, Locator locator) {
                    this.error(new SAXParseException(WscompileMessages.WSIMPORT_ILLEGAL_AUTH_INFO(string), locator));
                }

                public void onError(Exception exception, Locator locator) {
                    if (exception instanceof FileNotFoundException) {
                        this.error(new SAXParseException(WscompileMessages.WSIMPORT_AUTH_FILE_NOT_FOUND(locator.getSystemId(), WsimportOptions.defaultAuthfile), null));
                    } else {
                        this.error(new SAXParseException(WscompileMessages.WSIMPORT_FAILED_TO_PARSE(locator.getSystemId(), exception.getMessage()), locator));
                    }
                }

                private void error(SAXParseException sAXParseException) {
                    if (this.isFatal) {
                        receiver.error(sAXParseException);
                    } else {
                        receiver.debug(sAXParseException);
                    }
                }
            }
            object = DefaultAuthenticator.getAuthenticator();
            if (this.options.proxyAuth != null) {
                object.setProxyAuth(this.options.proxyAuth);
            }
            if (this.options.authFile != null) {
                object.setAuth(this.options.authFile, (DefaultAuthenticator.Receiver)new AuthListener(true));
            } else {
                object.setAuth(new File(WsimportOptions.defaultAuthfile), (DefaultAuthenticator.Receiver)new AuthListener(false));
            }
        }
        if (!this.options.quiet) {
            listener.message(WscompileMessages.WSIMPORT_PARSING_WSDL());
        }
        object = new MetadataFinder(new WSDLInternalizationLogic(), this.options, receiver);
        ((MetadataFinder)object).parseWSDL();
        if (((MetadataFinder)object).isMexMetadata) {
            receiver.reset();
        }
        if ((model = (wSDLModeler = new WSDLModeler(this.options, receiver, (MetadataFinder)object)).buildModel()) == null) {
            listener.message(WsdlMessages.PARSING_PARSE_FAILED());
        }
        if (this.options.clientjar != null) {
            if (!this.options.quiet) {
                listener.message(WscompileMessages.WSIMPORT_FETCHING_METADATA());
            }
            this.options.wsdlLocation = new WSDLFetcher(this.options, listener).fetchWsdls((MetadataFinder)object);
        }
        return model;
    }

    protected boolean generateCode(Listener listener, Receiver receiver, Model model, boolean bl) throws IOException {
        Object object2;
        if (!this.options.quiet) {
            listener.message(WscompileMessages.WSIMPORT_GENERATING_CODE());
        }
        TJavaGeneratorExtension[] tJavaGeneratorExtensionArray = (TJavaGeneratorExtension[])ServiceFinder.find(TJavaGeneratorExtension.class).toArray();
        CustomExceptionGenerator.generate(model, this.options, receiver);
        SeiGenerator.generate(model, this.options, receiver, tJavaGeneratorExtensionArray);
        if (receiver.hadError()) {
            throw new AbortException();
        }
        if (bl) {
            ServiceGenerator.generate(model, this.options, receiver);
        }
        for (Object object2 : ServiceFinder.find(GeneratorBase.class)) {
            ((GeneratorBase)object2).init(model, this.options, receiver);
            ((GeneratorBase)object2).doGeneration();
        }
        Object object3 = null;
        if (this.options.isGenerateJWS) {
            object3 = JwsImplGenerator.generate(model, this.options, receiver);
        }
        for (Plugin plugin : this.options.activePlugins) {
            try {
                plugin.run(model, this.options, receiver);
            }
            catch (SAXException sAXException) {
                return false;
            }
        }
        if (this.options.getModuleName() != null) {
            this.options.getCodeModel()._prepareModuleInfo(this.options.getModuleName(), new String[]{JAXWS_MODULE});
        }
        object2 = this.options.filer != null ? new FilerCodeWriter(this.options) : new WSCodeWriter(this.options.sourceDir, this.options);
        if (this.options.verbose) {
            object2 = new ProgressCodeWriter((CodeWriter)object2, this.out);
        }
        this.options.getCodeModel().build((CodeWriter)object2);
        if (this.options.isGenerateJWS) {
            return JwsImplGenerator.moveToImplDestDir((List<String>)object3, this.options, receiver);
        }
        return true;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.options.entityResolver = entityResolver;
    }

    protected boolean compileGeneratedClasses(ErrorReceiver errorReceiver, WsimportListener wsimportListener) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File object : this.options.getGeneratedFiles()) {
            if (!object.exists() || !object.getName().endsWith(".java")) continue;
            arrayList.add(object.getAbsolutePath());
        }
        if (arrayList.size() > 0) {
            String string = this.options.destDir.getAbsolutePath();
            String string2 = this.createClasspathString();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add("-d");
            arrayList2.add(string);
            arrayList2.add("-classpath");
            arrayList2.add(string2);
            if (this.options.debug) {
                arrayList2.add("-g");
            }
            if (this.options.encoding != null) {
                arrayList2.add("-encoding");
                arrayList2.add(this.options.encoding);
            }
            if (this.options.javacOptions != null) {
                List<String> i = this.options.getJavacOptions(arrayList2, wsimportListener);
                arrayList2.addAll(i);
            }
            for (int stringBuilder = 0; stringBuilder < arrayList.size(); ++stringBuilder) {
                arrayList2.add((String)arrayList.get(stringBuilder));
            }
            if (!this.options.quiet) {
                wsimportListener.message(WscompileMessages.WSIMPORT_COMPILING_CODE());
            }
            if (this.options.verbose) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string3 : arrayList2) {
                    stringBuilder.append(string3).append(" ");
                }
                wsimportListener.message("javac " + stringBuilder.toString());
            }
            return JavaCompilerHelper.compile(arrayList2.toArray(new String[arrayList2.size()]), this.out, errorReceiver);
        }
        return true;
    }

    private String createClasspathString() {
        StringBuilder stringBuilder = new StringBuilder(System.getProperty("java.class.path"));
        for (String string : this.options.cmdlineJars) {
            stringBuilder.append(File.pathSeparator);
            stringBuilder.append(new File(string).toString());
        }
        return stringBuilder.toString();
    }

    protected void usage(Options options) {
        System.out.println(WscompileMessages.WSIMPORT_HELP(WSIMPORT));
        System.out.println(WscompileMessages.WSIMPORT_USAGE_EXTENSIONS());
        System.out.println(WscompileMessages.WSIMPORT_USAGE_EXAMPLES());
    }

    private float getVersion(String string) {
        return Float.parseFloat(string);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected class Receiver
    extends ErrorReceiverFilter {
        private Listener listener;

        public Receiver(Listener listener) {
            super(listener);
            this.listener = listener;
        }

        @Override
        public void info(SAXParseException sAXParseException) {
            if (WsimportTool.this.options.verbose) {
                super.info(sAXParseException);
            }
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            if (!WsimportTool.this.options.quiet) {
                super.warning(sAXParseException);
            }
        }

        @Override
        public void pollAbort() throws AbortException {
            if (this.listener.isCanceled()) {
                throw new AbortException();
            }
        }

        @Override
        public void debug(SAXParseException sAXParseException) {
            if (WsimportTool.this.options.debugMode) {
                this.listener.debug(sAXParseException);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected class Listener
    extends WsimportListener {
        ConsoleErrorReporter cer;

        protected Listener() {
            this.cer = new ConsoleErrorReporter(WsimportTool.this.out == null ? new PrintStream((OutputStream)new NullStream()) : WsimportTool.this.out);
        }

        @Override
        public void generatedFile(String string) {
            this.message(string);
        }

        @Override
        public void message(String string) {
            WsimportTool.this.out.println(string);
        }

        @Override
        public void error(SAXParseException sAXParseException) {
            this.cer.error(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) {
            this.cer.fatalError(sAXParseException);
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            this.cer.warning(sAXParseException);
        }

        @Override
        public void debug(SAXParseException sAXParseException) {
            this.cer.debug(sAXParseException);
        }

        @Override
        public void info(SAXParseException sAXParseException) {
            this.cer.info(sAXParseException);
        }

        public void enableDebugging() {
            this.cer.enableDebugging();
        }
    }
}

