/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.osgi;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.ExtendedResponse;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.BasicControlDecorator;
import org.apache.directory.api.ldap.codec.api.CodecControl;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.IntermediateResponseFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.controls.cascade.CascadeFactory;
import org.apache.directory.api.ldap.codec.controls.manageDsaIT.ManageDsaITFactory;
import org.apache.directory.api.ldap.codec.controls.proxiedauthz.ProxiedAuthzFactory;
import org.apache.directory.api.ldap.codec.controls.search.entryChange.EntryChangeFactory;
import org.apache.directory.api.ldap.codec.controls.search.pagedSearch.PagedResultsFactory;
import org.apache.directory.api.ldap.codec.controls.search.persistentSearch.PersistentSearchFactory;
import org.apache.directory.api.ldap.codec.controls.search.subentries.SubentriesFactory;
import org.apache.directory.api.ldap.codec.controls.sort.SortRequestFactory;
import org.apache.directory.api.ldap.codec.controls.sort.SortResponseFactory;
import org.apache.directory.api.ldap.codec.decorators.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.decorators.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.codec.decorators.IntermediateResponseDecorator;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedRequestImpl;
import org.apache.directory.api.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.directory.api.ldap.model.message.IntermediateResponseImpl;
import org.apache.directory.api.ldap.model.message.controls.OpaqueControl;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.exception.NotImplementedException;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLdapCodecService
implements LdapApiService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLdapCodecService.class);
    private Map<String, ControlFactory<? extends Control>> controlFactories = new HashMap<String, ControlFactory<? extends Control>>();
    private Map<String, ExtendedOperationFactory> extendedOperationFactories = new HashMap<String, ExtendedOperationFactory>();
    private Map<String, IntermediateResponseFactory> intermediateResponseFactories = new HashMap<String, IntermediateResponseFactory>();
    private ProtocolCodecFactory protocolCodecFactory;

    public DefaultLdapCodecService() {
        this.loadStockControls();
    }

    private void loadStockControls() {
        CascadeFactory cascadeFactory = new CascadeFactory(this);
        this.controlFactories.put(cascadeFactory.getOid(), cascadeFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg((I18n)I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, (Object[])new Object[]{cascadeFactory.getOid()}));
        }
        EntryChangeFactory entryChangeFactory = new EntryChangeFactory(this);
        this.controlFactories.put(entryChangeFactory.getOid(), entryChangeFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg((I18n)I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, (Object[])new Object[]{entryChangeFactory.getOid()}));
        }
        ManageDsaITFactory manageDsaItFactory = new ManageDsaITFactory(this);
        this.controlFactories.put(manageDsaItFactory.getOid(), manageDsaItFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg((I18n)I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, (Object[])new Object[]{manageDsaItFactory.getOid()}));
        }
        ProxiedAuthzFactory proxiedAuthzFactory = new ProxiedAuthzFactory(this);
        this.controlFactories.put(proxiedAuthzFactory.getOid(), proxiedAuthzFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg((I18n)I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, (Object[])new Object[]{proxiedAuthzFactory.getOid()}));
        }
        PagedResultsFactory pageResultsFactory = new PagedResultsFactory(this);
        this.controlFactories.put(pageResultsFactory.getOid(), pageResultsFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg((I18n)I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, (Object[])new Object[]{pageResultsFactory.getOid()}));
        }
        PersistentSearchFactory persistentSearchFactory = new PersistentSearchFactory(this);
        this.controlFactories.put(persistentSearchFactory.getOid(), persistentSearchFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg((I18n)I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, (Object[])new Object[]{persistentSearchFactory.getOid()}));
        }
        SubentriesFactory subentriesFactory = new SubentriesFactory(this);
        this.controlFactories.put(subentriesFactory.getOid(), subentriesFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg((I18n)I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, (Object[])new Object[]{subentriesFactory.getOid()}));
        }
        SortRequestFactory sortRequestFactory = new SortRequestFactory(this);
        this.controlFactories.put(sortRequestFactory.getOid(), sortRequestFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg((I18n)I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, (Object[])new Object[]{sortRequestFactory.getOid()}));
        }
        SortResponseFactory sortResponseFactory = new SortResponseFactory(this);
        this.controlFactories.put(sortResponseFactory.getOid(), sortResponseFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg((I18n)I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, (Object[])new Object[]{sortResponseFactory.getOid()}));
        }
    }

    @Override
    public ControlFactory<?> registerControl(ControlFactory<?> factory) {
        return this.controlFactories.put(factory.getOid(), factory);
    }

    @Override
    public ControlFactory<?> unregisterControl(String oid) {
        return this.controlFactories.remove(oid);
    }

    @Override
    public Iterator<String> registeredControls() {
        return Collections.unmodifiableSet(this.controlFactories.keySet()).iterator();
    }

    @Override
    public boolean isControlRegistered(String oid) {
        return this.controlFactories.containsKey(oid);
    }

    @Override
    public Iterator<String> registeredExtendedRequests() {
        return Collections.unmodifiableSet(this.extendedOperationFactories.keySet()).iterator();
    }

    @Override
    public ExtendedOperationFactory registerExtendedRequest(ExtendedOperationFactory factory) {
        return this.extendedOperationFactories.put(factory.getOid(), factory);
    }

    @Override
    public Iterator<String> registeredIntermediateResponses() {
        return Collections.unmodifiableSet(this.intermediateResponseFactories.keySet()).iterator();
    }

    @Override
    public IntermediateResponseFactory registerIntermediateResponse(IntermediateResponseFactory factory) {
        return this.intermediateResponseFactories.put(factory.getOid(), factory);
    }

    @Override
    public ProtocolCodecFactory getProtocolCodecFactory() {
        return this.protocolCodecFactory;
    }

    @Override
    public ProtocolCodecFactory registerProtocolCodecFactory(ProtocolCodecFactory protocolCodecFactory) {
        ProtocolCodecFactory oldFactory = this.protocolCodecFactory;
        this.protocolCodecFactory = protocolCodecFactory;
        return oldFactory;
    }

    @Override
    public CodecControl<? extends Control> newControl(String oid) {
        ControlFactory<? extends Control> factory = this.controlFactories.get(oid);
        if (factory == null) {
            return new BasicControlDecorator((LdapApiService)this, (Control)new OpaqueControl(oid));
        }
        return factory.newCodecControl();
    }

    @Override
    public CodecControl<? extends Control> newControl(Control control) {
        if (control == null) {
            throw new NullPointerException(I18n.err((I18n)I18n.ERR_05400_CONTROL_ARGUMENT_WAS_NULL, (Object[])new Object[0]));
        }
        if (control instanceof CodecControl) {
            return (CodecControl)control;
        }
        ControlFactory<? extends Control> factory = this.controlFactories.get(control.getOid());
        if (factory == null) {
            return new BasicControlDecorator((LdapApiService)this, control);
        }
        return factory.newCodecControl((Control)control);
    }

    @Override
    public javax.naming.ldap.Control toJndiControl(Control control) throws EncoderException {
        CodecControl<? extends Control> decorator = this.newControl(control);
        ByteBuffer bb = ByteBuffer.allocate(decorator.computeLength());
        decorator.encode(bb);
        bb.flip();
        return new BasicControl(control.getOid(), control.isCritical(), bb.array());
    }

    @Override
    public Control fromJndiControl(javax.naming.ldap.Control control) throws DecoderException {
        ControlFactory<? extends Control> factory = this.controlFactories.get(control.getID());
        if (factory == null) {
            OpaqueControl ourControl = new OpaqueControl(control.getID());
            ourControl.setCritical(control.isCritical());
            BasicControlDecorator decorator = new BasicControlDecorator((LdapApiService)this, (Control)ourControl);
            decorator.setValue(control.getEncodedValue());
            return decorator;
        }
        CodecControl<? extends Control> ourControl = factory.newCodecControl();
        ourControl.setCritical(control.isCritical());
        ourControl.setValue(control.getEncodedValue());
        ourControl.decode(control.getEncodedValue());
        return ourControl;
    }

    @Override
    public Asn1Container newMessageContainer() {
        return new LdapMessageContainer(this);
    }

    @Override
    public ExtendedOperationFactory unregisterExtendedRequest(String oid) {
        return this.extendedOperationFactories.remove(oid);
    }

    @Override
    public IntermediateResponseFactory unregisterIntermediateResponse(String oid) {
        return this.intermediateResponseFactories.remove(oid);
    }

    @Override
    public ExtendedResponse toJndi(org.apache.directory.api.ldap.model.message.ExtendedResponse modelResponse) throws EncoderException {
        throw new NotImplementedException(I18n.err((I18n)I18n.ERR_05401_FIGURE_OUT_HOW_TO_TRANSFORM, (Object[])new Object[0]));
    }

    @Override
    public org.apache.directory.api.ldap.model.message.ExtendedResponse fromJndi(ExtendedResponse jndiResponse) throws DecoderException {
        throw new NotImplementedException(I18n.err((I18n)I18n.ERR_05401_FIGURE_OUT_HOW_TO_TRANSFORM, (Object[])new Object[0]));
    }

    @Override
    public ExtendedRequest fromJndi(javax.naming.ldap.ExtendedRequest jndiRequest) throws DecoderException {
        return this.newExtendedRequest(jndiRequest.getID(), jndiRequest.getEncodedValue());
    }

    @Override
    public javax.naming.ldap.ExtendedRequest toJndi(final ExtendedRequest modelRequest) throws EncoderException {
        byte[] value;
        final String oid = modelRequest.getRequestName();
        if (modelRequest instanceof ExtendedRequestDecorator) {
            ExtendedRequestDecorator decorator = (ExtendedRequestDecorator)modelRequest;
            value = decorator.getRequestValue();
        } else {
            ExtendedOperationFactory extendedRequestFactory = this.extendedOperationFactories.get(modelRequest.getRequestName());
            ExtendedRequestDecorator decorator = (ExtendedRequestDecorator)extendedRequestFactory.decorate(modelRequest);
            value = decorator.getRequestValue();
        }
        return new javax.naming.ldap.ExtendedRequest(){
            private static final long serialVersionUID = -4160980385909987475L;

            @Override
            public String getID() {
                return oid;
            }

            @Override
            public byte[] getEncodedValue() {
                return value;
            }

            @Override
            public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
                ExtendedOperationFactory factory = (ExtendedOperationFactory)DefaultLdapCodecService.this.extendedOperationFactories.get(modelRequest.getRequestName());
                try {
                    final ExtendedResponseDecorator resp = (ExtendedResponseDecorator)factory.newResponse(berValue);
                    return new ExtendedResponse(){
                        private static final long serialVersionUID = -7686354122066100703L;

                        @Override
                        public String getID() {
                            return oid;
                        }

                        @Override
                        public byte[] getEncodedValue() {
                            return resp.getResponseValue();
                        }
                    };
                }
                catch (DecoderException de) {
                    NamingException ne = new NamingException(I18n.err((I18n)I18n.ERR_05402_UNABLE_TO_ENCODE_RESPONSE_VALUE, (Object[])new Object[]{Strings.dumpBytes((byte[])berValue)}));
                    ne.setRootCause(de);
                    throw ne;
                }
            }
        };
    }

    @Override
    public <E extends org.apache.directory.api.ldap.model.message.ExtendedResponse> E newExtendedResponse(String responseName, int messageId, byte[] serializedResponse) throws DecoderException {
        ExtendedResponseDecorator<ExtendedResponseImpl> resp;
        ExtendedOperationFactory extendedRequestFactory = this.extendedOperationFactories.get(responseName);
        if (extendedRequestFactory != null) {
            resp = (ExtendedResponseDecorator<ExtendedResponseImpl>)extendedRequestFactory.newResponse(serializedResponse);
        } else {
            resp = new ExtendedResponseDecorator<ExtendedResponseImpl>((LdapApiService)this, new ExtendedResponseImpl(responseName));
            resp.setResponseValue(serializedResponse);
            resp.setResponseName(responseName);
        }
        resp.setMessageId(messageId);
        return (E)resp;
    }

    @Override
    public ExtendedRequest newExtendedRequest(String oid, byte[] value) {
        ExtendedRequestDecorator<ExtendedRequestImpl> req;
        ExtendedOperationFactory extendedRequestFactory = this.extendedOperationFactories.get(oid);
        if (extendedRequestFactory != null) {
            req = extendedRequestFactory.newRequest(value);
        } else {
            ExtendedRequestDecorator<ExtendedRequestImpl> decorator = new ExtendedRequestDecorator<ExtendedRequestImpl>((LdapApiService)this, new ExtendedRequestImpl());
            decorator.setRequestName(oid);
            decorator.setRequestValue(value);
            req = decorator;
        }
        return req;
    }

    @Override
    public <I extends IntermediateResponse> I newIntermediateResponse(String responseName, int messageId, byte[] serializedResponse) throws DecoderException {
        IntermediateResponseDecorator<IntermediateResponseImpl> resp;
        IntermediateResponseFactory intermediateResponseFactory = this.intermediateResponseFactories.get(responseName);
        if (intermediateResponseFactory != null) {
            resp = (IntermediateResponseDecorator<IntermediateResponseImpl>)intermediateResponseFactory.newResponse(serializedResponse);
        } else {
            resp = new IntermediateResponseDecorator<IntermediateResponseImpl>((LdapApiService)this, new IntermediateResponseImpl(responseName));
            resp.setResponseValue(serializedResponse);
            resp.setResponseName(responseName);
        }
        resp.setMessageId(messageId);
        return (I)resp;
    }

    @Override
    public ExtendedRequestDecorator<?> decorate(ExtendedRequest decoratedMessage) {
        ExtendedOperationFactory extendedRequestFactory = this.extendedOperationFactories.get(decoratedMessage.getRequestName());
        ExtendedRequestDecorator<ExtendedRequest> req = extendedRequestFactory != null ? (ExtendedRequestDecorator<ExtendedRequest>)extendedRequestFactory.decorate(decoratedMessage) : new ExtendedRequestDecorator<ExtendedRequest>((LdapApiService)this, decoratedMessage);
        return req;
    }

    @Override
    public ExtendedResponseDecorator<?> decorate(org.apache.directory.api.ldap.model.message.ExtendedResponse decoratedMessage) {
        ExtendedOperationFactory extendedRequestFactory = this.extendedOperationFactories.get(decoratedMessage.getResponseName());
        if (extendedRequestFactory != null) {
            return (ExtendedResponseDecorator)extendedRequestFactory.decorate(decoratedMessage);
        }
        return new ExtendedResponseDecorator<org.apache.directory.api.ldap.model.message.ExtendedResponse>((LdapApiService)this, decoratedMessage);
    }

    @Override
    public IntermediateResponseDecorator<?> decorate(IntermediateResponse decoratedMessage) {
        IntermediateResponseFactory intermediateResponseFactory = this.intermediateResponseFactories.get(decoratedMessage.getResponseName());
        if (intermediateResponseFactory != null) {
            return (IntermediateResponseDecorator)intermediateResponseFactory.decorate(decoratedMessage);
        }
        return new IntermediateResponseDecorator<IntermediateResponse>((LdapApiService)this, decoratedMessage);
    }

    @Override
    public boolean isExtendedOperationRegistered(String oid) {
        return this.extendedOperationFactories.containsKey(oid);
    }

    @Override
    public boolean isIntermediateResponseRegistered(String oid) {
        return this.intermediateResponseFactories.containsKey(oid);
    }

    public Map<String, ControlFactory<? extends Control>> getControlFactories() {
        return this.controlFactories;
    }

    public void setControlFactories(Map<String, ControlFactory<? extends Control>> controlFactories) {
        this.controlFactories = controlFactories;
    }

    public Map<String, ExtendedOperationFactory> getExtendedOperationFactories() {
        return this.extendedOperationFactories;
    }

    public Map<String, IntermediateResponseFactory> getIntermediateResponseFactories() {
        return this.intermediateResponseFactories;
    }

    public void setExtendedOperationFactories(Map<String, ExtendedOperationFactory> extendedOperationFactories) {
        this.extendedOperationFactories = extendedOperationFactories;
    }

    public void setIntermediateResponseFactories(Map<String, IntermediateResponseFactory> intermediateResponseFactories) {
        this.intermediateResponseFactories = intermediateResponseFactories;
    }

    public void setProtocolCodecFactory(ProtocolCodecFactory protocolCodecFactory) {
        this.protocolCodecFactory = protocolCodecFactory;
    }
}

