/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.codec.search.ExtensibleMatchFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitExtensibleMatchFilter
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitExtensibleMatchFilter.class);

    public InitExtensibleMatchFilter() {
        super("Init Extensible Match filter Value");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        ExtensibleMatchFilter extensibleMatchFilter = new ExtensibleMatchFilter(container.getTlvId());
        searchRequestDecorator.addCurrentFilter(extensibleMatchFilter);
        searchRequestDecorator.setTerminalFilter(extensibleMatchFilter);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05146_INITIALIZE_EXT_FILTER, (Object[])new Object[0]));
        }
    }
}

