/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSerializationHelper {
    private static final Logger logger = LoggerFactory.getLogger(JavaSerializationHelper.class);
    private List<String> trustedPackages = new ArrayList<String>();
    private Set<Class<?>> trustedClasses;

    public JavaSerializationHelper() {
        this.trustedPackages.addAll(Arrays.asList("java.", "javax.", "org.pac4j.", "com.github.scribejava.", "org.opensaml.", "com.nimbusds.", "[Lcom.nimbusds.", "org.joda.", "net.minidev.json.", "org.bson.types."));
        this.trustedClasses = new HashSet();
    }

    public String serializeToBase64(Serializable o) {
        return Base64.getEncoder().encodeToString(this.serializeToBytes(o));
    }

    public byte[] serializeToBytes(Serializable o) {
        byte[] bytes = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(o);
            oos.flush();
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            logger.warn("cannot Java serialize object", (Throwable)e);
        }
        return bytes;
    }

    public Serializable unserializeFromBase64(String base64) {
        return this.unserializeFromBytes(Base64.getDecoder().decode(base64));
    }

    public Serializable unserializeFromBytes(byte[] bytes) {
        Serializable o = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
             RestrictedObjectInputStream ois = new RestrictedObjectInputStream(bais, this.trustedPackages, this.trustedClasses);){
            o = (Serializable)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            logger.warn("cannot Java deserialize object", (Throwable)e);
        }
        return o;
    }

    public List<String> getTrustedPackages() {
        return this.trustedPackages;
    }

    @Deprecated
    public void setTrustedPackages(List<String> trustedPackages) {
        this.trustedPackages = trustedPackages;
    }

    public Set<Class<?>> getTrustedClasses() {
        return Collections.unmodifiableSet(this.trustedClasses);
    }

    public void addTrustedPackages(Collection<String> trustedPackages) {
        this.trustedPackages.addAll(trustedPackages);
    }

    public void addTrustedPackage(String trustedPackage) {
        this.trustedPackages.add(trustedPackage);
    }

    public void clearTrustedPackages() {
        this.trustedPackages.clear();
    }

    public void addTrustedClasses(Collection<Class<?>> trustedClasses) {
        this.trustedClasses.addAll(trustedClasses);
    }

    public void addTrustedClass(Class<?> trustedClass) {
        this.trustedClasses.add(trustedClass);
    }

    public void clearTrustedClasses() {
        this.trustedClasses.clear();
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), "trustedPackages", this.trustedPackages, "trustedClasses", this.trustedClasses);
    }

    private static class RestrictedObjectInputStream
    extends ObjectInputStream {
        private final List<String> trustedPackages;
        private final Map<String, Class<?>> trustedClasses;

        private RestrictedObjectInputStream(InputStream in, List<String> trustedPackages, Set<Class<?>> trustedClasses) throws IOException {
            super(in);
            CommonHelper.assertNotNull("trustedPackages", trustedPackages);
            this.trustedPackages = trustedPackages;
            this.trustedClasses = trustedClasses.stream().collect(Collectors.toMap(Class::getName, Function.identity()));
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String qualifiedClassName = desc.getName();
            Class<?> clazz = this.trustedClasses.get(qualifiedClassName);
            if (Objects.nonNull(clazz)) {
                return clazz;
            }
            if (this.trustedPackages.stream().anyMatch(qualifiedClassName::startsWith)) {
                return super.resolveClass(desc);
            }
            throw new ClassNotFoundException("Wont resolve untrusted class: " + qualifiedClassName);
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws ClassNotFoundException {
            throw new ClassNotFoundException("Wont resolve proxy classes at all.");
        }
    }
}

