/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl.html;

import java.util.Collections;
import java.util.List;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFunctionDescriptorFactory;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteFunctionProcessorFactory;
import org.apache.knox.gateway.filter.rewrite.impl.html.HtmlPostfixDescriptor;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;

public class HtmlPostfixProcessor
implements UrlRewriteFunctionProcessor<HtmlPostfixDescriptor> {
    private UrlRewriteFunctionProcessor frontend;

    @Override
    public void initialize(UrlRewriteEnvironment environment, HtmlPostfixDescriptor descriptor) throws Exception {
        Object frontendDescriptor = UrlRewriteFunctionDescriptorFactory.create("frontend");
        this.frontend = UrlRewriteFunctionProcessorFactory.create("frontend", frontendDescriptor);
        this.frontend.initialize(environment, frontendDescriptor);
    }

    @Override
    public String name() {
        return "postfix";
    }

    @Override
    public void destroy() throws Exception {
        this.frontend.destroy();
    }

    @Override
    public List<String> resolve(UrlRewriteContext context, List<String> parameters) throws Exception {
        String postfix = "";
        if (parameters != null && parameters.size() > 1) {
            postfix = parameters.get(parameters.size() - 1);
            parameters = parameters.subList(0, parameters.size() - 1);
        }
        List<String> frontendValues = this.frontend.resolve(context, parameters);
        StringBuilder buffer = new StringBuilder();
        if (frontendValues != null && !frontendValues.isEmpty()) {
            for (String value : frontendValues) {
                buffer.append(value);
            }
        }
        buffer.append(postfix);
        return Collections.singletonList(buffer.toString());
    }
}

