/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static Document readXml(File file) throws ParserConfigurationException, IOException, SAXException {
        return XmlUtils.readXml(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public static Document readXml(InputStream input) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        f.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder b = f.newDocumentBuilder();
        return b.parse(input);
    }

    public static Document readXml(InputSource source) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        f.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder b = f.newDocumentBuilder();
        return b.parse(source);
    }

    public static void writeXml(Document document, Writer writer) throws TransformerException {
        Transformer t = XmlUtils.getTransformer(false, true, 4, false);
        XmlUtils.writeXml(document, writer, t);
    }

    public static void writeXml(Document document, Writer writer, Transformer transformer) throws TransformerException {
        DOMSource s = new DOMSource(document);
        StreamResult r = new StreamResult(writer);
        transformer.transform(s, r);
    }

    public static Transformer getTransformer(boolean standalone, boolean indent, int indentNumber, boolean omitXmlDeclaration) throws TransformerException {
        TransformerFactory f = TransformerFactory.newInstance();
        f.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        if (indent) {
            f.setAttribute("indent-number", indentNumber);
        }
        Transformer t = f.newTransformer();
        if (standalone) {
            t.setOutputProperty("standalone", "yes");
        }
        if (indent) {
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{xml.apache.org/xslt}indent-amount", String.valueOf(indentNumber));
        }
        if (omitXmlDeclaration) {
            t.setOutputProperty("omit-xml-declaration", "yes");
        }
        return t;
    }

    public static Document createDocument() throws ParserConfigurationException {
        return XmlUtils.createDocument(true);
    }

    public static Document createDocument(boolean standalone) throws ParserConfigurationException {
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        f.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder b = f.newDocumentBuilder();
        Document d = b.newDocument();
        d.setXmlStandalone(standalone);
        return d;
    }
}

