/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.time.Duration;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.vault.authentication.LoginToken;

final class LoginTokenUtil {
    static LoginToken from(Map<String, Object> auth) {
        Assert.notNull(auth, (String)"Authentication must not be null");
        String token = (String)auth.get("client_token");
        return LoginTokenUtil.from(token.toCharArray(), auth);
    }

    static LoginToken from(char[] token, Map<String, Object> auth) {
        Assert.notNull(auth, (String)"Authentication must not be null");
        Boolean renewable = (Boolean)auth.get("renewable");
        Number leaseDuration = (Number)auth.get("lease_duration");
        if (leaseDuration == null) {
            leaseDuration = (Number)auth.get("ttl");
        }
        if (renewable != null && renewable.booleanValue()) {
            return LoginToken.renewable(token, Duration.ofSeconds(leaseDuration.longValue()));
        }
        if (leaseDuration != null) {
            return LoginToken.of(token, Duration.ofSeconds(leaseDuration.longValue()));
        }
        return LoginToken.of(token);
    }

    private LoginTokenUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

