/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.security.principal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.knox.gateway.security.principal.PrincipalMapper;
import org.apache.knox.gateway.security.principal.PrincipalMappingException;

public class SimplePrincipalMapper
implements PrincipalMapper {
    public Map<String, String[]> principalMappings;
    public Map<String, String[]> groupMappings;

    @Override
    public void loadMappingTable(String principalMapping, String groupMapping) throws PrincipalMappingException {
        if (principalMapping != null) {
            this.principalMappings = this.parseMapping(principalMapping);
            this.groupMappings = this.parseMapping(groupMapping);
        }
    }

    private Map<String, String[]> parseMapping(String mappings) throws PrincipalMappingException {
        if (mappings == null) {
            return null;
        }
        HashMap<String, String[]> table = new HashMap<String, String[]>();
        try {
            StringTokenizer t = new StringTokenizer(mappings, ";");
            if (t.hasMoreTokens()) {
                do {
                    String[] p;
                    String mapping = t.nextToken();
                    String principals = mapping.substring(0, mapping.indexOf(61));
                    String value = mapping.substring(mapping.indexOf(61) + 1);
                    String[] v = value.split(",");
                    for (String s : p = principals.split(",")) {
                        table.put(s, v);
                    }
                } while (t.hasMoreTokens());
            }
            return table;
        }
        catch (Exception e) {
            table.clear();
            throw new PrincipalMappingException("Unable to load mappings from provided string: " + mappings + " - no principal mapping will be provided.", e);
        }
    }

    @Override
    public String mapUserPrincipal(String principalName) {
        String[] p = null;
        if (this.principalMappings != null) {
            p = this.principalMappings.get(principalName);
        }
        if (p == null) {
            return principalName;
        }
        return p[0];
    }

    @Override
    public String[] mapGroupPrincipal(String principalName) {
        String[] groups = null;
        if (this.groupMappings != null) {
            groups = this.groupMappings.get(principalName);
            String[] wildCardGroups = this.groupMappings.get("*");
            if (groups != null && wildCardGroups != null) {
                groups = SimplePrincipalMapper.concat(groups, wildCardGroups);
            } else if (wildCardGroups != null) {
                return wildCardGroups;
            }
        }
        return groups;
    }

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }
}

