/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.knox.gateway.config.Configure;
import org.apache.knox.gateway.config.Default;
import org.apache.knox.gateway.dispatch.DefaultDispatch;

public class ConfigurableDispatch
extends DefaultDispatch {
    private Set<String> requestExcludeHeaders = super.getOutboundRequestExcludeHeaders();
    private Set<String> responseExcludeHeaders = super.getOutboundResponseExcludeHeaders();
    private Boolean removeUrlEncoding = false;

    private Set<String> handleCommaSeparatedHeaders(String headers) {
        if (headers != null) {
            return new HashSet<String>(Arrays.asList(headers.split(",")));
        }
        return Collections.emptySet();
    }

    @Configure
    protected void setRequestExcludeHeaders(@Default(value=" ") String headers) {
        if (!" ".equals(headers)) {
            this.requestExcludeHeaders = this.handleCommaSeparatedHeaders(headers);
        }
    }

    @Configure
    protected void setResponseExcludeHeaders(@Default(value=" ") String headers) {
        if (!" ".equals(headers)) {
            this.responseExcludeHeaders = this.handleCommaSeparatedHeaders(headers);
        }
    }

    @Configure
    protected void setRemoveUrlEncoding(@Default(value="false") String removeUrlEncoding) {
        this.removeUrlEncoding = Boolean.parseBoolean(removeUrlEncoding);
    }

    @Override
    public Set<String> getOutboundResponseExcludeHeaders() {
        return this.responseExcludeHeaders;
    }

    @Override
    public Set<String> getOutboundRequestExcludeHeaders() {
        return this.requestExcludeHeaders;
    }

    public boolean getRemoveUrlEncoding() {
        return this.removeUrlEncoding;
    }

    @Override
    public URI getDispatchUrl(HttpServletRequest request) {
        if (this.getRemoveUrlEncoding()) {
            String base = request.getRequestURI();
            StringBuffer str = new StringBuffer();
            str.append(base);
            String query = request.getQueryString();
            if (query != null) {
                try {
                    query = URLDecoder.decode(query, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                str.append('?');
                str.append(query);
            }
            this.encodeUnwiseCharacters(str);
            return URI.create(str.toString());
        }
        return super.getDispatchUrl(request);
    }
}

