/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.asset;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.impl.base.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProviderAsset
implements Asset {
    private final String[] providerImpls;

    public ServiceProviderAsset(Class<?> ... providerImpls) {
        Validate.notNullAndNoNullValues(providerImpls, "ProviderImpls must be specified and can not contain null values");
        String[] names = new String[providerImpls.length];
        for (int i = 0; i < providerImpls.length; ++i) {
            names[i] = providerImpls[i].getName();
        }
        this.providerImpls = names;
    }

    public ServiceProviderAsset(String ... providerImpls) {
        Validate.notNullAndNoNullValues(providerImpls, "ProviderImpls must be specified and can not contain null values");
        this.providerImpls = providerImpls;
    }

    public InputStream openStream() {
        StringBuilder content = new StringBuilder();
        for (String providerImpl : this.providerImpls) {
            content.append(providerImpl).append('\n');
        }
        return new ByteArrayInputStream(content.toString().getBytes());
    }
}

