// ***************************************************************************************************************************
// * Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file *
// * distributed with this work for additional information regarding copyright ownership.  The ASF licenses this file        *
// * to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance            *
// * with the License.  You may obtain a copy of the License at                                                              *
// *                                                                                                                         *
// *  http://www.apache.org/licenses/LICENSE-2.0                                                                             *
// *                                                                                                                         *
// * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an  *
// * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the License for the        *
// * specific language governing permissions and limitations under the License.                                              *
// ***************************************************************************************************************************
package org.apache.juneau.dto.html5;

import org.apache.juneau.*;

/**
 * Defines the Java classes that make up the HTML DTO type dictionary.
 *
 * <ul class='seealso'>
 * 	<li class='link'>{@doc DtoHtml5}
 * </ul>
 */
public class HtmlBeanDictionary extends BeanDictionaryList {
	private static final long serialVersionUID = 1L;

	/**
	 * Constructor.
	 */
	public HtmlBeanDictionary() {
		super(
			A.class,
			Abbr.class,
			Address.class,
			Area.class,
			Article.class,
			Aside.class,
			Audio.class,
			B.class,
			Base.class,
			Bdi.class,
			Bdo.class,
			Blockquote.class,
			Body.class,
			Br.class,
			Button.class,
			Canvas.class,
			Caption.class,
			Cite.class,
			Code.class,
			Col.class,
			Colgroup.class,
			Data.class,
			Datalist.class,
			Dd.class,
			Del.class,
			Dfn.class,
			Div.class,
			Dl.class,
			Dt.class,
			Em.class,
			Embed.class,
			Fieldset.class,
			Figcaption.class,
			Figure.class,
			Footer.class,
			Form.class,
			H1.class,
			H2.class,
			H3.class,
			H4.class,
			H5.class,
			H6.class,
			Head.class,
			Header.class,
			Hr.class,
			Html.class,
			I.class,
			Iframe.class,
			Img.class,
			Input.class,
			Ins.class,
			Kbd.class,
			Keygen.class,
			Label.class,
			Legend.class,
			Li.class,
			Link.class,
			Main.class,
			Map.class,
			Mark.class,
			Meta.class,
			Meter.class,
			Nav.class,
			Noscript.class,
			Object_.class,
			Ol.class,
			Optgroup.class,
			Option.class,
			Output.class,
			P.class,
			Param.class,
			Pre.class,
			Progress.class,
			Q.class,
			Rb.class,
			Rp.class,
			Rt.class,
			Rtc.class,
			Ruby.class,
			S.class,
			Samp.class,
			Script.class,
			Section.class,
			Select.class,
			Small.class,
			Source.class,
			Span.class,
			Strong.class,
			Style.class,
			Sub.class,
			Sup.class,
			Table.class,
			Tbody.class,
			Td.class,
			Template.class,
			Textarea.class,
			Tfoot.class,
			Th.class,
			Thead.class,
			Time.class,
			Title.class,
			Tr.class,
			Track.class,
			U.class,
			Ul.class,
			Var.class,
			Video.class,
			Wbr.class
		);
	}
}
