// ***************************************************************************************************************************
// * Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file *
// * distributed with this work for additional information regarding copyright ownership.  The ASF licenses this file        *
// * to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance            *
// * with the License.  You may obtain a copy of the License at                                                              *
// *                                                                                                                         *
// *  http://www.apache.org/licenses/LICENSE-2.0                                                                             *
// *                                                                                                                         *
// * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an  *
// * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the License for the        *
// * specific language governing permissions and limitations under the License.                                              *
// ***************************************************************************************************************************
package org.apache.juneau.transforms;

import static org.junit.Assert.*;
import static org.junit.runners.MethodSorters.*;

import org.apache.juneau.marshall.*;
import org.junit.*;

/**
 * Tests the {@link StackTraceElementSwap} class.
 */
@FixMethodOrder(NAME_ASCENDING)
public class StackTraceElementSwapTest {

	private String write(StackTraceElement ste) {
		return SimpleJson.DEFAULT.toString(ste);
	}

	private StackTraceElement read(String in) throws Exception {
		return SimpleJson.DEFAULT.read(in, StackTraceElement.class);
	}

	//------------------------------------------------------------------------------------------------------------------
	// Basic tests
	//------------------------------------------------------------------------------------------------------------------
	@Test
	public void basicTests() throws Exception {
		StackTraceElement ste;

		ste = new StackTraceElement("foo.bar.Baz", "qux", "Baz.java", 123);
		assertEquals("'foo.bar.Baz.qux(Baz.java:123)'", write(ste));
		assertEquals("'foo.bar.Baz.qux(Baz.java:123)'", write(read("'foo.bar.Baz.qux(Baz.java:123)'")));

		ste = new StackTraceElement("foo.bar.Baz", "qux", "Baz.java", -2);
		assertEquals("'foo.bar.Baz.qux(Native Method)'", write(ste));
		assertEquals("'foo.bar.Baz.qux(Native Method)'", write(read("'foo.bar.Baz.qux(Native Method)'")));

		ste = new StackTraceElement("foo.bar.Baz", "qux", null, 0);
		assertEquals("'foo.bar.Baz.qux(Unknown Source)'", write(ste));
		assertEquals("'foo.bar.Baz.qux(Unknown Source)'", write(read("'foo.bar.Baz.qux(Unknown Source)'")));

		ste = new StackTraceElement("foo.bar.Baz", "qux", "Baz.java", -1);
		assertEquals("'foo.bar.Baz.qux(Baz.java)'", write(ste));
		assertEquals("'foo.bar.Baz.qux(Baz.java)'", write(read("'foo.bar.Baz.qux(Baz.java)'")));
	}
}