/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.websocket.internal.mapper;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.johnzon.mapper.Mapper;
import org.apache.johnzon.mapper.MapperBuilder;
import org.apache.johnzon.websocket.internal.lazy.LazySupplier;
import org.apache.johnzon.websocket.internal.mapper.MapperLocator;

public class MapperLocatorDelegate
implements ServletContextListener {
    private static final Map<ClassLoader, Supplier<Mapper>> MAPPER_BY_LOADER = new ConcurrentHashMap<ClassLoader, Supplier<Mapper>>();
    private static final String ATTRIBUTE = MapperLocator.class.getName() + ".mapper";

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        Supplier supplier = Optional.ofNullable(servletContext.getAttribute(ATTRIBUTE)).map(it -> (Supplier)it).orElseGet(() -> {
            LazySupplier<Mapper> lazySupplier = new LazySupplier<Mapper>(MapperLocatorDelegate::newMapper);
            servletContext.setAttribute(ATTRIBUTE, lazySupplier);
            return lazySupplier;
        });
        MAPPER_BY_LOADER.put(servletContext.getClassLoader(), supplier);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        Object mapper;
        Supplier<Mapper> supplier = MAPPER_BY_LOADER.remove(servletContextEvent.getServletContext().getClassLoader());
        if (LazySupplier.class.isInstance(supplier) && (mapper = ((LazySupplier)LazySupplier.class.cast(supplier)).getInstance()) != null) {
            ((Mapper)Mapper.class.cast(mapper)).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Mapper locate() {
        Supplier<Mapper> mapper;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = MapperLocatorDelegate.class.getClassLoader();
        }
        if ((mapper = MAPPER_BY_LOADER.get(loader)) == null) {
            Map<ClassLoader, Supplier<Mapper>> map = MAPPER_BY_LOADER;
            synchronized (map) {
                mapper = MAPPER_BY_LOADER.get(loader);
                if (mapper != null) {
                    return mapper.get();
                }
                Mapper instance = MapperLocatorDelegate.newMapper();
                mapper = () -> instance;
                MAPPER_BY_LOADER.put(loader, mapper);
                return mapper.get();
            }
        }
        return mapper.get();
    }

    private static Mapper newMapper() {
        return new MapperBuilder().build();
    }
}

