/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection.internal.redblack;

import com.github.andrewoma.dexx.collection.internal.redblack.Tree;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class TreeIterator<K, V, R>
implements Iterator<R> {
    private Tree<K, V>[] path;
    private int index = 0;
    private Tree<K, V> next;

    protected TreeIterator(Tree<K, V> tree) {
        if (tree != null) {
            int maximumHeight = 2 * (32 - Integer.numberOfLeadingZeros(tree.count() + 2 - 1)) - 2 - 1;
            this.path = new Tree[maximumHeight];
        }
        this.next = this.findNext(tree);
    }

    protected abstract R nextResult(Tree<K, V> var1);

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public R next() {
        if (this.next == null) {
            throw new NoSuchElementException("next on empty iterator");
        }
        Tree<K, V> tree = this.next;
        this.next = this.findNext(tree.getRight());
        return this.nextResult(tree);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Tree<K, V> findNext(Tree<K, V> tree) {
        if (tree == null) {
            return this.popPath();
        }
        if (tree.getLeft() == null) {
            return tree;
        }
        this.pushPath(tree);
        return this.findNext(tree.getLeft());
    }

    private void pushPath(Tree<K, V> tree) {
        try {
            this.path[this.index] = tree;
            ++this.index;
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            e2.printStackTrace();
            assert (this.index >= this.path.length);
            Tree[] temp = new Tree[this.path.length + 1];
            System.arraycopy(this.path, 0, temp, 0, this.path.length);
            this.path = temp;
            this.pushPath(tree);
        }
    }

    private Tree<K, V> popPath() {
        if (this.index == 0) {
            return null;
        }
        --this.index;
        return this.path[this.index];
    }
}

