/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.serializer;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Exists;
import org.apache.jena.sparql.expr.E_NotExists;
import org.apache.jena.sparql.expr.E_NotOneOf;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunction0;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprFunction3;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprNone;
import org.apache.jena.sparql.expr.ExprTripleTerm;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.serializer.FormatterElement;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.util.FmtUtils;

public class FmtExprSPARQL {
    static final int INDENT = 2;
    FmtExprARQVisitor visitor;

    public FmtExprSPARQL(IndentedWriter writer, SerializationContext cxt) {
        this.visitor = new FmtExprARQVisitor(writer, cxt);
    }

    public void format(Expr expr) {
        expr.visit(this.visitor);
    }

    public static void format(IndentedWriter out, Expr expr) {
        FmtExprSPARQL.format(out, expr, null);
    }

    public static void format(IndentedWriter out, Expr expr, SerializationContext cxt) {
        FmtExprSPARQL fmt = new FmtExprSPARQL(out, cxt);
        fmt.format(expr);
    }

    private static class FmtExprARQVisitor
    implements ExprVisitor {
        IndentedWriter out;
        SerializationContext context;

        public FmtExprARQVisitor(IndentedWriter writer, PrefixMapping pmap) {
            this(writer, new SerializationContext(pmap));
        }

        public FmtExprARQVisitor(IndentedWriter writer, SerializationContext cxt) {
            this.out = writer;
            this.context = cxt;
            if (this.context == null) {
                this.context = new SerializationContext();
            }
        }

        @Override
        public void visit(ExprFunction0 expr) {
            if (expr.getOpName() == null) {
                this.printInFunctionForm(expr);
                return;
            }
            this.out.print("( ");
            this.out.print(expr.getOpName());
            this.out.print(" ");
        }

        @Override
        public void visit(ExprFunction1 expr) {
            if (expr.getOpName() == null) {
                this.printInFunctionForm(expr);
                return;
            }
            this.out.print("( ");
            this.out.print(expr.getOpName());
            this.out.print(" ");
            expr.getArg().visit(this);
            this.out.print(" )");
        }

        @Override
        public void visit(ExprFunction2 expr) {
            if (expr.getOpName() == null) {
                this.printInFunctionForm(expr);
                return;
            }
            this.out.print("( ");
            expr.getArg1().visit(this);
            this.out.print(" ");
            this.out.print(expr.getOpName());
            this.out.print(" ");
            expr.getArg2().visit(this);
            this.out.print(" )");
        }

        @Override
        public void visit(ExprFunction3 expr) {
            this.printInFunctionForm(expr);
        }

        @Override
        public void visit(ExprFunctionN func) {
            if (func instanceof E_OneOf) {
                E_OneOf oneOf = (E_OneOf)func;
                this.out.print("( ");
                oneOf.getLHS().visit(this);
                this.out.print(" IN ");
                this.printExprList(oneOf.getRHS());
                this.out.print(" )");
                return;
            }
            if (func instanceof E_NotOneOf) {
                E_NotOneOf oneOf = (E_NotOneOf)func;
                this.out.print("( ");
                oneOf.getLHS().visit(this);
                this.out.print(" NOT IN ");
                this.printExprList(oneOf.getRHS());
                this.out.print(" )");
                return;
            }
            this.printInFunctionForm(func);
        }

        private void printInFunctionForm(ExprFunction func) {
            this.out.print(func.getFunctionPrintName(this.context));
            this.printExprList(func.getArgs());
        }

        private void printExprList(Iterable<Expr> exprs) {
            this.out.print("(");
            boolean first = true;
            for (Expr expr : exprs) {
                if (expr == null) break;
                if (!first) {
                    this.out.print(", ");
                }
                first = false;
                expr.visit(this);
            }
            this.out.print(")");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visit(ExprFunctionOp funcOp) {
            String fn = funcOp.getFunctionPrintName(this.context);
            if (funcOp instanceof E_NotExists) {
                fn = "NOT EXISTS";
            } else if (funcOp instanceof E_Exists) {
                fn = "EXISTS";
            } else {
                throw new ARQInternalErrorException("Unrecognized ExprFunctionOp: " + fn);
            }
            FormatterElement fmtElt = new FormatterElement(this.out, this.context);
            this.out.print(fn);
            this.out.print(" ");
            int indent = this.out.getAbsoluteIndent();
            int currentCol = this.out.getCol();
            try {
                this.out.setAbsoluteIndent(currentCol);
                Element el = funcOp.getElement();
                if (el == null) {
                    el = OpAsQuery.asQuery(funcOp.getGraphPattern()).getQueryPattern();
                }
                el.visit(fmtElt);
            }
            finally {
                this.out.setAbsoluteIndent(indent);
            }
        }

        @Override
        public void visit(NodeValue nv) {
            this.out.print(nv.asQuotedString(this.context));
        }

        @Override
        public void visit(ExprNone none) {
            this.out.print("NONE");
        }

        @Override
        public void visit(ExprVar nv) {
            String s = nv.getVarName();
            if (Var.isBlankNodeVarName(s)) {
                Var v = Var.alloc(s);
                this.out.print(this.context.getBNodeMap().asString((Node)v));
            } else {
                this.out.print(nv.asSparqlExpr());
            }
        }

        @Override
        public void visit(ExprTripleTerm tripleTerm) {
            Triple t = tripleTerm.getTriple();
            this.out.print(FmtUtils.stringForNode(tripleTerm.getNode(), this.context));
        }

        @Override
        public void visit(ExprAggregator eAgg) {
            this.out.print(eAgg.asSparqlExpr(this.context));
        }
    }
}

