/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.protobuf;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.RDFDirLangString;
import org.apache.jena.datatypes.xsd.impl.RDFLangString;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.protobuf.RiotProtobufException;
import org.apache.jena.riot.protobuf.wire.PB_RDF;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;

public class ProtobufConvert {
    static final BigInteger MAX_I = BigInteger.valueOf(Long.MAX_VALUE);
    static final BigInteger MIN_I = BigInteger.valueOf(Long.MIN_VALUE);
    private static PB_RDF.RDF_UNDEF rdfUNDEF = PB_RDF.RDF_UNDEF.newBuilder().build();
    private static PB_RDF.RDF_Term UNDEF = PB_RDF.RDF_Term.newBuilder().setUndefined(rdfUNDEF).build();
    private static PB_RDF.RDF_ANY rdfANY = PB_RDF.RDF_ANY.newBuilder().build();
    private static PB_RDF.RDF_Term ANY = PB_RDF.RDF_Term.newBuilder().setAny(rdfANY).build();
    private static String dtXSDString = XSDDatatype.XSDstring.getURI();
    private static final PrefixMap emptyPrefixMap = PrefixMapFactory.emptyPrefixMap();

    private static PB_RDF.RDF_Term toProtobufValue(Node node, PB_RDF.RDF_Term.Builder term) {
        if (!node.isLiteral()) {
            return null;
        }
        term.clear();
        String lex = node.getLiteralLexicalForm();
        RDFDatatype rdt = node.getLiteralDatatype();
        if (rdt == null) {
            return null;
        }
        if (rdt.equals((Object)XSDDatatype.XSDdecimal)) {
            if (rdt.isValid(lex)) {
                BigDecimal decimal = new BigDecimal(lex.trim());
                int scale = decimal.scale();
                BigInteger bigInt = decimal.unscaledValue();
                if (bigInt.compareTo(MAX_I) <= 0 && bigInt.compareTo(MIN_I) >= 0) {
                    PB_RDF.RDF_Decimal.Builder d = PB_RDF.RDF_Decimal.newBuilder().setValue(bigInt.longValue()).setScale(scale);
                    term.setValDecimal(d);
                    return term.build();
                }
            }
        } else if (rdt.equals((Object)XSDDatatype.XSDinteger) || rdt.equals((Object)XSDDatatype.XSDlong) || rdt.equals((Object)XSDDatatype.XSDint) || rdt.equals((Object)XSDDatatype.XSDshort) || rdt.equals((Object)XSDDatatype.XSDbyte)) {
            if (rdt.isValid(lex)) {
                try {
                    long v = ((Number)node.getLiteralValue()).longValue();
                    term.setValInteger(v);
                    return term.build();
                }
                catch (Throwable ex) {
                    return null;
                }
            }
        } else if (rdt.equals((Object)XSDDatatype.XSDdouble) && rdt.isValid(lex)) {
            try {
                double v = (Double)node.getLiteralValue();
                term.setValDouble(v);
                return term.build();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static Node convert(PB_RDF.RDF_Term term) {
        return ProtobufConvert.convert(null, term);
    }

    public static Node convert(Cache<String, Node> uriCache, PB_RDF.RDF_Term term) {
        return ProtobufConvert.convert(uriCache, term, null);
    }

    private static Node uri(Cache<String, Node> uriCache, String uriStr) {
        if (uriCache != null) {
            return (Node)uriCache.get((Object)uriStr, RiotLib::createIRIorBNode);
        }
        return RiotLib.createIRIorBNode(uriStr);
    }

    public static Node convert(PB_RDF.RDF_Term term, PrefixMap pmap) {
        return ProtobufConvert.convert(null, term, pmap);
    }

    public static Node convert(Cache<String, Node> uriCache, PB_RDF.RDF_Term term, PrefixMap pmap) {
        switch (term.getTermCase()) {
            case IRI: {
                return ProtobufConvert.uri(uriCache, term.getIri().getIri());
            }
            case BNODE: {
                return NodeFactory.createBlankNode((String)term.getBnode().getLabel());
            }
            case LITERAL: {
                if (term.hasLiteral()) {
                    PB_RDF.RDF_Literal lit = term.getLiteral();
                    String lex = lit.getLex();
                    switch (lit.getLiteralKindCase()) {
                        case SIMPLE: {
                            return NodeFactory.createLiteralString((String)lex);
                        }
                        case LANGTAG: {
                            String lang = lit.getLangtag();
                            return NodeFactory.createLiteralLang((String)lex, (String)lang);
                        }
                        case LANGDIR: {
                            String langdir = lit.getLangdir();
                            int idx = langdir.indexOf("--");
                            if (idx < 0) {
                                throw new RiotProtobufException("Bad langusage-base direction value: " + langdir);
                            }
                            String lang = langdir.substring(0, idx);
                            String dir = langdir.substring(idx + 2);
                            return NodeFactory.createLiteralDirLang((String)lex, (String)lang, (String)dir);
                        }
                        case DATATYPE: {
                            String dtString = lit.getDatatype();
                            RDFDatatype dt = NodeFactory.getType((String)dtString);
                            return NodeFactory.createLiteralDT((String)lex, (RDFDatatype)dt);
                        }
                        case DTPREFIX: {
                            String x = ProtobufConvert.expand(lit.getDtPrefix(), pmap);
                            if (x == null) {
                                throw new RiotProtobufException("Failed to expand datatype prefix name: " + String.valueOf(lit.getDtPrefix()));
                            }
                            RDFDatatype dt = NodeFactory.getType((String)x);
                            return NodeFactory.createLiteralDT((String)lex, (RDFDatatype)dt);
                        }
                        case LITERALKIND_NOT_SET: {
                            throw new RiotProtobufException("Literal kind not set.");
                        }
                    }
                }
            }
            case PREFIXNAME: {
                String x = ProtobufConvert.expand(term.getPrefixName(), pmap);
                if (x != null) {
                    return ProtobufConvert.uri(uriCache, x);
                }
                throw new RiotProtobufException("Failed to expand " + String.valueOf(term));
            }
            case VARIABLE: {
                return Var.alloc(term.getVariable().getName());
            }
            case TRIPLETERM: {
                PB_RDF.RDF_Triple rt = term.getTripleTerm();
                Triple t = ProtobufConvert.convert(rt, pmap);
                return NodeFactory.createTripleTerm((Triple)t);
            }
            case ANY: {
                return Node.ANY;
            }
            case REPEAT: {
                throw new RiotProtobufException("REPEAT not implemented");
            }
            case UNDEFINED: {
                return null;
            }
            case VALINTEGER: {
                long x = term.getValInteger();
                String lex = Long.toString(x, 10);
                XSDDatatype dt = XSDDatatype.XSDinteger;
                return NodeFactory.createLiteralDT((String)lex, (RDFDatatype)dt);
            }
            case VALDOUBLE: {
                double x = term.getValDouble();
                String lex = Double.toString(x);
                XSDDatatype dt = XSDDatatype.XSDdouble;
                return NodeFactory.createLiteralDT((String)lex, (RDFDatatype)dt);
            }
            case VALDECIMAL: {
                long value = term.getValDecimal().getValue();
                int scale = term.getValDecimal().getScale();
                BigDecimal d = BigDecimal.valueOf(value, scale);
                String lex = d.toPlainString();
                XSDDatatype dt = XSDDatatype.XSDdecimal;
                return NodeFactory.createLiteralDT((String)lex, (RDFDatatype)dt);
            }
            case TERM_NOT_SET: {
                throw new RiotProtobufException("RDF_Term not set");
            }
        }
        throw new RiotProtobufException("No conversion to a Node: " + term.toString());
    }

    public static Triple convert(PB_RDF.RDF_Triple triple) {
        return ProtobufConvert.convert(null, triple, null);
    }

    public static Triple convert(Cache<String, Node> uriCache, PB_RDF.RDF_Triple triple) {
        return ProtobufConvert.convert(uriCache, triple, null);
    }

    public static Triple convert(PB_RDF.RDF_Triple rt, PrefixMap pmap) {
        return ProtobufConvert.convert(null, rt, pmap);
    }

    public static Triple convert(Cache<String, Node> uriCache, PB_RDF.RDF_Triple rt, PrefixMap pmap) {
        Node s = ProtobufConvert.convert(uriCache, rt.getS(), pmap);
        Node p = ProtobufConvert.convert(uriCache, rt.getP(), pmap);
        Node o = ProtobufConvert.convert(uriCache, rt.getO(), pmap);
        return Triple.create((Node)s, (Node)p, (Node)o);
    }

    public static Quad convert(PB_RDF.RDF_Quad rq, PrefixMap pmap) {
        return ProtobufConvert.convert(null, rq, pmap);
    }

    public static Quad convert(Cache<String, Node> uriCache, PB_RDF.RDF_Quad rq, PrefixMap pmap) {
        Node g = rq.hasG() ? ProtobufConvert.convert(uriCache, rq.getG(), pmap) : null;
        Node s = ProtobufConvert.convert(uriCache, rq.getS(), pmap);
        Node p = ProtobufConvert.convert(uriCache, rq.getP(), pmap);
        Node o = ProtobufConvert.convert(uriCache, rq.getO(), pmap);
        return Quad.create(g, s, p, o);
    }

    public static PB_RDF.RDF_Term toProtobuf(Node node, PB_RDF.RDF_Term.Builder term) {
        return ProtobufConvert.toProtobuf(node, emptyPrefixMap, term, true);
    }

    public static PB_RDF.RDF_Term toProtobuf(Node node, PB_RDF.RDF_Term.Builder term, boolean allowValues) {
        return ProtobufConvert.toProtobuf(node, emptyPrefixMap, term, allowValues);
    }

    public static PB_RDF.RDF_Term toProtobuf(Node node, PrefixMap pmap, PB_RDF.RDF_Term.Builder termBuilder, boolean allowValues) {
        if (node == null) {
            return UNDEF;
        }
        if (node.isURI()) {
            PB_RDF.RDF_PrefixName prefixName = ProtobufConvert.abbrev(node.getURI(), pmap);
            if (prefixName != null) {
                termBuilder.setPrefixName(prefixName);
                return termBuilder.build();
            }
            PB_RDF.RDF_IRI iri = PB_RDF.RDF_IRI.newBuilder().setIri(node.getURI()).build();
            return termBuilder.setIri(iri).build();
        }
        if (node.isBlank()) {
            PB_RDF.RDF_BNode b = PB_RDF.RDF_BNode.newBuilder().setLabel(node.getBlankNodeLabel()).build();
            return termBuilder.setBnode(b).build();
        }
        if (node.isLiteral()) {
            PB_RDF.RDF_Term term;
            if (allowValues && (term = ProtobufConvert.toProtobufValue(node, termBuilder)) != null) {
                return termBuilder.build();
            }
            PB_RDF.RDF_Literal.Builder literal = PB_RDF.RDF_Literal.newBuilder();
            String lex = node.getLiteralLexicalForm();
            literal.setLex(lex);
            String dt = node.getLiteralDatatypeURI();
            String lang = node.getLiteralLanguage();
            TextDirection baseDir = node.getLiteralBaseDirection();
            if (lang.isEmpty()) {
                lang = null;
            }
            if (node.getLiteralDatatype().equals((Object)XSDDatatype.XSDstring) || node.getLiteralDatatype().equals((Object)RDFLangString.rdfLangString) || node.getLiteralDatatype().equals((Object)RDFDirLangString.rdfDirLangString)) {
                dt = null;
            }
            if (dt == null) {
                if (lang == null) {
                    literal.setSimple(true);
                } else if (baseDir == null) {
                    literal.setLangtag(lang);
                } else {
                    String langdir = lang + "--" + baseDir.direction();
                    literal.setLangdir(langdir);
                }
            } else {
                PB_RDF.RDF_PrefixName dtPrefixName = ProtobufConvert.abbrev(dt, pmap);
                if (dtPrefixName != null) {
                    literal.setDtPrefix(dtPrefixName);
                } else {
                    literal.setDatatype(dt);
                }
            }
            termBuilder.setLiteral(literal);
            return termBuilder.build();
        }
        if (node.isVariable()) {
            PB_RDF.RDF_Var var = PB_RDF.RDF_Var.newBuilder().setName(node.getName()).build();
            return termBuilder.setVariable(var).build();
        }
        if (node.isTripleTerm()) {
            Triple triple = node.getTriple();
            PB_RDF.RDF_Term sTerm = ProtobufConvert.toProtobuf(triple.getSubject(), pmap, termBuilder, allowValues);
            termBuilder.clear();
            PB_RDF.RDF_Term pTerm = ProtobufConvert.toProtobuf(triple.getPredicate(), pmap, termBuilder, allowValues);
            termBuilder.clear();
            PB_RDF.RDF_Term oTerm = ProtobufConvert.toProtobuf(triple.getObject(), pmap, termBuilder, allowValues);
            termBuilder.clear();
            PB_RDF.RDF_Triple tripleTerm = PB_RDF.RDF_Triple.newBuilder().setS(sTerm).setP(pTerm).setO(oTerm).build();
            termBuilder.setTripleTerm(tripleTerm);
            return termBuilder.build();
        }
        if (Node.ANY.equals((Object)node)) {
            return ANY;
        }
        throw new RiotProtobufException("Node conversion not supported: " + String.valueOf(node));
    }

    private static String expand(PB_RDF.RDF_PrefixName prefixName, PrefixMap pmap) {
        String localname2;
        if (pmap == null) {
            return null;
        }
        String prefix = prefixName.getPrefix();
        String x = pmap.expand(prefix, localname2 = prefixName.getLocalName());
        if (x == null) {
            throw new RiotProtobufException("Failed to expand " + String.valueOf(prefixName));
        }
        return x;
    }

    public static PB_RDF.RDF_Term convert(Node node, boolean allowValues) {
        return ProtobufConvert.convert(node, null, allowValues);
    }

    public static PB_RDF.RDF_Term convert(Node node, PrefixMap pmap, boolean allowValues) {
        PB_RDF.RDF_Term.Builder n = PB_RDF.RDF_Term.newBuilder();
        return ProtobufConvert.toProtobuf(node, pmap, n, allowValues);
    }

    private static PB_RDF.RDF_PrefixName abbrev(String uriStr, PrefixMap pmap) {
        if (pmap == null) {
            return null;
        }
        Pair<String, String> p = pmap.abbrev(uriStr);
        if (p == null) {
            return null;
        }
        return PB_RDF.RDF_PrefixName.newBuilder().setPrefix((String)p.getLeft()).setLocalName((String)p.getRight()).build();
    }

    public static PB_RDF.RDF_Triple convert(Triple triple, boolean allowValues) {
        return ProtobufConvert.convert(triple, null, allowValues);
    }

    public static PB_RDF.RDF_Triple convert(Triple triple, PrefixMap pmap, boolean allowValues) {
        PB_RDF.RDF_Triple.Builder t = PB_RDF.RDF_Triple.newBuilder();
        PB_RDF.RDF_Term s = ProtobufConvert.convert(triple.getSubject(), pmap, allowValues);
        PB_RDF.RDF_Term p = ProtobufConvert.convert(triple.getPredicate(), pmap, allowValues);
        PB_RDF.RDF_Term o = ProtobufConvert.convert(triple.getObject(), pmap, allowValues);
        t.setS(s);
        t.setP(p);
        t.setO(o);
        return t.build();
    }

    public static Quad convert(PB_RDF.RDF_Quad quad) {
        return ProtobufConvert.convert(quad, null);
    }

    public static PB_RDF.RDF_Quad convert(Quad quad, boolean allowValues) {
        return ProtobufConvert.convert(quad, null, allowValues);
    }

    public static PB_RDF.RDF_Quad convert(Quad quad, PrefixMap pmap, boolean allowValues) {
        PB_RDF.RDF_Quad.Builder q = PB_RDF.RDF_Quad.newBuilder();
        PB_RDF.RDF_Term g = null;
        if (quad.getGraph() != null) {
            g = ProtobufConvert.convert(quad.getGraph(), pmap, allowValues);
        }
        PB_RDF.RDF_Term s = ProtobufConvert.convert(quad.getSubject(), pmap, allowValues);
        PB_RDF.RDF_Term p = ProtobufConvert.convert(quad.getPredicate(), pmap, allowValues);
        PB_RDF.RDF_Term o = ProtobufConvert.convert(quad.getObject(), pmap, allowValues);
        if (g != null) {
            q.setG(g);
        }
        q.setS(s);
        q.setP(p);
        q.setO(o);
        return q.build();
    }
}

