/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmdline.ModAssembler;
import arq.cmdline.ModDataset;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.query.Dataset;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.NotFoundException;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerVocab;

public class ModDatasetAssembler
extends ModDataset {
    private ModAssembler modAssembler = new ModAssembler();

    @Override
    public Dataset createDataset() {
        if (this.modAssembler.getAssemblerFile() == null) {
            return null;
        }
        try {
            this.dataset = (Dataset)this.modAssembler.create(DatasetAssemblerVocab.tDataset);
            if (this.dataset == null) {
                throw new CmdException("No dataset description found in: " + this.modAssembler.getAssemblerFile());
            }
        }
        catch (CmdException | ARQException ex) {
            throw ex;
        }
        catch (NotFoundException ex) {
            throw new CmdException("Not found: " + ex.getMessage());
        }
        catch (JenaException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Error creating dataset", ex);
        }
        return this.dataset;
    }

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        this.modAssembler.registerWith(cmdLine);
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        this.modAssembler.processArgs(cmdLine);
    }

    public String getAssemblerFile() {
        return this.modAssembler.getAssemblerFile();
    }
}

