/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection;

import com.github.andrewoma.dexx.collection.Builder;
import com.github.andrewoma.dexx.collection.BuilderFactory;
import com.github.andrewoma.dexx.collection.IndexedList;
import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.VectorBuilder;
import com.github.andrewoma.dexx.collection.VectorIterator;
import com.github.andrewoma.dexx.collection.VectorPointer;
import com.github.andrewoma.dexx.collection.internal.base.AbstractIndexedList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Vector<E>
extends AbstractIndexedList<E> {
    private static final Vector EMPTY = new Vector(0, 0, 0);
    protected final VectorPointer<E> pointer = new VectorPointer();
    private final int startIndex;
    private final int endIndex;
    private final int focus;
    private boolean dirty = false;

    @NotNull
    public static <E> BuilderFactory<E, Vector<E>> factory() {
        return new BuilderFactory<E, Vector<E>>(){

            @Override
            @NotNull
            public Builder<E, Vector<E>> newBuilder() {
                return new VectorBuilder();
            }
        };
    }

    @NotNull
    public static <E> Vector<E> empty() {
        return EMPTY;
    }

    Vector(int startIndex, int endIndex, int focus) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.focus = focus;
    }

    @Override
    public int size() {
        return this.endIndex - this.startIndex;
    }

    private void initIterator(VectorIterator<E> s) {
        s.initFrom(this.pointer);
        if (this.dirty) {
            s.stabilize(this.focus);
        }
        if (s.depth > 1) {
            s.gotoPos(this.startIndex, this.startIndex ^ this.focus);
        }
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        VectorIterator s = new VectorIterator(this.startIndex, this.endIndex);
        this.initIterator(s);
        return s;
    }

    @Override
    public E get(int index) {
        int idx = this.checkRangeConvert(index);
        return this.pointer.getElem(idx, idx ^ this.focus);
    }

    private int checkRangeConvert(int index) {
        int idx = index + this.startIndex;
        if (0 <= index && idx < this.endIndex) {
            return idx;
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    @Override
    @NotNull
    public Vector<E> take(int n) {
        if (n <= 0) {
            return Vector.empty();
        }
        if (this.startIndex + n < this.endIndex) {
            return this.dropBack0(this.startIndex + n);
        }
        return this;
    }

    @Override
    @NotNull
    public Vector<E> drop(int n) {
        if (n <= 0) {
            return this;
        }
        if (this.startIndex + n < this.endIndex) {
            return this.dropFront0(this.startIndex + n);
        }
        return Vector.empty();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @Nullable
    public E first() {
        if (this.isEmpty()) {
            return null;
        }
        return this.get(0);
    }

    @Override
    @NotNull
    public Vector<E> tail() {
        if (this.isEmpty()) {
            return this;
        }
        return this.drop(1);
    }

    @Override
    @Nullable
    public E last() {
        if (this.isEmpty()) {
            return null;
        }
        return this.get(this.size() - 1);
    }

    @Override
    @NotNull
    public Vector<E> range(int from, boolean fromInclusive, int to, boolean toInclusive) {
        return this.slice(from + (fromInclusive ? 0 : 1), to + (toInclusive ? 1 : 0));
    }

    @NotNull
    private Vector<E> slice(int from, int until) {
        return ((Vector)this.take(until)).drop(from);
    }

    @NotNull
    protected Pair<Vector<E>, Vector<E>> splitAt(int n) {
        return new Pair<IndexedList, IndexedList>(this.take(n), this.drop(n));
    }

    @Override
    @NotNull
    public Vector<E> set(int index, E elem) {
        int idx = this.checkRangeConvert(index);
        Vector<E> s = new Vector<E>(this.startIndex, this.endIndex, idx);
        s.pointer.initFrom(this.pointer);
        s.dirty = this.dirty;
        super.gotoPosWritable(this.focus, idx, this.focus ^ idx);
        s.pointer.display0[idx & 0x1F] = elem;
        return s;
    }

    private void gotoPosWritable(int oldIndex, int newIndex, int xor) {
        if (this.dirty) {
            this.pointer.gotoPosWritable1(oldIndex, newIndex, xor);
        } else {
            this.pointer.gotoPosWritable0(newIndex);
            this.dirty = true;
        }
    }

    private void gotoFreshPosWritable(int oldIndex, int newIndex, int xor) {
        if (this.dirty) {
            this.pointer.gotoFreshPosWritable1(oldIndex, newIndex, xor);
        } else {
            this.pointer.gotoFreshPosWritable0(oldIndex, newIndex, xor);
            this.dirty = true;
        }
    }

    @Override
    @NotNull
    public Vector<E> prepend(E value) {
        if (this.endIndex != this.startIndex) {
            int blockIndex = this.startIndex - 1 & 0xFFFFFFE0;
            int lo = this.startIndex - 1 & 0x1F;
            if (this.startIndex != blockIndex + 32) {
                Vector<E> s = new Vector<E>(this.startIndex - 1, this.endIndex, blockIndex);
                s.pointer.initFrom(this.pointer);
                s.dirty = this.dirty;
                super.gotoPosWritable(this.focus, blockIndex, this.focus ^ blockIndex);
                s.pointer.display0[lo] = value;
                return s;
            }
            int freeSpace = (1 << 5 * this.pointer.depth) - this.endIndex;
            int shift = freeSpace & ~((1 << 5 * (this.pointer.depth - 1)) - 1);
            int shiftBlocks = freeSpace >>> 5 * (this.pointer.depth - 1);
            if (shift != 0) {
                if (this.pointer.depth > 1) {
                    int newBlockIndex = blockIndex + shift;
                    int newFocus = this.focus + shift;
                    Vector<E> s = new Vector<E>(this.startIndex - 1 + shift, this.endIndex + shift, newBlockIndex);
                    s.pointer.initFrom(this.pointer);
                    s.dirty = this.dirty;
                    super.shiftTopLevel(0, shiftBlocks);
                    super.gotoFreshPosWritable(newFocus, newBlockIndex, newFocus ^ newBlockIndex);
                    s.pointer.display0[lo] = value;
                    return s;
                }
                int newBlockIndex = blockIndex + 32;
                int newFocus = this.focus;
                Vector<E> s = new Vector<E>(this.startIndex - 1 + shift, this.endIndex + shift, newBlockIndex);
                s.pointer.initFrom(this.pointer);
                s.dirty = this.dirty;
                super.shiftTopLevel(0, shiftBlocks);
                super.gotoPosWritable(newFocus, newBlockIndex, newFocus ^ newBlockIndex);
                s.pointer.display0[shift - 1] = value;
                return s;
            }
            if (blockIndex < 0) {
                int move = (1 << 5 * (this.pointer.depth + 1)) - (1 << 5 * this.pointer.depth);
                int newBlockIndex = blockIndex + move;
                int newFocus = this.focus + move;
                Vector<E> s = new Vector<E>(this.startIndex - 1 + move, this.endIndex + move, newBlockIndex);
                s.pointer.initFrom(this.pointer);
                s.dirty = this.dirty;
                super.gotoFreshPosWritable(newFocus, newBlockIndex, newFocus ^ newBlockIndex);
                s.pointer.display0[lo] = value;
                return s;
            }
            int newFocus = this.focus;
            Vector<E> s = new Vector<E>(this.startIndex - 1, this.endIndex, blockIndex);
            s.pointer.initFrom(this.pointer);
            s.dirty = this.dirty;
            super.gotoFreshPosWritable(newFocus, blockIndex, newFocus ^ blockIndex);
            s.pointer.display0[lo] = value;
            return s;
        }
        Object[] elems = new Object[32];
        elems[31] = value;
        Vector<E> s = new Vector<E>(31, 32, 0);
        s.pointer.depth = 1;
        s.pointer.display0 = elems;
        return s;
    }

    @Override
    @NotNull
    public Vector<E> append(E value) {
        if (this.endIndex != this.startIndex) {
            int blockIndex = this.endIndex & 0xFFFFFFE0;
            int lo = this.endIndex & 0x1F;
            if (this.endIndex != blockIndex) {
                Vector<E> s = new Vector<E>(this.startIndex, this.endIndex + 1, blockIndex);
                s.pointer.initFrom(this.pointer);
                s.dirty = this.dirty;
                super.gotoPosWritable(this.focus, blockIndex, this.focus ^ blockIndex);
                s.pointer.display0[lo] = value;
                return s;
            }
            int shift = this.startIndex & ~((1 << 5 * (this.pointer.depth - 1)) - 1);
            int shiftBlocks = this.startIndex >>> 5 * (this.pointer.depth - 1);
            if (shift != 0) {
                if (this.pointer.depth > 1) {
                    int newBlockIndex = blockIndex - shift;
                    int newFocus = this.focus - shift;
                    Vector<E> s = new Vector<E>(this.startIndex - shift, this.endIndex + 1 - shift, newBlockIndex);
                    s.pointer.initFrom(this.pointer);
                    s.dirty = this.dirty;
                    super.shiftTopLevel(shiftBlocks, 0);
                    super.gotoFreshPosWritable(newFocus, newBlockIndex, newFocus ^ newBlockIndex);
                    s.pointer.display0[lo] = value;
                    return s;
                }
                int newBlockIndex = blockIndex - 32;
                int newFocus = this.focus;
                Vector<E> s = new Vector<E>(this.startIndex - shift, this.endIndex + 1 - shift, newBlockIndex);
                s.pointer.initFrom(this.pointer);
                s.dirty = this.dirty;
                super.shiftTopLevel(shiftBlocks, 0);
                super.gotoPosWritable(newFocus, newBlockIndex, newFocus ^ newBlockIndex);
                s.pointer.display0[32 - shift] = value;
                return s;
            }
            int newFocus = this.focus;
            Vector<E> s = new Vector<E>(this.startIndex, this.endIndex + 1, blockIndex);
            s.pointer.initFrom(this.pointer);
            s.dirty = this.dirty;
            super.gotoFreshPosWritable(newFocus, blockIndex, newFocus ^ blockIndex);
            s.pointer.display0[lo] = value;
            return s;
        }
        Object[] elems = new Object[32];
        elems[0] = value;
        Vector<E> s = new Vector<E>(0, 1, 0);
        s.pointer.depth = 1;
        s.pointer.display0 = elems;
        return s;
    }

    private void shiftTopLevel(int oldLeft, int newLeft) {
        switch (this.pointer.depth - 1) {
            case 0: {
                this.pointer.display0 = this.pointer.copyRange(this.pointer.display0, oldLeft, newLeft);
                break;
            }
            case 1: {
                this.pointer.display1 = this.pointer.copyRange(this.pointer.display1, oldLeft, newLeft);
                break;
            }
            case 2: {
                this.pointer.display2 = this.pointer.copyRange(this.pointer.display2, oldLeft, newLeft);
                break;
            }
            case 3: {
                this.pointer.display3 = this.pointer.copyRange(this.pointer.display3, oldLeft, newLeft);
                break;
            }
            case 4: {
                this.pointer.display4 = this.pointer.copyRange(this.pointer.display4, oldLeft, newLeft);
                break;
            }
            case 5: {
                this.pointer.display5 = this.pointer.copyRange(this.pointer.display5, oldLeft, newLeft);
                break;
            }
        }
    }

    private void zeroLeft(Object[] array, int index) {
        for (int i = 0; i < index; ++i) {
            array[i] = null;
        }
    }

    private void zeroRight(Object[] array, int index) {
        for (int i = index; i < array.length; ++i) {
            array[i] = null;
        }
    }

    private Object[] copyLeft(Object[] array, int right) {
        Object[] a2 = new Object[array.length];
        System.arraycopy(array, 0, a2, 0, right);
        return a2;
    }

    private Object[] copyRight(Object[] array, int left) {
        Object[] a2 = new Object[array.length];
        System.arraycopy(array, left, a2, left, a2.length - left);
        return a2;
    }

    private void preClean(int depth) {
        this.pointer.depth = depth;
        switch (depth - 1) {
            case 0: {
                this.pointer.display1 = null;
                this.pointer.display2 = null;
                this.pointer.display3 = null;
                this.pointer.display4 = null;
                this.pointer.display5 = null;
                break;
            }
            case 1: {
                this.pointer.display2 = null;
                this.pointer.display3 = null;
                this.pointer.display4 = null;
                this.pointer.display5 = null;
                break;
            }
            case 2: {
                this.pointer.display3 = null;
                this.pointer.display4 = null;
                this.pointer.display5 = null;
                break;
            }
            case 3: {
                this.pointer.display4 = null;
                this.pointer.display5 = null;
                break;
            }
            case 4: {
                this.pointer.display5 = null;
                break;
            }
        }
    }

    private void cleanLeftEdge(int cutIndex) {
        if (cutIndex < 32) {
            this.zeroLeft(this.pointer.display0, cutIndex);
        } else if (cutIndex < 1024) {
            this.zeroLeft(this.pointer.display0, cutIndex & 0x1F);
            this.pointer.display1 = this.copyRight(this.pointer.display1, cutIndex >>> 5);
        } else if (cutIndex < 32768) {
            this.zeroLeft(this.pointer.display0, cutIndex & 0x1F);
            this.pointer.display1 = this.copyRight(this.pointer.display1, cutIndex >>> 5 & 0x1F);
            this.pointer.display2 = this.copyRight(this.pointer.display2, cutIndex >>> 10);
        } else if (cutIndex < 0x100000) {
            this.zeroLeft(this.pointer.display0, cutIndex & 0x1F);
            this.pointer.display1 = this.copyRight(this.pointer.display1, cutIndex >>> 5 & 0x1F);
            this.pointer.display2 = this.copyRight(this.pointer.display2, cutIndex >>> 10 & 0x1F);
            this.pointer.display3 = this.copyRight(this.pointer.display3, cutIndex >>> 15);
        } else if (cutIndex < 0x2000000) {
            this.zeroLeft(this.pointer.display0, cutIndex & 0x1F);
            this.pointer.display1 = this.copyRight(this.pointer.display1, cutIndex >>> 5 & 0x1F);
            this.pointer.display2 = this.copyRight(this.pointer.display2, cutIndex >>> 10 & 0x1F);
            this.pointer.display3 = this.copyRight(this.pointer.display3, cutIndex >>> 15 & 0x1F);
            this.pointer.display4 = this.copyRight(this.pointer.display4, cutIndex >>> 20);
        } else if (cutIndex < 0x40000000) {
            this.zeroLeft(this.pointer.display0, cutIndex & 0x1F);
            this.pointer.display1 = this.copyRight(this.pointer.display1, cutIndex >>> 5 & 0x1F);
            this.pointer.display2 = this.copyRight(this.pointer.display2, cutIndex >>> 10 & 0x1F);
            this.pointer.display3 = this.copyRight(this.pointer.display3, cutIndex >>> 15 & 0x1F);
            this.pointer.display4 = this.copyRight(this.pointer.display4, cutIndex >>> 20 & 0x1F);
            this.pointer.display5 = this.copyRight(this.pointer.display5, cutIndex >>> 25);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void cleanRightEdge(int cutIndex) {
        if (cutIndex <= 32) {
            this.zeroRight(this.pointer.display0, cutIndex);
        } else if (cutIndex <= 1024) {
            this.zeroRight(this.pointer.display0, (cutIndex - 1 & 0x1F) + 1);
            this.pointer.display1 = this.copyLeft(this.pointer.display1, cutIndex >>> 5);
        } else if (cutIndex <= 32768) {
            this.zeroRight(this.pointer.display0, (cutIndex - 1 & 0x1F) + 1);
            this.pointer.display1 = this.copyLeft(this.pointer.display1, (cutIndex - 1 >>> 5 & 0x1F) + 1);
            this.pointer.display2 = this.copyLeft(this.pointer.display2, cutIndex >>> 10);
        } else if (cutIndex <= 0x100000) {
            this.zeroRight(this.pointer.display0, (cutIndex - 1 & 0x1F) + 1);
            this.pointer.display1 = this.copyLeft(this.pointer.display1, (cutIndex - 1 >>> 5 & 0x1F) + 1);
            this.pointer.display2 = this.copyLeft(this.pointer.display2, (cutIndex - 1 >>> 10 & 0x1F) + 1);
            this.pointer.display3 = this.copyLeft(this.pointer.display3, cutIndex >>> 15);
        } else if (cutIndex <= 0x2000000) {
            this.zeroRight(this.pointer.display0, (cutIndex - 1 & 0x1F) + 1);
            this.pointer.display1 = this.copyLeft(this.pointer.display1, (cutIndex - 1 >>> 5 & 0x1F) + 1);
            this.pointer.display2 = this.copyLeft(this.pointer.display2, (cutIndex - 1 >>> 10 & 0x1F) + 1);
            this.pointer.display3 = this.copyLeft(this.pointer.display3, (cutIndex - 1 >>> 15 & 0x1F) + 1);
            this.pointer.display4 = this.copyLeft(this.pointer.display4, cutIndex >>> 20);
        } else if (cutIndex <= 0x40000000) {
            this.zeroRight(this.pointer.display0, (cutIndex - 1 & 0x1F) + 1);
            this.pointer.display1 = this.copyLeft(this.pointer.display1, (cutIndex - 1 >>> 5 & 0x1F) + 1);
            this.pointer.display2 = this.copyLeft(this.pointer.display2, (cutIndex - 1 >>> 10 & 0x1F) + 1);
            this.pointer.display3 = this.copyLeft(this.pointer.display3, (cutIndex - 1 >>> 15 & 0x1F) + 1);
            this.pointer.display4 = this.copyLeft(this.pointer.display4, (cutIndex - 1 >>> 20 & 0x1F) + 1);
            this.pointer.display5 = this.copyLeft(this.pointer.display5, cutIndex >>> 25);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private int requiredDepth(int xor) {
        if (xor < 32) {
            return 1;
        }
        if (xor < 1024) {
            return 2;
        }
        if (xor < 32768) {
            return 3;
        }
        if (xor < 0x100000) {
            return 4;
        }
        if (xor < 0x2000000) {
            return 5;
        }
        if (xor < 0x40000000) {
            return 6;
        }
        throw new IllegalArgumentException();
    }

    private Vector<E> dropFront0(int cutIndex) {
        int blockIndex = cutIndex & 0xFFFFFFE0;
        int xor = cutIndex ^ this.endIndex - 1;
        int d = this.requiredDepth(xor);
        int shift = cutIndex & ~((1 << 5 * d) - 1);
        Vector<E> s = new Vector<E>(cutIndex - shift, this.endIndex - shift, blockIndex - shift);
        s.pointer.initFrom(this.pointer);
        s.dirty = this.dirty;
        super.gotoPosWritable(this.focus, blockIndex, this.focus ^ blockIndex);
        super.preClean(d);
        super.cleanLeftEdge(cutIndex - shift);
        return s;
    }

    private Vector<E> dropBack0(int cutIndex) {
        int blockIndex = cutIndex - 1 & 0xFFFFFFE0;
        int xor = this.startIndex ^ cutIndex - 1;
        int d = this.requiredDepth(xor);
        int shift = this.startIndex & ~((1 << 5 * d) - 1);
        Vector<E> s = new Vector<E>(this.startIndex - shift, cutIndex - shift, blockIndex - shift);
        s.pointer.initFrom(this.pointer);
        s.dirty = this.dirty;
        super.gotoPosWritable(this.focus, blockIndex, this.focus ^ blockIndex);
        super.preClean(d);
        super.cleanRightEdge(cutIndex - shift);
        return s;
    }
}

