/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MailRepositoryPath
implements Comparable<MailRepositoryPath> {
    private static final String PATH_DELIMITER = "/";
    private final String value;

    public static MailRepositoryPath fromEncoded(String encodedPath) throws UnsupportedEncodingException {
        Preconditions.checkNotNull((Object)encodedPath, (Object)"Supplied MailRepositoryPath value is null");
        return MailRepositoryPath.from(URLDecoder.decode(encodedPath, StandardCharsets.UTF_8.displayName()));
    }

    public static MailRepositoryPath from(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"Supplied MailRepositoryPath value is null");
        return new MailRepositoryPath(MailRepositoryPath.sanitizePath(path));
    }

    private static String sanitizePath(String path) {
        return StringUtils.stripEnd((String)path, (String)PATH_DELIMITER);
    }

    private MailRepositoryPath(String value) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    public MailRepositoryPath subPath(String suffix) {
        Preconditions.checkArgument((!suffix.startsWith(PATH_DELIMITER) ? 1 : 0) != 0, (Object)"The suffix used can not start by the path delimiter");
        return MailRepositoryPath.from(this.value + PATH_DELIMITER + suffix);
    }

    public boolean hasPrefix(MailRepositoryPath other) {
        if (this.value.isEmpty()) {
            return false;
        }
        if (other.value.isEmpty()) {
            return true;
        }
        return this.value.startsWith(other.value + PATH_DELIMITER);
    }

    public List<String> parts() {
        return Splitter.on((String)PATH_DELIMITER).omitEmptyStrings().splitToList((CharSequence)this.value);
    }

    public String asString() {
        return this.value;
    }

    public String urlEncoded() throws UnsupportedEncodingException {
        return URLEncoder.encode(this.value, StandardCharsets.UTF_8.displayName());
    }

    public final boolean equals(Object o) {
        if (o instanceof MailRepositoryPath) {
            MailRepositoryPath that = (MailRepositoryPath)o;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }

    @Override
    public int compareTo(MailRepositoryPath that) {
        return this.value.compareTo(that.value);
    }
}

