/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.draft.methods.ErrorResponse;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.methods.JmapResponse;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.MethodCallId;
import org.apache.james.jmap.draft.model.SetError;
import org.apache.james.jmap.draft.model.SetVacationRequest;
import org.apache.james.jmap.draft.model.SetVacationResponse;
import org.apache.james.jmap.draft.model.VacationResponse;
import org.apache.james.jmap.draft.utils.AccountIdUtil;
import org.apache.james.jmap.http.LoggingHelper;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.apache.james.vacation.api.VacationService;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class SetVacationResponseMethod
implements Method {
    public static final Method.Request.Name METHOD_NAME = Method.Request.name("setVacationResponse");
    public static final Method.Response.Name RESPONSE_NAME = Method.Response.name("vacationResponseSet");
    public static final String INVALID_ARGUMENTS = "invalidArguments";
    public static final String ERROR_MESSAGE_BASE = "There is one VacationResponse object per account, with id set to \\\"singleton\\\" and not to ";
    public static final String INVALID_ARGUMENTS1 = "invalidArguments";
    public static final String INVALID_ARGUMENT_DESCRIPTION = "update field should just contain one entry with key \"singleton\"";
    private final VacationService vacationService;
    private final MetricFactory metricFactory;

    @Inject
    public SetVacationResponseMethod(VacationService vacationService, MetricFactory metricFactory) {
        this.vacationService = vacationService;
        this.metricFactory = metricFactory;
    }

    @Override
    public Method.Request.Name requestHandled() {
        return METHOD_NAME;
    }

    @Override
    public Class<? extends JmapRequest> requestType() {
        return SetVacationRequest.class;
    }

    @Override
    public Flux<JmapResponse> process(JmapRequest request, MethodCallId methodCallId, MailboxSession mailboxSession) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)methodCallId);
        Preconditions.checkNotNull((Object)mailboxSession);
        Preconditions.checkArgument((boolean)(request instanceof SetVacationRequest));
        SetVacationRequest setVacationRequest = (SetVacationRequest)request;
        return Flux.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("JMAP-" + METHOD_NAME.getName(), (Publisher)this.process(methodCallId, mailboxSession, setVacationRequest).contextWrite((ContextView)LoggingHelper.jmapAction("SET_VACATION")).contextWrite((ContextView)ReactorUtils.context((String)"set-vacation", (MDCBuilder)MDCBuilder.ofValue((String)"update", (String)setVacationRequest.getUpdate().toString())))));
    }

    private Flux<JmapResponse> process(MethodCallId methodCallId, MailboxSession mailboxSession, SetVacationRequest setVacationRequest) {
        if (!setVacationRequest.isValid()) {
            return Flux.just((Object)JmapResponse.builder().methodCallId(methodCallId).error(ErrorResponse.builder().type("invalidArguments").description(INVALID_ARGUMENT_DESCRIPTION).build()).build());
        }
        return this.process(methodCallId, AccountId.fromUsername((Username)mailboxSession.getUser()), setVacationRequest.getUpdate().get("singleton"));
    }

    private Flux<JmapResponse> process(MethodCallId methodCallId, AccountId accountId, VacationResponse vacationResponse) {
        if (vacationResponse.isValid()) {
            return this.vacationService.modifyVacation(AccountIdUtil.toVacationAccountId(accountId), vacationResponse.getPatch()).thenMany((Publisher)Mono.just((Object)JmapResponse.builder().methodCallId(methodCallId).responseName(RESPONSE_NAME).response(SetVacationResponse.builder().updatedId("singleton").build()).build()));
        }
        return Flux.just((Object)JmapResponse.builder().methodCallId(methodCallId).responseName(RESPONSE_NAME).response(SetVacationResponse.builder().notUpdated("singleton", SetError.builder().type(SetError.Type.INVALID_ARGUMENTS).description(ERROR_MESSAGE_BASE + vacationResponse.getId()).build()).build()).build());
    }
}

