/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.filtering.FilteringManagement;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.draft.methods.ErrorResponse;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.methods.JmapResponse;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.JmapRuleDTO;
import org.apache.james.jmap.draft.model.MethodCallId;
import org.apache.james.jmap.draft.model.SetError;
import org.apache.james.jmap.draft.model.SetFilterRequest;
import org.apache.james.jmap.draft.model.SetFilterResponse;
import org.apache.james.jmap.http.LoggingHelper;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class SetFilterMethod
implements Method {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetFilterMethod.class);
    private static final Method.Request.Name METHOD_NAME = Method.Request.name("setFilter");
    private static final Method.Response.Name RESPONSE_NAME = Method.Response.name("filterSet");
    private final MetricFactory metricFactory;
    private final FilteringManagement filteringManagement;

    private static String format(ImmutableList<Rule.Id> ids) {
        return "[" + ids.stream().map(Rule.Id::asString).map(SetFilterMethod::quote).collect(Collectors.joining(",")) + "]";
    }

    private static String quote(String s) {
        return "'" + s + "'";
    }

    @Inject
    public SetFilterMethod(MetricFactory metricFactory, FilteringManagement filteringManagement) {
        this.filteringManagement = filteringManagement;
        this.metricFactory = metricFactory;
    }

    @Override
    public Method.Request.Name requestHandled() {
        return METHOD_NAME;
    }

    @Override
    public Class<? extends JmapRequest> requestType() {
        return SetFilterRequest.class;
    }

    @Override
    public Flux<JmapResponse> process(JmapRequest request, MethodCallId methodCallId, MailboxSession mailboxSession) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)methodCallId);
        Preconditions.checkNotNull((Object)mailboxSession);
        Preconditions.checkArgument((boolean)(request instanceof SetFilterRequest));
        SetFilterRequest setFilterRequest = (SetFilterRequest)request;
        return Flux.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("JMAP-" + METHOD_NAME.getName(), (Publisher)this.process(methodCallId, mailboxSession, setFilterRequest).contextWrite((ContextView)LoggingHelper.jmapAction("SET_FILTER")).contextWrite((ContextView)ReactorUtils.context((String)"SET_FILTER", (MDCBuilder)MDCBuilder.ofValue((String)"update", (String)setFilterRequest.getSingleton().toString())))));
    }

    private Mono<JmapResponse> process(MethodCallId methodCallId, MailboxSession mailboxSession, SetFilterRequest request) {
        try {
            return this.updateFilter(methodCallId, request, mailboxSession.getUser()).doOnEach(ReactorUtils.logOnError(e -> LOGGER.warn("Failed setting Rules", e))).onErrorResume(e -> Mono.just((Object)this.unknownError(methodCallId)));
        }
        catch (MultipleMailboxIdException e2) {
            LOGGER.debug("Rule targeting several mailboxes", (Throwable)e2);
            return Mono.just((Object)this.multipleMailboxesError(methodCallId, e2));
        }
        catch (DuplicatedRuleException e3) {
            LOGGER.debug("Duplicated rules", (Throwable)e3);
            return Mono.just((Object)this.duplicatedIdsError(methodCallId, e3));
        }
        catch (IllegalArgumentException e4) {
            LOGGER.warn("IllegalArgumentException of setting Rules", (Throwable)e4);
            return Mono.just((Object)this.invalidArgumentsError(methodCallId, e4.getMessage()));
        }
        catch (IllegalStateException e5) {
            LOGGER.warn("IllegalStateException of setting Rules", (Throwable)e5);
            return Mono.just((Object)this.invalidArgumentsError(methodCallId, e5.getMessage()));
        }
        catch (Exception e6) {
            LOGGER.warn("Failed setting Rules", (Throwable)e6);
            return Mono.just((Object)this.unknownError(methodCallId));
        }
    }

    private Mono<JmapResponse> updateFilter(MethodCallId methodCallId, SetFilterRequest request, Username username) throws DuplicatedRuleException, MultipleMailboxIdException {
        ImmutableList rules = (ImmutableList)request.getSingleton().stream().map(JmapRuleDTO::toRule).collect(ImmutableList.toImmutableList());
        this.ensureNoDuplicatedRules((List<Rule>)rules);
        this.ensureNoMultipleMailboxesRules((ImmutableList<Rule>)rules);
        return Mono.from((Publisher)this.filteringManagement.defineRulesForUser(username, (List)rules, Optional.empty())).thenReturn((Object)JmapResponse.builder().methodCallId(methodCallId).responseName(RESPONSE_NAME).response(SetFilterResponse.updated()).build());
    }

    private void ensureNoMultipleMailboxesRules(ImmutableList<Rule> rules) throws MultipleMailboxIdException {
        ImmutableList idWithMultipleMailboxes = (ImmutableList)rules.stream().filter(rule -> rule.getAction().getAppendInMailboxes().getMailboxIds().size() > 1).map(Rule::getId).collect(ImmutableList.toImmutableList());
        if (!idWithMultipleMailboxes.isEmpty()) {
            throw new MultipleMailboxIdException((ImmutableList<Rule.Id>)idWithMultipleMailboxes);
        }
    }

    private void ensureNoDuplicatedRules(List<Rule> rules) throws DuplicatedRuleException {
        ImmutableList duplicatedIds = (ImmutableList)((ImmutableListMultimap)rules.stream().collect(ImmutableListMultimap.toImmutableListMultimap(Rule::getId, Function.identity()))).asMap().entrySet().stream().filter(entry -> ((Collection)entry.getValue()).size() > 1).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        if (!duplicatedIds.isEmpty()) {
            throw new DuplicatedRuleException((ImmutableList<Rule.Id>)duplicatedIds);
        }
    }

    private JmapResponse unknownError(MethodCallId methodCallId) {
        return this.unknownError(methodCallId, "Failed to retrieve filter");
    }

    private JmapResponse invalidArgumentsError(MethodCallId methodCallId, String errorMessage) {
        return JmapResponse.builder().methodCallId(methodCallId).responseName(RESPONSE_NAME).response(ErrorResponse.builder().type(SetError.Type.INVALID_ARGUMENTS.asString()).description(errorMessage).build()).build();
    }

    private JmapResponse unknownError(MethodCallId methodCallId, String errorMessage) {
        return JmapResponse.builder().methodCallId(methodCallId).responseName(RESPONSE_NAME).response(ErrorResponse.builder().type(SetError.Type.ERROR.asString()).description(errorMessage).build()).build();
    }

    private JmapResponse duplicatedIdsError(MethodCallId methodCallId, DuplicatedRuleException e) {
        return JmapResponse.builder().methodCallId(methodCallId).responseName(RESPONSE_NAME).response(SetFilterResponse.notUpdated(SetError.builder().type(SetError.Type.INVALID_ARGUMENTS).description("The following rules were duplicated: " + SetFilterMethod.format(e.duplicatedIds)).build())).build();
    }

    private JmapResponse multipleMailboxesError(MethodCallId methodCallId, MultipleMailboxIdException e) {
        return JmapResponse.builder().methodCallId(methodCallId).responseName(RESPONSE_NAME).response(SetFilterResponse.notUpdated(SetError.builder().type(SetError.Type.INVALID_ARGUMENTS).description("The following rules targeted several mailboxes, which is not supported: " + SetFilterMethod.format(e.idsWithMultipleMailboxes)).build())).build();
    }

    public static class MultipleMailboxIdException
    extends Exception {
        private final ImmutableList<Rule.Id> idsWithMultipleMailboxes;

        public MultipleMailboxIdException(ImmutableList<Rule.Id> idsWithMultipleMailboxes) {
            super("The following rules were targeting several mailboxes:" + SetFilterMethod.format(idsWithMultipleMailboxes));
            this.idsWithMultipleMailboxes = idsWithMultipleMailboxes;
        }
    }

    public static class DuplicatedRuleException
    extends Exception {
        private final ImmutableList<Rule.Id> duplicatedIds;

        public DuplicatedRuleException(ImmutableList<Rule.Id> duplicatedIds) {
            super("The following rules were duplicated:" + SetFilterMethod.format(duplicatedIds));
            this.duplicatedIds = duplicatedIds;
        }
    }
}

