/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveByteCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class TinyIntCodec
implements PrimitiveByteCodec {
    @Override
    @NonNull
    public GenericType<Byte> getJavaType() {
        return GenericType.BYTE;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.TINYINT;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof Byte;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Byte.class || javaClass == Byte.TYPE;
    }

    @Override
    @Nullable
    public ByteBuffer encodePrimitive(byte value, @NonNull ProtocolVersion protocolVersion) {
        ByteBuffer bytes = ByteBuffer.allocate(1);
        bytes.put(0, value);
        return bytes;
    }

    @Override
    public byte decodePrimitive(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return 0;
        }
        if (bytes.remaining() != 1) {
            throw new IllegalArgumentException("Invalid 8-bits integer value, expecting 1 byte but got " + bytes.remaining());
        }
        return bytes.get(bytes.position());
    }

    @Override
    @NonNull
    public String format(@Nullable Byte value) {
        return value == null ? "NULL" : Byte.toString(value);
    }

    @Override
    @Nullable
    public Byte parse(@Nullable String value) {
        try {
            return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : Byte.valueOf(Byte.parseByte(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse 8-bits int value from \"%s\"", value));
        }
    }
}

