/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.SearchRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedRequestAccessLogMessage;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.List;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class TextFormattedSearchRequestAccessLogMessage
extends TextFormattedRequestAccessLogMessage
implements SearchRequestAccessLogMessage {
    private static final long serialVersionUID = 7498979077353447769L;
    @Nullable
    private final Boolean typesOnly;
    @Nullable
    private final DereferencePolicy dereferencePolicy;
    @Nullable
    private final Integer sizeLimit;
    @Nullable
    private final Integer timeLimit;
    @NotNull
    private final List<String> requestedAttributes;
    @Nullable
    private final SearchScope scope;
    @Nullable
    private final String baseDN = this.getString(TextFormattedAccessLogFields.SEARCH_BASE_DN);
    @Nullable
    private final String filter = this.getString(TextFormattedAccessLogFields.SEARCH_FILTER);

    public TextFormattedSearchRequestAccessLogMessage(@NotNull String logMessageString) throws LogException {
        this(new TextFormattedLogMessage(logMessageString));
    }

    TextFormattedSearchRequestAccessLogMessage(@NotNull TextFormattedLogMessage logMessage) {
        super(logMessage);
        this.sizeLimit = this.getIntegerNoThrow(TextFormattedAccessLogFields.SEARCH_SIZE_LIMIT);
        this.timeLimit = this.getIntegerNoThrow(TextFormattedAccessLogFields.SEARCH_TIME_LIMIT_SECONDS);
        this.typesOnly = this.getBooleanNoThrow(TextFormattedAccessLogFields.SEARCH_TYPES_ONLY);
        Integer scopeValue = this.getIntegerNoThrow(TextFormattedAccessLogFields.SEARCH_SCOPE_VALUE);
        this.scope = scopeValue == null ? null : SearchScope.valueOf(scopeValue);
        String derefStr = this.getString(TextFormattedAccessLogFields.SEARCH_DEREF_POLICY);
        if (derefStr == null) {
            this.dereferencePolicy = null;
        } else {
            DereferencePolicy policy = null;
            for (DereferencePolicy p : DereferencePolicy.values()) {
                if (!p.getName().equalsIgnoreCase(derefStr)) continue;
                policy = p;
                break;
            }
            this.dereferencePolicy = policy;
        }
        List<String> requestedAttrsList = this.getCommaDelimitedStringList(TextFormattedAccessLogFields.SEARCH_REQUESTED_ATTRIBUTES);
        this.requestedAttributes = requestedAttrsList.size() == 1 && requestedAttrsList.get(0).equals("ALL") ? Collections.emptyList() : requestedAttrsList;
    }

    @Override
    @NotNull
    public final AccessLogOperationType getOperationType() {
        return AccessLogOperationType.SEARCH;
    }

    @Override
    @Nullable
    public final String getBaseDN() {
        return this.baseDN;
    }

    @Override
    @Nullable
    public final SearchScope getScope() {
        return this.scope;
    }

    @Override
    @Nullable
    public final String getFilter() {
        return this.filter;
    }

    @Override
    @Nullable
    public final DereferencePolicy getDereferencePolicy() {
        return this.dereferencePolicy;
    }

    @Override
    @Nullable
    public final Integer getSizeLimit() {
        return this.sizeLimit;
    }

    @Override
    @Nullable
    public final Integer getTimeLimitSeconds() {
        return this.timeLimit;
    }

    @Override
    @Nullable
    public final Boolean getTypesOnly() {
        return this.typesOnly;
    }

    @Override
    @NotNull
    public final List<String> getRequestedAttributes() {
        return this.requestedAttributes;
    }
}

