/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class BasicAsyncSearchResultListener
implements AsyncSearchResultListener {
    private static final long serialVersionUID = 2289128360755244209L;
    @NotNull
    private final List<SearchResultEntry> entryList = new ArrayList<SearchResultEntry>(5);
    @NotNull
    private final List<SearchResultReference> referenceList = new ArrayList<SearchResultReference>(5);
    @Nullable
    private volatile SearchResult searchResult = null;

    @Override
    @InternalUseOnly
    public void searchEntryReturned(@NotNull SearchResultEntry searchEntry) {
        this.entryList.add(searchEntry);
    }

    @Override
    @InternalUseOnly
    public void searchReferenceReturned(@NotNull SearchResultReference searchReference) {
        this.referenceList.add(searchReference);
    }

    @Override
    @InternalUseOnly
    public void searchResultReceived(@NotNull AsyncRequestID requestID, @NotNull SearchResult searchResult) {
        this.searchResult = searchResult;
    }

    @Nullable
    public SearchResult getSearchResult() {
        return this.searchResult;
    }

    @NotNull
    public List<SearchResultEntry> getSearchEntries() {
        return Collections.unmodifiableList(this.entryList);
    }

    @NotNull
    public List<SearchResultReference> getSearchReferences() {
        return Collections.unmodifiableList(this.referenceList);
    }
}

