/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.auto$;
import eu.timepit.refined.string;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.ErrorCode$InvalidArguments$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.json.EmailGetSerializer$;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.mail.Email$;
import org.apache.james.jmap.mail.EmailGetRequest;
import org.apache.james.jmap.mail.EmailGetResponse;
import org.apache.james.jmap.mail.EmailIds;
import org.apache.james.jmap.mail.EmailView;
import org.apache.james.jmap.mail.EmailViewReaderFactory;
import org.apache.james.jmap.mail.UnparsedEmailId;
import org.apache.james.jmap.method.EmailGetMethod$;
import org.apache.james.jmap.method.EmailGetResults;
import org.apache.james.jmap.method.EmailGetResults$;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonValidationError;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t-s!B\u000f\u001f\u0011\u0003Ic!B\u0016\u001f\u0011\u0003a\u0003\"B\u001a\u0002\t\u0003!\u0004bB\u001b\u0002\u0005\u0004%IA\u000e\u0005\u0007{\u0005\u0001\u000b\u0011B\u001c\u0007\t-r\u0002A\u0010\u0005\t\u0011\u0016\u0011\t\u0011)A\u0005\u0013\"AA*\u0002B\u0001B\u0003%Q\n\u0003\u0005Z\u000b\t\u0015\r\u0011\"\u0001[\u0011!\u0019WA!A!\u0002\u0013Y\u0006\u0002\u00033\u0006\u0005\u000b\u0007I\u0011A3\t\u00115,!\u0011!Q\u0001\n\u0019D\u0001B\\\u0003\u0003\u0006\u0004%\ta\u001c\u0005\tm\u0016\u0011\t\u0011)A\u0005a\"Aq/\u0002BC\u0002\u0013\u0005\u0001\u0010\u0003\u0005\u0000\u000b\t\u0005\t\u0015!\u0003z\u0011\u0019\u0019T\u0001\"\u0001\u0002\u0002!I\u00111E\u0003C\u0002\u0013\u0005\u0013Q\u0005\u0005\t\u0003\u001f*\u0001\u0015!\u0003\u0002(!I\u0011\u0011K\u0003C\u0002\u0013\u0005\u00131\u000b\u0005\t\u0003g*\u0001\u0015!\u0003\u0002V!9\u0011QO\u0003\u0005B\u0005]\u0004bBAV\u000b\u0011\u0005\u0013Q\u0016\u0005\b\u0003#,A\u0011BAj\u0011\u001d\ty.\u0002C\u0005\u0003CDq!!=\u0006\t\u0013\t\u0019\u0010C\u0004\u0002`\u0016!IA!\u0001\t\u000f\teQ\u0001\"\u0003\u0003\u001c!9!QG\u0003\u0005\n\t]\u0012AD#nC&dw)\u001a;NKRDw\u000e\u001a\u0006\u0003?\u0001\na!\\3uQ>$'BA\u0011#\u0003\u0011QW.\u00199\u000b\u0005\r\"\u0013!\u00026b[\u0016\u001c(BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002+\u00035\taD\u0001\bF[\u0006LGnR3u\u001b\u0016$\bn\u001c3\u0014\u0005\u0005i\u0003C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002S\u00051An\\4hKJ,\u0012a\u000e\t\u0003qmj\u0011!\u000f\u0006\u0003u\u0019\nQa\u001d7gi)L!\u0001P\u001d\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\u001a2!B\u0017@!\rQ\u0003IQ\u0005\u0003\u0003z\u0011\u0001$T3uQ>$'+Z9vSJLgnZ!dG>,h\u000e^%e!\t\u0019e)D\u0001E\u0015\t)\u0005%\u0001\u0003nC&d\u0017BA$E\u0005=)U.Y5m\u000f\u0016$(+Z9vKN$\u0018!\u0004:fC\u0012,'OR1di>\u0014\u0018\u0010\u0005\u0002D\u0015&\u00111\n\u0012\u0002\u0017\u000b6\f\u0017\u000e\u001c,jK^\u0014V-\u00193fe\u001a\u000b7\r^8ss\u0006\u0001R.Z:tC\u001e,\u0017\n\u001a$bGR|'/\u001f\t\u0003\u001dZs!a\u0014+\u000e\u0003AS!!\u0015*\u0002\u000b5|G-\u001a7\u000b\u0005M\u0013\u0013aB7bS2\u0014w\u000e_\u0005\u0003+B\u000b\u0011\"T3tg\u0006<W-\u00133\n\u0005]C&a\u0002$bGR|'/\u001f\u0006\u0003+B\u000bQ\"\\3ue&\u001cg)Y2u_JLX#A.\u0011\u0005q\u000bW\"A/\u000b\u0005y{\u0016aA1qS*\u0011\u0001MI\u0001\b[\u0016$(/[2t\u0013\t\u0011WLA\u0007NKR\u0014\u0018n\u0019$bGR|'/_\u0001\u000f[\u0016$(/[2GC\u000e$xN]=!\u0003U)W.Y5mG\"\fgnZ3SKB|7/\u001b;pef,\u0012A\u001a\t\u0003O.l\u0011\u0001\u001b\u0006\u0003S*\faa\u00195b]\u001e,'B\u00010!\u0013\ta\u0007NA\u000bF[\u0006LGn\u00115b]\u001e,'+\u001a9pg&$xN]=\u0002-\u0015l\u0017-\u001b7dQ\u0006tw-\u001a*fa>\u001c\u0018\u000e^8ss\u0002\nqb]3tg&|gnU;qa2LWM]\u000b\u0002aB\u0011\u0011\u000f^\u0007\u0002e*\u00111\u000fI\u0001\u0007e>,H/Z:\n\u0005U\u0014(aD*fgNLwN\\*vaBd\u0017.\u001a:\u0002!M,7o]5p]N+\b\u000f\u001d7jKJ\u0004\u0013!E:fgNLwN\u001c+sC:\u001cH.\u0019;peV\t\u0011\u0010\u0005\u0002{{6\t1P\u0003\u0002}A\u0005!1m\u001c:f\u0013\tq8PA\tTKN\u001c\u0018n\u001c8Ue\u0006t7\u000f\\1u_J\f!c]3tg&|g\u000e\u0016:b]Nd\u0017\r^8sAQq\u00111AA\u0003\u0003\u000f\tI!a\u0003\u0002\u000e\u0005=\u0001C\u0001\u0016\u0006\u0011\u0015A\u0005\u00031\u0001J\u0011\u0015a\u0005\u00031\u0001N\u0011\u0015I\u0006\u00031\u0001\\\u0011\u0015!\u0007\u00031\u0001g\u0011\u0015q\u0007\u00031\u0001q\u0011\u00159\b\u00031\u0001zQ\r\u0001\u00121\u0003\t\u0005\u0003+\ty\"\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u0019IgN[3di*\u0011\u0011QD\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003C\t9B\u0001\u0004J]*,7\r^\u0001\u000b[\u0016$\bn\u001c3OC6,WCAA\u0014!\u0011\tI#!\u0013\u000f\t\u0005-\u0012Q\t\b\u0005\u0003[\t\u0019E\u0004\u0003\u00020\u0005\u0005c\u0002BA\u0019\u0003\u007fqA!a\r\u0002>9!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:!\na\u0001\u0010:p_Rt\u0014\"A\u0014\n\u0005\u00152\u0013BA\u0012%\u0013\t\t#%\u0003\u0002}A%\u0019\u0011qI>\u0002\u0015%sgo\\2bi&|g.\u0003\u0003\u0002L\u00055#AC'fi\"|GMT1nK*\u0019\u0011qI>\u0002\u00175,G\u000f[8e\u001d\u0006lW\rI\u0001\u0015e\u0016\fX/\u001b:fI\u000e\u000b\u0007/\u00192jY&$\u0018.Z:\u0016\u0005\u0005U\u0003CBA,\u0003?\n)G\u0004\u0003\u0002Z\u0005m\u0003cAA\u001b_%\u0019\u0011QL\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t'a\u0019\u0003\u0007M+GOC\u0002\u0002^=\u0002B!a\u001a\u0002n9!\u00111FA5\u0013\r\tYg_\u0001\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\n\t\u0005=\u0014\u0011\u000f\u0002\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\u000b\u0007\u0005-40A\u000bsKF,\u0018N]3e\u0007\u0006\u0004\u0018MY5mSRLWm\u001d\u0011\u0002\u0013\u0011|\u0007K]8dKN\u001cHCCA=\u0003'\u000b9*a'\u0002(B1\u00111PAE\u0003\u001bk!!! \u000b\t\u0005}\u0014\u0011Q\u0001\naV\u0014G.[:iKJT1\u0001MAB\u0015\ra\u0018Q\u0011\u0006\u0003\u0003\u000f\u000bqA]3bGR|'/\u0003\u0003\u0002\f\u0006u$!B*N_:|\u0007c\u0001\u0016\u0002\u0010&\u0019\u0011\u0011\u0013\u0010\u0003+%sgo\\2bi&|gnV5uQ\u000e{g\u000e^3yi\"9\u0011QS\u000bA\u0002\u0005U\u0013\u0001D2ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001c\bbBAM+\u0001\u0007\u0011QR\u0001\u000bS:4xnY1uS>t\u0007bBAO+\u0001\u0007\u0011qT\u0001\u000f[\u0006LGNY8y'\u0016\u001c8/[8o!\u0011\t\t+a)\u000e\u0003IK1!!*S\u00059i\u0015-\u001b7c_b\u001cVm]:j_:Da!!+\u0016\u0001\u0004\u0011\u0015a\u0002:fcV,7\u000f^\u0001\u000bO\u0016$(+Z9vKN$HCBAX\u0003\u000f\fI\rE\u0004\u00022\u0006m\u0016\u0011\u0019\"\u000f\t\u0005M\u0016q\u0017\b\u0005\u0003k\t),C\u00011\u0013\r\tIlL\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti,a0\u0003\r\u0015KG\u000f[3s\u0015\r\tIl\f\t\u0005\u0003c\u000b\u0019-\u0003\u0003\u0002F\u0006}&\u0001G%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]\"9\u0011Q\u0014\fA\u0002\u0005}\u0005bBAM-\u0001\u0007\u00111\u001a\t\u0004u\u00065\u0017bAAhw\nQ\u0011J\u001c<pG\u0006$\u0018n\u001c8\u00023\r|W\u000e];uKJ+7\u000f]8og\u0016LeN^8dCRLwN\u001c\u000b\u000b\u0003+\f9.!7\u0002\\\u0006u\u0007CBA>\u0003\u0013\u000bY\rC\u0004\u0002\u0016^\u0001\r!!\u0016\t\r\u0005%v\u00031\u0001C\u0011\u001d\tIj\u0006a\u0001\u0003\u0017Dq!!(\u0018\u0001\u0004\ty*A\u0005hKR,U.Y5mgRA\u00111]Av\u0003[\fy\u000f\u0005\u0004\u0002|\u0005%\u0015Q\u001d\t\u0004\u0007\u0006\u001d\u0018bAAu\t\n\u0001R)\\1jY\u001e+GOU3ta>t7/\u001a\u0005\b\u0003+C\u0002\u0019AA+\u0011\u0019\tI\u000b\u0007a\u0001\u0005\"9\u0011Q\u0014\rA\u0002\u0005}\u0015!\u0004:fiJLWM^3Ti\u0006$X\r\u0006\u0004\u0002v\u0006u\u0018q \t\u0007\u0003w\nI)a>\u0011\u0007\u001d\fI0C\u0002\u0002|\"\u0014Qa\u0015;bi\u0016Dq!!&\u001a\u0001\u0004\t)\u0006C\u0004\u0002\u001ef\u0001\r!a(\u0015\u0011\t\r!1\u0002B\u000b\u0005/\u0001b!a\u001f\u0002\n\n\u0015\u0001c\u0001\u0016\u0003\b%\u0019!\u0011\u0002\u0010\u0003\u001f\u0015k\u0017-\u001b7HKR\u0014Vm];miNDqA!\u0004\u001b\u0001\u0004\u0011y!A\u0002jIN\u00042a\u0011B\t\u0013\r\u0011\u0019\u0002\u0012\u0002\t\u000b6\f\u0017\u000e\\%eg\"9\u0011Q\u0014\u000eA\u0002\u0005}\u0005BBAU5\u0001\u0007!)A\u0006bg6+7o]1hK&#G\u0003\u0002B\u000f\u0005c\u0001\u0002\"!-\u0002<\n}!1\u0006\t\b]\t\u0005\"QEAa\u0013\r\u0011\u0019c\f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007\r\u00139#C\u0002\u0003*\u0011\u0013q\"\u00168qCJ\u001cX\rZ#nC&d\u0017\n\u001a\t\u0004\u001f\n5\u0012b\u0001B\u0018!\nIQ*Z:tC\u001e,\u0017\n\u001a\u0005\b\u0005gY\u0002\u0019\u0001B\u0013\u0003\tIG-\u0001\bsKR\u0014\u0018.\u001a<f\u000b6\f\u0017\u000e\\:\u0015\u0011\te\"q\bB$\u0005\u0013\u0002b!a\u001f\u0003<\t\u0015\u0011\u0002\u0002B\u001f\u0003{\u0012Qa\u0015$mkbDqA!\u0004\u001d\u0001\u0004\u0011\t\u0005\u0005\u0004\u00022\n\r#1F\u0005\u0005\u0005\u000b\nyLA\u0002TKFDq!!(\u001d\u0001\u0004\ty\n\u0003\u0004\u0002*r\u0001\rA\u0011")
public class EmailGetMethod
implements MethodRequiringAccountId<EmailGetRequest> {
    private final EmailViewReaderFactory readerFactory;
    private final MessageId.Factory messageIdFactory;
    private final MetricFactory metricFactory;
    private final EmailChangeRepository emailchangeRepository;
    private final SessionSupplier sessionSupplier;
    private final SessionTranslator sessionTranslator;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    public EmailChangeRepository emailchangeRepository() {
        return this.emailchangeRepository;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public SessionTranslator sessionTranslator() {
        return this.sessionTranslator;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public SMono<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, EmailGetRequest request) {
        return this.computeResponseInvocation(capabilities, request, invocation.invocation(), mailboxSession).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                return SMono$.MODULE$.just((Object)Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, illegalArgumentException.getMessage(), invocation.invocation().methodCallId()));
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                return SMono$.MODULE$.error(throwable2);
            }
            throw new MatchError((Object)throwable);
        }).map((Function1 & Serializable)invocationResult -> new InvocationWithContext((Invocation)invocationResult, invocation.processingContext()));
    }

    @Override
    public Either<IllegalArgumentException, EmailGetRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        return EmailGetSerializer$.MODULE$.deserializeEmailGetRequest((JsValue)invocation.arguments()).asEither().left().map((Function1 & Serializable)errors -> ResponseSerializer$.MODULE$.asException((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)errors));
    }

    private SMono<Invocation> computeResponseInvocation(Set<Refined<String, string.Uri>> capabilities, EmailGetRequest request, Invocation invocation, MailboxSession mailboxSession) {
        return (SMono)Email$.MODULE$.validateProperties(request.properties()).flatMap((Function1 & Serializable)properties -> Email$.MODULE$.validateBodyProperties(request.bodyProperties()).map((Function1 & Serializable)x$1 -> new Tuple2(properties, x$1))).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Properties properties = (Properties)tuple2._1();
                Properties bodyProperties = (Properties)tuple2._2();
                return this.getEmails(capabilities, request, mailboxSession).map((Function1 & Serializable)response -> new Invocation(this.methodName(), (JsObject)EmailGetSerializer$.MODULE$.serialize((EmailGetResponse)response, properties, bodyProperties).as((Reads)Reads$.MODULE$.JsObjectReads()), invocation.methodCallId()));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private SMono<EmailGetResponse> getEmails(Set<Refined<String, string.Uri>> capabilities, EmailGetRequest request, MailboxSession mailboxSession) {
        Option<EmailIds> option = request.ids();
        if (None$.MODULE$.equals(option)) {
            return SMono$.MODULE$.error((Throwable)new IllegalArgumentException("ids can not be ommited for email/get"));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            EmailIds ids = (EmailIds)some.value();
            return this.getEmails(ids, mailboxSession, request).flatMap((Function1 & Serializable)result -> this.retrieveState(capabilities, mailboxSession).map((Function1 & Serializable)state -> new EmailGetResponse(request.accountId(), UuidState$.MODULE$.fromJava((State)state), (List<EmailView>)result.emails().toList(), result.notFound())));
        }
        throw new MatchError(option);
    }

    private SMono<State> retrieveState(Set<Refined<String, string.Uri>> capabilities, MailboxSession mailboxSession) {
        AccountId accountId = AccountId.fromUsername((Username)mailboxSession.getUser());
        if (capabilities.contains((Object)new Refined((Object)CapabilityIdentifier$.MODULE$.JAMES_SHARES()))) {
            return SMono$.MODULE$.apply((Publisher)this.emailchangeRepository().getLatestStateWithDelegation(accountId));
        }
        return SMono$.MODULE$.apply((Publisher)this.emailchangeRepository().getLatestState(accountId));
    }

    private SMono<EmailGetResults> getEmails(EmailIds ids, MailboxSession mailboxSession, EmailGetRequest request) {
        List parsedIds = ids.value().map((Function1 & Serializable)id -> this.asMessageId((UnparsedEmailId)id));
        List messagesIds = parsedIds.flatMap((Function1 & Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Left) {
                return None$.MODULE$;
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                MessageId messageId = (MessageId)right.value();
                return new Some((Object)messageId);
            }
            throw new MatchError((Object)either);
        });
        SFlux parsingErrors = SFlux$.MODULE$.fromIterable((Iterable)parsedIds.flatMap((Function1 & Serializable)x0$2 -> {
            Left left;
            Tuple2 tuple2;
            Either either = x0$2;
            if (either instanceof Left && (tuple2 = (Tuple2)(left = (Left)either).value()) != null) {
                UnparsedEmailId id = (UnparsedEmailId)tuple2._1();
                IllegalArgumentException error = (IllegalArgumentException)tuple2._2();
                EmailGetMethod$.MODULE$.org$apache$james$jmap$method$EmailGetMethod$$logger().warn("id parsing failed", (Throwable)error);
                return new Some((Object)EmailGetResults$.MODULE$.notFound(id));
            }
            if (either instanceof Right) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)either);
        }));
        return SFlux$.MODULE$.merge((scala.collection.immutable.Seq)new .colon.colon(this.retrieveEmails((scala.collection.immutable.Seq<MessageId>)messagesIds, mailboxSession, request), (List)new .colon.colon((Object)parsingErrors, (List)Nil$.MODULE$)), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3()).reduce((Object)EmailGetResults$.MODULE$.empty(), (Function2 & Serializable)(result1, result2) -> EmailGetResults$.MODULE$.merge((EmailGetResults)result1, (EmailGetResults)result2));
    }

    private Either<Tuple2<UnparsedEmailId, IllegalArgumentException>, MessageId> asMessageId(UnparsedEmailId id) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply((Object)this.messageIdFactory.fromString((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)id.id()), RefType$.MODULE$.refinedRefType())));
        }
        catch (Exception e) {
            left = package$.MODULE$.Left().apply((Object)new Tuple2((Object)id, (Object)new IllegalArgumentException(e)));
        }
        return left;
    }

    private SFlux<EmailGetResults> retrieveEmails(scala.collection.immutable.Seq<MessageId> ids, MailboxSession mailboxSession, EmailGetRequest request) {
        SMono foundResultsMono = this.readerFactory.selectReader(request).read(ids, request, mailboxSession).collectMap((Function1 & Serializable)x$2 -> x$2.metadata().id());
        return foundResultsMono.flatMapIterable((Function1 & Serializable)foundResults -> (scala.collection.immutable.Seq)ids.map((Function1 & Serializable)id -> (EmailGetResults)foundResults.get(id).map((Function1 & Serializable)email -> EmailGetResults$.MODULE$.found((EmailView)email)).getOrElse((Function0 & Serializable)() -> EmailGetResults$.MODULE$.notFound((MessageId)id))));
    }

    @Inject
    public EmailGetMethod(EmailViewReaderFactory readerFactory, MessageId.Factory messageIdFactory, MetricFactory metricFactory, EmailChangeRepository emailchangeRepository, SessionSupplier sessionSupplier, SessionTranslator sessionTranslator) {
        this.readerFactory = readerFactory;
        this.messageIdFactory = messageIdFactory;
        this.metricFactory = metricFactory;
        this.emailchangeRepository = emailchangeRepository;
        this.sessionSupplier = sessionSupplier;
        this.sessionTranslator = sessionTranslator;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"Email/get")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MAIL())}));
        Statics.releaseFence();
    }
}

