/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.SuspectedException;
import org.jgroups.UnreachableException;
import org.jgroups.View;
import org.jgroups.blocks.Request;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.protocols.relay.SiteAddress;

public class UnicastRequest<T>
extends Request<T> {
    protected final Address target;

    public UnicastRequest(RequestCorrelator corr, Address target, RequestOptions options) {
        super(corr, options);
        this.target = target;
    }

    @Override
    public void sendRequest(Message msg) throws Exception {
        try {
            this.corr.sendUnicastRequest(msg, this.options.mode() == ResponseMode.GET_NONE ? null : this, this.options);
        }
        catch (Exception ex) {
            this.corrDone();
            throw ex;
        }
    }

    @Override
    public void receiveResponse(Object response_value, Address sender, boolean is_exception) {
        if (this.isDone()) {
            return;
        }
        if (is_exception && response_value instanceof Throwable) {
            this.completeExceptionally((Throwable)response_value);
        } else {
            this.complete(response_value);
        }
        this.corrDone();
    }

    @Override
    public void siteUnreachable(String site) {
        if (!(this.target instanceof SiteAddress) || !((SiteAddress)this.target).getSite().equals(site) || this.isDone()) {
            return;
        }
        this.completeExceptionally(new UnreachableException(this.target));
        this.corrDone();
    }

    @Override
    public void viewChange(View view, boolean handle_previous_subgroups) {
        if (view == null) {
            return;
        }
        if (view instanceof MergeView && handle_previous_subgroups) {
            for (View v : ((MergeView)view).getSubgroups()) {
                if (!v.containsMember(this.target) || v.containsMember(this.corr.local_addr)) continue;
                this.completeExceptionally(new SuspectedException(this.target));
                this.corrDone();
                return;
            }
        }
        if (!(this.target instanceof SiteAddress || view.containsMember(this.target) || this.isDone())) {
            this.completeExceptionally(new SuspectedException(this.target));
            this.corrDone();
        }
    }

    @Override
    public void transportClosed() {
        if (this.isDone()) {
            return;
        }
        this.completeExceptionally(new IllegalStateException("transport was closed"));
        this.corrDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            Object t = super.get();
            return t;
        }
        finally {
            this.corrDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            Object t = super.get(timeout, unit);
            return t;
        }
        finally {
            this.corrDone();
        }
    }

    @Override
    public T join() {
        return (T)this.around(() -> super.join());
    }

    @Override
    public T getNow(T valueIfAbsent) {
        return (T)this.around(() -> super.getNow(valueIfAbsent));
    }

    @Override
    public T waitForCompletion(long timeout, TimeUnit unit) throws Exception {
        return (T)this.getResult(() -> this.get(timeout, unit));
    }

    @Override
    public T waitForCompletion() throws Exception {
        return (T)this.getResult(this::get);
    }

    @Override
    public String toString() {
        return String.format("%s, target=%s", super.toString(), this.target);
    }

    public boolean responsesComplete() {
        return this.options.mode() == ResponseMode.GET_NONE || this.isDone();
    }

    protected T around(Supplier<T> supplier) {
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.corrDone();
        }
    }

    protected T getResult(Callable<T> supplier) throws Exception {
        try {
            T t = supplier.call();
            return t;
        }
        catch (ExecutionException ex) {
            Throwable exception = ex.getCause();
            if (exception instanceof Error) {
                throw (Error)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof Exception) {
                throw (Exception)exception;
            }
            throw new RuntimeException(exception);
        }
        finally {
            this.corrDone();
        }
    }
}

