/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.protocols.api.AbstractResponse;
import org.apache.james.protocols.api.Response;

public class POP3Response
extends AbstractResponse {
    public static final String OK_RESPONSE = "+OK";
    public static final String ERR_RESPONSE = "-ERR";
    public static final String WS = " ";
    public static final Response OK = new POP3Response("+OK").immutable();
    public static final Response ERR = new POP3Response("-ERR").immutable();

    public POP3Response(String code, CharSequence description) {
        super(code, description);
    }

    public POP3Response(String code) {
        this.setRetCode(code);
    }

    protected POP3Response() {
    }

    public List<CharSequence> getLines() {
        ArrayList<CharSequence> responseList = new ArrayList<CharSequence>();
        if (this.lines.isEmpty()) {
            responseList.add(this.getRetCode());
        } else {
            for (int i = 0; i < this.lines.size(); ++i) {
                if (i == 0) {
                    responseList.add(this.getRetCode() + WS + this.lines.get(i));
                    continue;
                }
                responseList.add((CharSequence)this.lines.get(i));
            }
        }
        return responseList;
    }
}

