/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri.schema.serverLocator;

import java.io.NotSerializableException;
import java.net.URI;
import java.util.Map;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.uri.schema.serverLocator.AbstractServerLocatorSchema;
import org.apache.activemq.artemis.uri.schema.serverLocator.ConnectionOptions;
import org.apache.activemq.artemis.utils.uri.BeanSupport;

public class JGroupsServerLocatorSchema
extends AbstractServerLocatorSchema {
    public String getSchemaName() {
        return "jgroups";
    }

    protected ServerLocator internalNewObject(URI uri, Map<String, String> query, String name) throws Exception {
        DiscoveryGroupConfiguration dcConfig = JGroupsServerLocatorSchema.getDiscoveryGroupConfiguration(uri, query, name);
        BeanSupport.stripPasswords(query);
        ConnectionOptions options = this.newConnectionOptions(uri, query);
        if (options.isHa()) {
            return ActiveMQClient.createServerLocatorWithHA(dcConfig);
        }
        return ActiveMQClient.createServerLocatorWithoutHA(dcConfig);
    }

    protected URI internalNewURI(ServerLocator bean) throws Exception {
        DiscoveryGroupConfiguration dgc = bean.getDiscoveryGroupConfiguration();
        BroadcastEndpointFactory endpoint = dgc.getBroadcastEndpointFactory();
        if (!(endpoint instanceof JGroupsFileBroadcastEndpointFactory)) {
            throw new NotSerializableException(endpoint + "not serializable");
        }
        String auth = ((JGroupsFileBroadcastEndpointFactory)endpoint).getChannelName();
        String query = BeanSupport.getData(null, (Object[])new Object[]{bean, dgc, endpoint});
        dgc.setBroadcastEndpointFactory(endpoint);
        return new URI("jgroups", null, auth, -1, null, query, null);
    }

    public static DiscoveryGroupConfiguration getDiscoveryGroupConfiguration(URI uri, Map<String, String> query, String name) throws Exception {
        JGroupsFileBroadcastEndpointFactory endpointFactory = new JGroupsFileBroadcastEndpointFactory().setChannelName(uri.getAuthority());
        BeanSupport.setData((URI)uri, (Object)endpointFactory, query);
        DiscoveryGroupConfiguration dcConfig = new DiscoveryGroupConfiguration().setName(name).setBroadcastEndpointFactory(endpointFactory);
        BeanSupport.setData((URI)uri, (Object)dcConfig, query);
        return dcConfig;
    }
}

