/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.utils.XidCodecSupport;

public class SessionXAEndMessage
extends PacketImpl {
    private Xid xid;
    private boolean failed;

    public SessionXAEndMessage(Xid xid, boolean failed) {
        super((byte)52);
        this.xid = xid;
        this.failed = failed;
    }

    public SessionXAEndMessage() {
        super((byte)52);
    }

    public boolean isFailed() {
        return this.failed;
    }

    public Xid getXid() {
        return this.xid;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        XidCodecSupport.encodeXid(this.xid, buffer);
        buffer.writeBoolean(this.failed);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.xid = XidCodecSupport.decodeXid(buffer);
        this.failed = buffer.readBoolean();
    }

    @Override
    public String getPacketString() {
        return super.getPacketString() + ", xid=" + this.xid + ", failed=" + this.failed + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.failed ? 1231 : 1237);
        result = 31 * result + (this.xid == null ? 0 : this.xid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionXAEndMessage)) {
            return false;
        }
        SessionXAEndMessage other = (SessionXAEndMessage)obj;
        if (this.failed != other.failed) {
            return false;
        }
        return !(this.xid == null ? other.xid != null : !this.xid.equals(other.xid));
    }
}

