/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.comparators;

import java.math.BigInteger;
import org.apache.jsieve.comparators.Comparator;
import org.apache.jsieve.exception.FeatureException;

public class AsciiNumeric
implements Comparator {
    @Override
    public boolean equals(String string1, String string2) {
        boolean result;
        if (this.isPositiveInfinity(string1)) {
            result = this.isPositiveInfinity(string2);
        } else if (this.isPositiveInfinity(string2)) {
            result = false;
        } else {
            BigInteger integer1 = this.toInteger(string1);
            BigInteger integer2 = this.toInteger(string2);
            result = integer1.equals(integer2);
        }
        return result;
    }

    private BigInteger toInteger(String value) {
        char next;
        int i;
        for (i = 0; i < value.length() && this.isDigit(next = value.charAt(i)); ++i) {
        }
        return new BigInteger(value.substring(0, i));
    }

    private boolean isPositiveInfinity(String value) {
        char initialCharacter = value.charAt(0);
        return !this.isDigit(initialCharacter);
    }

    private boolean isDigit(char character) {
        return character >= '0' && character <= '9';
    }

    protected String computeCompareString(String string) {
        char[] chars = string.toCharArray();
        for (int i = chars.length; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) continue;
            chars[i] = 255;
        }
        return new String(chars);
    }

    @Override
    public boolean contains(String container, String content) throws FeatureException {
        throw new FeatureException("Substring match unsupported by ascii-numeric");
    }

    @Override
    public boolean matches(String string, String glob) throws FeatureException {
        throw new FeatureException("Substring match unsupported by ascii-numeric");
    }
}

