/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.table.CassandraMailboxRecentsTable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMailboxRecentsDAO {
    private static final int BATCH_STATEMENT_WINDOW = 1024;
    private static final int LOW_CONCURRENCY = 2;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement readStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement deleteAllStatement;
    private final PreparedStatement addStatement;
    private final ProtocolVersion protocolVersion;

    @Inject
    public CassandraMailboxRecentsDAO(CqlSession session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.readStatement = this.createReadStatement(session);
        this.deleteStatement = this.createDeleteStatement(session);
        this.deleteAllStatement = this.createDeleteAllStatement(session);
        this.addStatement = this.createAddStatement(session);
        this.protocolVersion = session.getContext().getProtocolVersion();
    }

    private PreparedStatement createReadStatement(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"mailboxRecents").column(CassandraMailboxRecentsTable.RECENT_MESSAGE_UID).where((Relation)Relation.column((CqlIdentifier)CassandraMailboxRecentsTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxRecentsTable.MAILBOX_ID)))).build());
    }

    private PreparedStatement createDeleteStatement(CqlSession session) {
        return session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"mailboxRecents").whereColumn(CassandraMailboxRecentsTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxRecentsTable.MAILBOX_ID))).whereColumn(CassandraMailboxRecentsTable.RECENT_MESSAGE_UID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxRecentsTable.RECENT_MESSAGE_UID))).build());
    }

    private PreparedStatement createDeleteAllStatement(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"mailboxRecents").where((Relation)Relation.column((CqlIdentifier)CassandraMailboxRecentsTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxRecentsTable.MAILBOX_ID)))).build());
    }

    private PreparedStatement createAddStatement(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"mailboxRecents").value(CassandraMailboxRecentsTable.MAILBOX_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxRecentsTable.MAILBOX_ID)).value(CassandraMailboxRecentsTable.RECENT_MESSAGE_UID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxRecentsTable.RECENT_MESSAGE_UID)).build());
    }

    public Flux<MessageUid> getRecentMessageUidsInMailbox(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.bindWithMailbox(mailboxId, this.readStatement)).map(row -> TypeCodecs.BIGINT.decodePrimitive(row.getBytesUnsafe(0), this.protocolVersion)).map(MessageUid::of);
    }

    private BoundStatement bindWithMailbox(CassandraId mailboxId, PreparedStatement statement) {
        return (BoundStatement)statement.bind(new Object[0]).set(CassandraMailboxRecentsTable.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID);
    }

    public Mono<Void> removeFromRecent(CassandraId mailboxId, MessageUid messageUid) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.deleteStatement.bind(new Object[0]).setUuid(CassandraMailboxRecentsTable.MAILBOX_ID, mailboxId.asUuid())).setLong(CassandraMailboxRecentsTable.RECENT_MESSAGE_UID, messageUid.asLong()));
    }

    public Mono<Void> removeFromRecent(CassandraId mailboxId, List<MessageUid> uids) {
        if (uids.size() == 1) {
            return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.deleteStatement.bind(new Object[0]).setUuid(CassandraMailboxRecentsTable.MAILBOX_ID, mailboxId.asUuid())).setLong(CassandraMailboxRecentsTable.RECENT_MESSAGE_UID, uids.iterator().next().asLong()));
        }
        Stream<BatchStatement> batches = Lists.partition(uids, (int)1024).stream().map(uidBatch -> {
            BatchStatementBuilder batch = new BatchStatementBuilder(BatchType.UNLOGGED);
            uidBatch.forEach(uid -> batch.addStatement((BatchableStatement)((BoundStatement)this.deleteStatement.bind(new Object[0]).setUuid(CassandraMailboxRecentsTable.MAILBOX_ID, mailboxId.asUuid())).setLong(CassandraMailboxRecentsTable.RECENT_MESSAGE_UID, uid.asLong())));
            return batch.build();
        });
        return Flux.fromStream(batches).flatMap(arg_0 -> ((CassandraAsyncExecutor)this.cassandraAsyncExecutor).executeVoid(arg_0), 2).then();
    }

    public Mono<Void> delete(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteAllStatement.bind(new Object[0]).setUuid(CassandraMailboxRecentsTable.MAILBOX_ID, mailboxId.asUuid()));
    }

    public Mono<Void> addToRecent(CassandraId mailboxId, MessageUid messageUid) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.addStatement.bind(new Object[0]).setUuid(CassandraMailboxRecentsTable.MAILBOX_ID, mailboxId.asUuid())).setLong(CassandraMailboxRecentsTable.RECENT_MESSAGE_UID, messageUid.asLong()));
    }

    public Mono<Void> addToRecent(CassandraId mailboxId, List<MessageUid> uids) {
        if (uids.size() == 1) {
            return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.addStatement.bind(new Object[0]).setUuid(CassandraMailboxRecentsTable.MAILBOX_ID, mailboxId.asUuid())).setLong(CassandraMailboxRecentsTable.RECENT_MESSAGE_UID, uids.iterator().next().asLong()));
        }
        Stream<BatchStatement> batches = Lists.partition(uids, (int)1024).stream().map(uidBatch -> {
            BatchStatementBuilder batch = new BatchStatementBuilder(BatchType.UNLOGGED);
            uidBatch.forEach(uid -> batch.addStatement((BatchableStatement)((BoundStatement)this.addStatement.bind(new Object[0]).setUuid(CassandraMailboxRecentsTable.MAILBOX_ID, mailboxId.asUuid())).setLong(CassandraMailboxRecentsTable.RECENT_MESSAGE_UID, uid.asLong())));
            return batch.build();
        });
        return Flux.fromStream(batches).flatMap(arg_0 -> ((CassandraAsyncExecutor)this.cassandraAsyncExecutor).executeVoid(arg_0), 2).then();
    }
}

