/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Queue;

public class BoundedPriorityQueue<E>
extends AbstractQueue<E>
implements Serializable {
    private static final long serialVersionUID = 7159618773497127413L;
    private final int maxSize;
    private final Comparator<? super E> comparator;
    private final Queue<E> queue;

    public BoundedPriorityQueue(int maxSize) {
        this(maxSize, null);
    }

    public BoundedPriorityQueue(int maxSize, Comparator<? super E> comparator) {
        this.maxSize = maxSize;
        this.comparator = BoundedPriorityQueue.reverse(comparator);
        this.queue = new PriorityQueue<E>(10, this.comparator);
    }

    private static <E> Comparator<? super E> reverse(Comparator<? super E> comparator) {
        if (comparator == null) {
            return Collections.reverseOrder();
        }
        return Collections.reverseOrder(comparator);
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean offer(E e) {
        if (this.queue.size() >= this.maxSize) {
            E head = this.peek();
            if (this.comparator.compare(e, head) < 1) {
                return false;
            }
            this.poll();
        }
        return this.queue.offer(e);
    }

    @Override
    public E poll() {
        return this.queue.poll();
    }

    @Override
    public E peek() {
        return this.queue.peek();
    }

    @Override
    public Iterator<E> iterator() {
        return this.queue.iterator();
    }

    @Override
    public int size() {
        return this.queue.size();
    }
}

