/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.federation.entities;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatementClaimsSet;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatementClaimsVerifier;
import com.nimbusds.openid.connect.sdk.federation.utils.JWTUtils;
import net.jcip.annotations.Immutable;

@Immutable
public final class EntityStatement {
    public static final JOSEObjectType JOSE_OBJECT_TYPE = new JOSEObjectType("entity-statement+jwt");
    public static final ContentType CONTENT_TYPE = new ContentType("application", JOSE_OBJECT_TYPE.getType(), new ContentType.Parameter[0]);
    private final SignedJWT statementJWT;
    private final EntityStatementClaimsSet claimsSet;

    private EntityStatement(SignedJWT statementJWT, EntityStatementClaimsSet claimsSet) {
        if (statementJWT == null) {
            throw new IllegalArgumentException("The entity statement must not be null");
        }
        if (JWSObject.State.UNSIGNED.equals((Object)statementJWT.getState())) {
            throw new IllegalArgumentException("The statement is not signed");
        }
        this.statementJWT = statementJWT;
        if (claimsSet == null) {
            throw new IllegalArgumentException("The entity statement claims set must not be null");
        }
        this.claimsSet = claimsSet;
    }

    public EntityID getEntityID() {
        return this.getClaimsSet().getSubjectEntityID();
    }

    public SignedJWT getSignedStatement() {
        return this.statementJWT;
    }

    public EntityStatementClaimsSet getClaimsSet() {
        return this.claimsSet;
    }

    public Base64URL verifySignatureOfSelfStatement() throws BadJOSEException, JOSEException {
        if (!this.getClaimsSet().isSelfStatement()) {
            throw new BadJOSEException("Entity statement not self-issued");
        }
        return this.verifySignature(this.getClaimsSet().getJWKSet());
    }

    public Base64URL verifySignature(JWKSet jwkSet) throws BadJOSEException, JOSEException {
        return JWTUtils.verifySignature(this.statementJWT, JOSE_OBJECT_TYPE, new EntityStatementClaimsVerifier(null), jwkSet);
    }

    public static EntityStatement sign(EntityStatementClaimsSet claimsSet, JWK signingJWK) throws JOSEException {
        return EntityStatement.sign(claimsSet, signingJWK, JWTUtils.resolveSigningAlgorithm(signingJWK));
    }

    public static EntityStatement sign(EntityStatementClaimsSet claimsSet, JWK signingJWK, JWSAlgorithm jwsAlg) throws JOSEException {
        if (claimsSet.isSelfStatement() && !claimsSet.getJWKSet().containsJWK(signingJWK)) {
            throw new JOSEException("Signing JWK not found in JWK set of self-statement");
        }
        try {
            return new EntityStatement(JWTUtils.sign(signingJWK, jwsAlg, JOSE_OBJECT_TYPE, claimsSet.toJWTClaimsSet()), claimsSet);
        }
        catch (ParseException e) {
            throw new JOSEException(e.getMessage(), (Throwable)e);
        }
    }

    public static EntityStatement parse(SignedJWT signedStmt) throws ParseException {
        return new EntityStatement(signedStmt, new EntityStatementClaimsSet(JWTUtils.parseSignedJWTClaimsSet(signedStmt)));
    }

    public static EntityStatement parse(String signedStmtString) throws ParseException {
        try {
            return EntityStatement.parse(SignedJWT.parse((String)signedStmtString));
        }
        catch (java.text.ParseException e) {
            throw new ParseException("Invalid entity statement: " + e.getMessage(), e);
        }
    }
}

