/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.BatchCompactionPlan;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionEstimateUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionTaskInfo;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.FileInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TsFileSequenceReader;

public abstract class AbstractCompactionEstimator {
    private static int globalCompactionFileInfoCacheSize = 1000;
    private static int globalCompactionRoughFileInfoCacheSize = 100000;
    private static final double maxRatioToAllocateFileInfoCache = 0.1;
    private static boolean globalFileInfoCacheEnabled;
    private static Map<TsFileID, FileInfo> globalFileInfoCacheForFailedCompaction;
    private static Map<TsFileID, FileInfo.RoughFileInfo> globalRoughInfoCacheForCompaction;
    protected IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    protected Map<TsFileResource, FileInfo> fileInfoCache = new HashMap<TsFileResource, FileInfo>();
    protected Map<TsFileResource, FileInfo.RoughFileInfo> roughInfoMap = new HashMap<TsFileResource, FileInfo.RoughFileInfo>();
    protected Map<TsFileResource, DeviceTimeIndex> deviceTimeIndexCache = new HashMap<TsFileResource, DeviceTimeIndex>();
    protected TSFileConfig tsFileConfig = TSFileDescriptor.getInstance().getConfig();
    protected long fixedMemoryBudget = (long)((double)SystemInfo.getInstance().getMemorySizeForCompaction() / (double)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() * IoTDBDescriptor.getInstance().getConfig().getChunkMetadataSizeProportion()) + BatchCompactionPlan.maxCachedTimeChunksSize;

    public static long allocateMemoryCostForFileInfoCache(long compactionMemorySize) {
        long fixedMemoryCost = (long)globalCompactionFileInfoCacheSize * FileInfo.MEMORY_COST_OF_FILE_INFO_ENTRY_IN_CACHE + (long)globalCompactionRoughFileInfoCacheSize * FileInfo.MEMORY_COST_OF_ROUGH_FILE_INFO_ENTRY_IN_CACHE;
        boolean bl = globalFileInfoCacheEnabled = (double)compactionMemorySize * 0.1 > (double)fixedMemoryCost;
        if (globalFileInfoCacheEnabled) {
            globalRoughInfoCacheForCompaction = new LRUMap(globalCompactionFileInfoCacheSize);
            globalFileInfoCacheForFailedCompaction = new LRUMap(globalCompactionRoughFileInfoCacheSize);
        } else {
            globalRoughInfoCacheForCompaction = Collections.emptyMap();
            globalFileInfoCacheForFailedCompaction = Collections.emptyMap();
        }
        return globalFileInfoCacheEnabled ? fixedMemoryCost : 0L;
    }

    protected abstract long calculatingMetadataMemoryCost(CompactionTaskInfo var1);

    protected abstract long calculatingDataMemoryCost(CompactionTaskInfo var1) throws IOException;

    protected abstract TsFileSequenceReader getReader(String var1) throws IOException;

    protected boolean isAllSourceFileExist(List<TsFileResource> resources) {
        for (TsFileResource resource : resources) {
            if (resource.getStatus() != TsFileResourceStatus.DELETED) continue;
            return false;
        }
        return true;
    }

    protected CompactionTaskInfo calculatingCompactionTaskInfo(List<TsFileResource> resources) throws IOException {
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        for (TsFileResource resource : resources) {
            FileInfo fileInfo = this.getFileInfoFromCache(resource);
            fileInfoList.add(fileInfo);
        }
        return new CompactionTaskInfo(resources, fileInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInfo getFileInfoFromCache(TsFileResource resource) throws IOException {
        FileInfo fileInfo;
        if (this.fileInfoCache.containsKey(resource)) {
            return this.fileInfoCache.get(resource);
        }
        TsFileID tsFileID = resource.getTsFileID();
        Map<TsFileID, FileInfo> map = globalFileInfoCacheForFailedCompaction;
        synchronized (map) {
            fileInfo = globalFileInfoCacheForFailedCompaction.get(tsFileID);
            if (fileInfo != null) {
                this.fileInfoCache.put(resource, fileInfo);
                return fileInfo;
            }
        }
        try (TsFileSequenceReader reader = this.getReader(resource.getTsFilePath());){
            Map<TsFileID, FileInfo.RoughFileInfo> map2;
            fileInfo = CompactionEstimateUtils.calculateFileInfo(reader);
            this.fileInfoCache.put(resource, fileInfo);
            if (globalFileInfoCacheEnabled) {
                map2 = globalFileInfoCacheForFailedCompaction;
                synchronized (map2) {
                    globalFileInfoCacheForFailedCompaction.put(tsFileID, fileInfo);
                }
                map2 = globalRoughInfoCacheForCompaction;
                synchronized (map2) {
                    globalRoughInfoCacheForCompaction.put(tsFileID, fileInfo.getSimpleFileInfo());
                }
            }
            map2 = fileInfo;
            return map2;
        }
    }

    protected int calculatingMaxOverlapFileNumInSubCompactionTask(@Nullable CompactionScheduleContext context, List<TsFileResource> resources) throws IOException {
        HashSet<IDeviceID> devices = new HashSet<IDeviceID>();
        ArrayList<DeviceTimeIndex> resourceDevices = new ArrayList<DeviceTimeIndex>(resources.size());
        for (TsFileResource resource2 : resources) {
            DeviceTimeIndex deviceTimeIndex = this.getDeviceTimeIndexFromCache(context, resource2);
            devices.addAll(deviceTimeIndex.getDevices());
            resourceDevices.add(deviceTimeIndex);
        }
        int maxOverlapFileNumInSubCompactionTask = 1;
        for (IDeviceID device : devices) {
            List resourcesContainsCurrentDevice = resourceDevices.stream().filter(resource -> !resource.definitelyNotContains(device)).sorted(Comparator.comparingLong(resource -> resource.getStartTime(device).get())).collect(Collectors.toList());
            if (resourcesContainsCurrentDevice.size() < maxOverlapFileNumInSubCompactionTask) continue;
            long maxEndTimeOfCurrentDevice = Long.MIN_VALUE;
            int overlapFileNumOfCurrentDevice = 0;
            for (DeviceTimeIndex resource3 : resourcesContainsCurrentDevice) {
                long deviceStartTimeInCurrentFile = resource3.getStartTime(device).get();
                long deviceEndTimeInCurrentFile = resource3.getEndTime(device).get();
                if (deviceStartTimeInCurrentFile <= maxEndTimeOfCurrentDevice) {
                    maxEndTimeOfCurrentDevice = Math.max(maxEndTimeOfCurrentDevice, deviceEndTimeInCurrentFile);
                    maxOverlapFileNumInSubCompactionTask = Math.max(maxOverlapFileNumInSubCompactionTask, ++overlapFileNumOfCurrentDevice);
                    continue;
                }
                maxEndTimeOfCurrentDevice = deviceEndTimeInCurrentFile;
                overlapFileNumOfCurrentDevice = 1;
            }
            if (maxOverlapFileNumInSubCompactionTask != resources.size()) continue;
            return maxOverlapFileNumInSubCompactionTask;
        }
        return maxOverlapFileNumInSubCompactionTask;
    }

    private DeviceTimeIndex getDeviceTimeIndexFromCache(@Nullable CompactionScheduleContext context, TsFileResource resource) throws IOException {
        ITimeIndex timeIndex;
        if (this.deviceTimeIndexCache.containsKey(resource)) {
            return this.deviceTimeIndexCache.get(resource);
        }
        if (context != null && (timeIndex = context.getResourceDeviceInfo(resource)) != null) {
            this.deviceTimeIndexCache.put(resource, (DeviceTimeIndex)timeIndex);
            return timeIndex;
        }
        timeIndex = resource.getTimeIndex();
        if (timeIndex instanceof FileTimeIndex) {
            timeIndex = CompactionUtils.buildDeviceTimeIndex(resource);
        }
        this.deviceTimeIndexCache.put(resource, (DeviceTimeIndex)timeIndex);
        return (DeviceTimeIndex)timeIndex;
    }

    public void cleanup() {
        this.deviceTimeIndexCache.clear();
        this.fileInfoCache.clear();
    }

    public boolean hasCachedRoughFileInfo(TsFileResource resource) {
        return this.getRoughFileInfo(resource) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo.RoughFileInfo getRoughFileInfo(TsFileResource resource) {
        FileInfo.RoughFileInfo roughFileInfo = this.roughInfoMap.get(resource);
        if (roughFileInfo != null) {
            return roughFileInfo;
        }
        Map<TsFileID, FileInfo.RoughFileInfo> map = globalRoughInfoCacheForCompaction;
        synchronized (map) {
            roughFileInfo = globalRoughInfoCacheForCompaction.get(resource.getTsFileID());
        }
        if (roughFileInfo != null) {
            this.roughInfoMap.put(resource, roughFileInfo);
        }
        return roughFileInfo;
    }

    public boolean supportsRoughEstimation() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFileInfoFromGlobalFileInfoCache(TsFileResource resource) {
        if (resource == null || resource.getTsFile() == null) {
            return;
        }
        if (globalFileInfoCacheEnabled) {
            Map<TsFileID, Object> map = globalFileInfoCacheForFailedCompaction;
            synchronized (map) {
                globalFileInfoCacheForFailedCompaction.remove(resource.getTsFileID());
            }
            map = globalRoughInfoCacheForCompaction;
            synchronized (map) {
                globalRoughInfoCacheForCompaction.remove(resource.getTsFileID());
            }
        }
    }

    public static void enableFileInfoCacheForTest(int globalCompactionFileInfoCacheSize, int globalCompactionRoughFileInfoCacheSize) {
        globalFileInfoCacheEnabled = true;
        globalRoughInfoCacheForCompaction = new LRUMap(globalCompactionFileInfoCacheSize);
        globalFileInfoCacheForFailedCompaction = new LRUMap(globalCompactionRoughFileInfoCacheSize);
    }

    public static void disableFileInfoCacheForTest() {
        globalFileInfoCacheEnabled = false;
        globalRoughInfoCacheForCompaction = Collections.emptyMap();
        globalFileInfoCacheForFailedCompaction = Collections.emptyMap();
    }

    public static boolean isGlobalFileInfoCacheEnabled() {
        return globalFileInfoCacheEnabled;
    }
}

