/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion.realtime.epoch;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.db.pipe.metric.source.PipeDataRegionSourceMetrics;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.epoch.TsFileEpochStateMigrator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class TsFileEpoch {
    private final TsFileResource resource;
    private final ConcurrentMap<PipeRealtimeDataRegionSource, AtomicReference<State>> dataRegionExtractor2State;
    private final AtomicLong insertNodeMinTime;

    public TsFileEpoch(TsFileResource resource) {
        this.resource = resource;
        this.dataRegionExtractor2State = new ConcurrentHashMap<PipeRealtimeDataRegionSource, AtomicReference<State>>();
        this.insertNodeMinTime = new AtomicLong(Long.MAX_VALUE);
    }

    public State getState(PipeRealtimeDataRegionSource extractor) {
        AtomicReference<State> stateRef = (AtomicReference<State>)this.dataRegionExtractor2State.get(extractor);
        if (stateRef == null) {
            stateRef = new AtomicReference<State>(State.EMPTY);
            this.dataRegionExtractor2State.putIfAbsent(extractor, stateRef);
            extractor.increaseExtractEpochSize();
            this.setExtractorsRecentProcessedTsFileEpochState();
        }
        return (State)((Object)stateRef.get());
    }

    public void migrateState(PipeRealtimeDataRegionSource extractor, TsFileEpochStateMigrator visitor) {
        AtomicReference<State> stateRef = (AtomicReference<State>)this.dataRegionExtractor2State.get(extractor);
        if (stateRef == null) {
            stateRef = new AtomicReference<State>(State.EMPTY);
            this.dataRegionExtractor2State.putIfAbsent(extractor, stateRef);
            extractor.increaseExtractEpochSize();
            this.setExtractorsRecentProcessedTsFileEpochState();
        }
        State migratedState = visitor.migrate((State)((Object)stateRef.get()));
        if (!Objects.equals(stateRef.get(), (Object)migratedState)) {
            stateRef.set(migratedState);
            this.setExtractorsRecentProcessedTsFileEpochState();
        }
    }

    public void clearState(PipeRealtimeDataRegionSource extractor) {
        if (this.dataRegionExtractor2State.containsKey(extractor)) {
            extractor.decreaseExtractEpochSize();
        }
        if (extractor.extractEpochSizeIsEmpty()) {
            PipeDataRegionSourceMetrics.getInstance().setRecentProcessedTsFileEpochState(extractor.getTaskID(), State.EMPTY);
        }
    }

    public void setExtractorsRecentProcessedTsFileEpochState() {
        this.dataRegionExtractor2State.forEach((extractor, state) -> PipeDataRegionSourceMetrics.getInstance().setRecentProcessedTsFileEpochState(extractor.getTaskID(), (State)((Object)((Object)state.get()))));
    }

    public void updateInsertNodeMinTime(long newComingMinTime) {
        this.insertNodeMinTime.updateAndGet(recordedMinTime -> Math.min(recordedMinTime, newComingMinTime));
    }

    public TsFileResource getResource() {
        return this.resource;
    }

    public String getFilePath() {
        return this.resource.getTsFilePath();
    }

    public String toString() {
        return "TsFileEpoch{resource='" + this.resource + '\'' + ", dataRegionExtractor2State=" + this.dataRegionExtractor2State + '\'' + ", insertNodeMinTime=" + this.insertNodeMinTime.get() + '}';
    }

    public static enum State {
        EMPTY(0),
        USING_TABLET(1),
        USING_BOTH(2),
        USING_TSFILE(3);

        private final int id;

        private State(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

