/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.sink.payload.pipeconsensus.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.pipe.sink.payload.pipeconsensus.request.PipeConsensusRequestType;
import org.apache.iotdb.commons.pipe.sink.payload.pipeconsensus.request.PipeConsensusRequestVersion;
import org.apache.iotdb.consensus.pipe.thrift.TCommitId;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class PipeConsensusTransferFilePieceReq
extends TPipeConsensusTransferReq {
    private transient String fileName;
    private transient long startWritingOffset;
    private transient byte[] filePiece;

    public final String getFileName() {
        return this.fileName;
    }

    public final long getStartWritingOffset() {
        return this.startWritingOffset;
    }

    public final byte[] getFilePiece() {
        return this.filePiece;
    }

    protected abstract PipeConsensusRequestType getPlanType();

    protected final PipeConsensusTransferFilePieceReq convertToTPipeConsensusTransferReq(String snapshotName, long startWritingOffset, byte[] snapshotPiece, TCommitId commitId, TConsensusGroupId consensusGroupId, int thisDataNodeId) throws IOException {
        this.fileName = snapshotName;
        this.startWritingOffset = startWritingOffset;
        this.filePiece = snapshotPiece;
        this.commitId = commitId;
        this.consensusGroupId = consensusGroupId;
        this.dataNodeId = thisDataNodeId;
        this.version = PipeConsensusRequestVersion.VERSION_1.getVersion();
        this.type = this.getPlanType().getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((String)snapshotName, (OutputStream)outputStream);
            ReadWriteIOUtils.write((long)startWritingOffset, (OutputStream)outputStream);
            ReadWriteIOUtils.write((Binary)new Binary(snapshotPiece), (OutputStream)outputStream);
            this.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return this;
    }

    protected final PipeConsensusTransferFilePieceReq translateFromTPipeConsensusTransferReq(TPipeConsensusTransferReq transferReq) {
        this.fileName = ReadWriteIOUtils.readString((ByteBuffer)transferReq.body);
        this.startWritingOffset = ReadWriteIOUtils.readLong((ByteBuffer)transferReq.body);
        this.filePiece = ReadWriteIOUtils.readBinary((ByteBuffer)transferReq.body).getValues();
        this.version = transferReq.version;
        this.type = transferReq.type;
        this.body = transferReq.body;
        this.commitId = transferReq.commitId;
        this.dataNodeId = transferReq.dataNodeId;
        this.consensusGroupId = transferReq.consensusGroupId;
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeConsensusTransferFilePieceReq that = (PipeConsensusTransferFilePieceReq)((Object)obj);
        return this.fileName.equals(that.fileName) && this.startWritingOffset == that.startWritingOffset && Arrays.equals(this.filePiece, that.filePiece) && this.version == that.version && this.type == that.type && this.body.equals(that.body) && Objects.equals(this.commitId, that.commitId) && Objects.equals(this.consensusGroupId, that.consensusGroupId) && Objects.equals(this.dataNodeId, that.dataNodeId);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.startWritingOffset, Arrays.hashCode(this.filePiece), this.version, this.type, this.body, this.commitId, this.consensusGroupId, this.dataNodeId);
    }
}

