## 3. 创建任务清单

### 上下文与触发条件 (Context & Trigger)

此流程在用户已批准功能设计文档后启动。必须确保相关的需求文档 (`requirements.md`) 和设计文档 (`design.md`) 已经存在并获得认可。

### 核心目标 (Core Objective)

基于已批准的需求和设计，创建一个结构化的、可操作的实现计划。这份计划将以编码任务检查清单的形式，保存在 `.workflow/{feature_name}/tasks.md` 文件中，并作为后续代码生成 AI 代理的直接输入。

### 核心工作流程 (Core Workflow)

必须严格遵循以下步骤顺序执行：

1.  **前置检查与回退逻辑**:

    - 核实设计文档的存在性。
    - 在与用户互动时，如果用户表示设计需要修改，**必须中止当前任务并返回设计步骤**。
    - 如果用户表示需求需要补充，**必须中止当前任务并建议返回需求步骤，再进行设计步骤**。

2.  **研究优先原则 (Research First)**:

    - 在制定任何任务之前，必须先明确一个研究任务：在代码库中搜索已有的、可复用的实现（如通用的错误处理、工具函数、UI 组件等），以**避免不必要地重复工作**。这个研究步骤本身应作为任务清单的第一项。

3.  **创建任务清单 (`tasks.md`)**:

    - 如果 `.workflow/{feature_name}/tasks.md` 文件不存在，则创建它。
    - 依据下文的 **“文档规格”** 和 **“任务定义原则”**，将功能实现分解为一系列离散、渐进的编码任务。
    - 确保计划覆盖了设计文档中所有需要通过代码实现的方面，并且所有相关需求都已被任务覆盖。

4.  **互动与完成模型 (Interaction & Completion Model)**:
    - 生成任务清单后，**必须暂停并询问用户**：“**这些任务看起来可以吗？**”
    - 持续执行**反馈-修订循环**，直到获得用户明确的批准（如“是”、“批准”、“看起来可以”等）。
    - 获得批准后，**必须明确告知用户此规划工作流已完成**，并立即停止操作。

### `tasks.md` 文档规格与内容要求

产出的任务清单必须严格遵循以下格式，使用内联元数据标签来丰富任务描述。

- **文件结构**: 一份 Markdown 文件，包含一个最多两级层级的编号复选框列表。
- **格式**:
  - 所有任务项都是一个未选中的复选框 `[ ]`。
  - 顶层任务使用整数编号（`1.`, `2.`）。
  - 子任务使用小数编号（`1.1.`, `1.2.`）。
  - 每个任务项需包含：
    - **清晰的动作描述**: 明确说明要编写、修改或测试的代码。
    - **元数据标签 (可选)**: 在任务描述后，使用 `[标签: 值]` 的形式附上关键元数据。
      - `[优先级: 高/中/低]`
      - `(依赖于: 任务ID)`
      - `(关联需求: 需求ID)`

#### 示例格式应用:

```markdown
# 实现计划: 用户登录时的“记住我”功能

- [ ] 1. **研究与准备**

  - [ ] 1.1. 在现有代码库中查找用于管理用户会话或持久化 Token 的工具函数。 `(关联需求: S1)`
  - [ ] 1.2. 确认项目中统一的加密/解密工具，用于安全地存储 Token。 `(关联需求: S1)` `(依赖于: 1.1)`

- [ ] 2. **后端实现** `[优先级: 高]`

  - [ ] 2.1. **TDD**: 编写单元测试，验证`rememberMe`为 true 时，登录 API 会生成持久化 Token。 `(关联需求: E1)` `(依赖于: 1.2)`
  - [ ] 2.2. 更新登录 API (`/api/auth/login`)，实现 Token 生成与存储逻辑。 `(关联需求: E1)` `(依赖于: 2.1)`
  - [ ] 2.3. **TDD**: 编写集成测试，验证 Token 验证中间件的完整逻辑。 `(关联需求: R1)` `(依赖于: 2.2)`
  - [ ] 2.4. 实现 Token 验证中间件，处理持久化 Token 的验证和会话刷新。 `(关联需求: R1)` `(依赖于: 2.3)`

- [ ] 3. **前端实现** `[优先级: 中]`

  - [ ] 3.1. 在`LoginForm.vue`组件中增加“记住我”复选框，并将其状态绑定到登录请求。 `(关联需求: U1)` `(依赖于: 2.2)`

- [ ] 4. **端到端验证** `[优先级: 低]`
  - [ ] 4.1. 编写 E2E 测试，模拟用户从登录到关闭浏览器再到自动重连的全过程。 `(关联需求: E1, R1)` `(依赖于: 2.4, 3.1)`
```

#### 任务定义的核心原则

- **TDD 优先**: 优先安排编写测试用例的任务（如果项目遵循 TDD），然后再编写实现代码。
- **原子性与渐进性**: 每个任务都应是小而可管理的编码步骤。后一步建立在前一步的基础上，并通过`依赖于`字段明确表示。
- **可操作性**: 任务描述必须具体到可直接执行的程度（例如，“实现函数 X”、“修改组件 Y”、“创建测试 Z”），而非高层概念。
- **依赖明确**: 必须清晰地通过 `(依赖于: 任务ID)` 标签标记出当前任务的前置任务 ID。这是确保任务按正确顺序执行的关键。

#### 严格禁止项

此流程只负责规划，不负责执行。在任务清单中，严禁包含以下任何非编码或超出开发环境范围的活动：

- **任何实际执行代码的尝试。**

- 用户验收测试（UAT）、用户访谈、或任何形式的手动测试。

- 部署到任何环境（生产、预发布等）。

- 性能指标收集、日志分析。

- 用户培训文档、市场营销活动。
