/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.mqtt;

import com.hivemq.client.mqtt.MqttVersion;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt3.Mqtt3AsyncClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3Client;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientBuilder;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3PublishBuilder;
import com.hivemq.client.mqtt.mqtt3.message.unsubscribe.Mqtt3UnsubscribeBuilder;
import com.hivemq.client.mqtt.mqtt5.Mqtt5AsyncClient;
import com.hivemq.client.mqtt.mqtt5.Mqtt5Client;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientBuilder;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishBuilder;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.Mqtt5UnsubscribeBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.MqttProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StopWatch;

public class MqttCollectImpl
extends AbstractCollect {
    private static final Logger logger = LoggerFactory.getLogger(MqttCollectImpl.class);

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        MqttProtocol mqttProtocol = metrics.getMqtt();
        Assert.hasText((String)mqttProtocol.getHost(), (String)"MQTT protocol host is required");
        Assert.hasText((String)mqttProtocol.getPort(), (String)"MQTT protocol port is required");
        Assert.hasText((String)mqttProtocol.getProtocolVersion(), (String)"MQTT protocol version is required");
    }

    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        MqttProtocol mqtt = metrics.getMqtt();
        String protocolVersion = mqtt.getProtocolVersion();
        MqttVersion mqttVersion = MqttVersion.valueOf((String)protocolVersion);
        if (mqttVersion == MqttVersion.MQTT_3_1_1) {
            this.collectWithVersion3(metrics, builder);
        } else if (mqttVersion == MqttVersion.MQTT_5_0) {
            this.collectWithVersion5(metrics, builder);
        }
    }

    public String supportProtocol() {
        return "mqtt";
    }

    private void collectWithVersion5(Metrics metrics, CollectRep.MetricsData.Builder builder) {
        MqttProtocol mqttProtocol = metrics.getMqtt();
        HashMap<Object, String> data = new HashMap<Object, String>();
        Mqtt5AsyncClient client = this.buildMqtt5Client(mqttProtocol);
        long responseTime = this.connectClient(client, mqtt5AsyncClient -> {
            CompletableFuture connectFuture = mqtt5AsyncClient.connect();
            try {
                connectFuture.get(Long.parseLong(mqttProtocol.getTimeout()), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg(this.getErrorMessage(e.getMessage()));
            }
        });
        this.testDescribeAndPublish5(client, mqttProtocol, data);
        this.convertToMetricsData(builder, metrics, responseTime, data);
        client.disconnect();
    }

    private void collectWithVersion3(Metrics metrics, CollectRep.MetricsData.Builder builder) {
        MqttProtocol mqttProtocol = metrics.getMqtt();
        HashMap<Object, String> data = new HashMap<Object, String>();
        Mqtt3AsyncClient client = this.buildMqtt3Client(mqttProtocol);
        long responseTime = this.connectClient(client, mqtt3AsyncClient -> {
            CompletableFuture connectFuture = mqtt3AsyncClient.connect();
            try {
                connectFuture.get(Long.parseLong(mqttProtocol.getTimeout()), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg(this.getErrorMessage(e.getMessage()));
            }
        });
        this.testDescribeAndPublish3(client, mqttProtocol, data);
        this.convertToMetricsData(builder, metrics, responseTime, data);
        client.disconnect();
    }

    private void testDescribeAndPublish3(Mqtt3AsyncClient client, MqttProtocol mqttProtocol, Map<Object, String> data) {
        data.put("canDescribe", this.test(() -> {
            ((Mqtt3AsyncClient.Mqtt3SubscribeAndCallbackBuilder.Start.Complete)((Mqtt3AsyncClient.Mqtt3SubscribeAndCallbackBuilder.Start.Complete)client.subscribeWith().topicFilter(mqttProtocol.getTopic())).qos(MqttQos.AT_LEAST_ONCE)).send();
            ((Mqtt3UnsubscribeBuilder.Send.Complete)client.unsubscribeWith().topicFilter(mqttProtocol.getTopic())).send();
        }, "subscribe").toString());
        data.put("canPublish", !mqttProtocol.testPublish() ? Boolean.FALSE.toString() : this.test(() -> {
            ((Mqtt3PublishBuilder.Send.Complete)((Mqtt3PublishBuilder.Send.Complete)((Mqtt3PublishBuilder.Send.Complete)client.publishWith().topic(mqttProtocol.getTopic())).payload(mqttProtocol.getTestMessage().getBytes(StandardCharsets.UTF_8))).qos(MqttQos.AT_LEAST_ONCE)).send();
            data.put("canPublish", Boolean.TRUE.toString());
        }, "publish").toString());
    }

    private void testDescribeAndPublish5(Mqtt5AsyncClient client, MqttProtocol mqttProtocol, Map<Object, String> data) {
        data.put("canDescribe", this.test(() -> {
            ((Mqtt5AsyncClient.Mqtt5SubscribeAndCallbackBuilder.Start.Complete)((Mqtt5AsyncClient.Mqtt5SubscribeAndCallbackBuilder.Start.Complete)client.subscribeWith().topicFilter(mqttProtocol.getTopic())).qos(MqttQos.AT_LEAST_ONCE)).send();
            ((Mqtt5UnsubscribeBuilder.Send.Complete)client.unsubscribeWith().topicFilter(mqttProtocol.getTopic())).send();
        }, "subscribe").toString());
        data.put("canPublish", !mqttProtocol.testPublish() ? Boolean.FALSE.toString() : this.test(() -> {
            ((Mqtt5PublishBuilder.Send.Complete)((Mqtt5PublishBuilder.Send.Complete)((Mqtt5PublishBuilder.Send.Complete)client.publishWith().topic(mqttProtocol.getTopic())).payload(mqttProtocol.getTestMessage().getBytes(StandardCharsets.UTF_8))).qos(MqttQos.AT_LEAST_ONCE)).send();
            data.put("canPublish", Boolean.TRUE.toString());
        }, "publish").toString());
    }

    private Mqtt5AsyncClient buildMqtt5Client(MqttProtocol mqttProtocol) {
        Mqtt5ClientBuilder mqtt5ClientBuilder = (Mqtt5ClientBuilder)((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)Mqtt5Client.builder().serverHost(mqttProtocol.getHost())).identifier(mqttProtocol.getClientId())).serverPort(Integer.parseInt(mqttProtocol.getPort()));
        if (mqttProtocol.hasAuth()) {
            ((Mqtt5SimpleAuthBuilder.Nested.Complete)((Mqtt5SimpleAuthBuilder.Nested.Complete)mqtt5ClientBuilder.simpleAuth().username(mqttProtocol.getUsername())).password(mqttProtocol.getPassword().getBytes(StandardCharsets.UTF_8))).applySimpleAuth();
        }
        return mqtt5ClientBuilder.buildAsync();
    }

    private Mqtt3AsyncClient buildMqtt3Client(MqttProtocol mqttProtocol) {
        Mqtt3ClientBuilder mqtt3ClientBuilder = (Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)Mqtt3Client.builder().serverHost(mqttProtocol.getHost())).identifier(mqttProtocol.getClientId())).serverPort(Integer.parseInt(mqttProtocol.getPort()));
        if (mqttProtocol.hasAuth()) {
            ((Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3SimpleAuthBuilder.Nested.Complete)mqtt3ClientBuilder.simpleAuth().username(mqttProtocol.getUsername())).password(mqttProtocol.getPassword().getBytes(StandardCharsets.UTF_8))).applySimpleAuth();
        }
        return mqtt3ClientBuilder.buildAsync();
    }

    public <T> long connectClient(T client, Consumer<T> connect) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        connect.accept(client);
        stopWatch.stop();
        return stopWatch.getTotalTimeMillis();
    }

    private void convertToMetricsData(CollectRep.MetricsData.Builder builder, Metrics metrics, long responseTime, Map<Object, String> data) {
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        for (String column : metrics.getAliasFields()) {
            if ("responseTime".equals(column)) {
                valueRowBuilder.addColumn(String.valueOf(responseTime));
                continue;
            }
            String value = data.get(column);
            value = value == null ? "&nbsp;" : value;
            valueRowBuilder.addColumn(value);
        }
        builder.addValueRow(valueRowBuilder.build());
    }

    private Boolean test(Runnable runnable, String operationName) {
        try {
            runnable.run();
            return true;
        }
        catch (Exception e) {
            logger.error("{} fail", (Object)operationName, (Object)e);
            return false;
        }
    }

    private String getErrorMessage(String errorMessage) {
        if (StringUtils.isBlank((CharSequence)errorMessage)) {
            return "connect failed";
        }
        String[] split = errorMessage.split(":");
        if (split.length > 1) {
            return Arrays.stream(split).skip(1L).collect(Collectors.joining(":"));
        }
        return errorMessage;
    }
}

