/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.protocol;

import com.facebook.thrift.TByteArrayOutputStream;
import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TBase64Utils;
import com.facebook.thrift.protocol.TMessage;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TStruct;
import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.utils.StandardCharsets;
import java.util.Stack;

public abstract class TJSONProtocolBase
extends TProtocol {
    protected static final byte[] COMMA = new byte[]{44};
    protected static final byte[] COLON = new byte[]{58};
    protected static final byte[] LBRACE = new byte[]{123};
    protected static final byte[] RBRACE = new byte[]{125};
    protected static final byte[] LBRACKET = new byte[]{91};
    protected static final byte[] RBRACKET = new byte[]{93};
    protected static final byte[] QUOTE = new byte[]{34};
    protected static final byte[] BACKSLASH = new byte[]{92};
    protected static final byte[] ZERO = new byte[]{48};
    protected static final byte[] ESCSEQ = new byte[]{92, 117, 48, 48};
    protected static final long VERSION = 1L;
    protected static final byte[] JSON_CHAR_TABLE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 98, 116, 110, 0, 102, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 34, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    protected static final String ESCAPE_CHARS = "\"\\bfnrt";
    protected static final byte[] ESCAPE_CHAR_VALS = new byte[]{34, 92, 8, 12, 10, 13, 9};
    protected static final int DEF_STRING_SIZE = 16;
    protected static final byte[] NAME_BOOL = new byte[]{116, 102};
    protected static final byte[] NAME_BYTE = new byte[]{105, 56};
    protected static final byte[] NAME_I16 = new byte[]{105, 49, 54};
    protected static final byte[] NAME_I32 = new byte[]{105, 51, 50};
    protected static final byte[] NAME_I64 = new byte[]{105, 54, 52};
    protected static final byte[] NAME_DOUBLE = new byte[]{100, 98, 108};
    protected static final byte[] NAME_FLOAT = new byte[]{102, 108, 116};
    protected static final byte[] NAME_STRUCT = new byte[]{114, 101, 99};
    protected static final byte[] NAME_STRING = new byte[]{115, 116, 114};
    protected static final byte[] NAME_MAP = new byte[]{109, 97, 112};
    protected static final byte[] NAME_LIST = new byte[]{108, 115, 116};
    protected static final byte[] NAME_SET = new byte[]{115, 101, 116};
    protected static final byte[] VALUE_TRUE = new byte[]{116, 114, 117, 101};
    protected static final byte[] VALUE_FALSE = new byte[]{102, 97, 108, 115, 101};
    protected static final TStruct ANONYMOUS_STRUCT = new TStruct();
    protected Stack<JSONBaseContext> contextStack_ = new Stack();
    protected JSONBaseContext context_ = new JSONBaseContext();
    protected LookaheadReader reader_ = new LookaheadReader();
    protected byte[] tmpbuf_ = new byte[4];

    protected static final byte[] getTypeNameForTypeID(byte typeID) throws TException {
        switch (typeID) {
            case 2: {
                return NAME_BOOL;
            }
            case 3: {
                return NAME_BYTE;
            }
            case 6: {
                return NAME_I16;
            }
            case 8: {
                return NAME_I32;
            }
            case 10: {
                return NAME_I64;
            }
            case 4: {
                return NAME_DOUBLE;
            }
            case 19: {
                return NAME_FLOAT;
            }
            case 11: {
                return NAME_STRING;
            }
            case 12: {
                return NAME_STRUCT;
            }
            case 13: {
                return NAME_MAP;
            }
            case 14: {
                return NAME_SET;
            }
            case 15: {
                return NAME_LIST;
            }
        }
        throw new TProtocolException(5, "Unrecognized type");
    }

    protected static final byte getTypeIDForTypeName(byte[] name) throws TException {
        int result = 0;
        if (name.length > 1) {
            switch (name[0]) {
                case 100: {
                    result = 4;
                    break;
                }
                case 102: {
                    result = 19;
                    break;
                }
                case 105: {
                    switch (name[1]) {
                        case 56: {
                            result = 3;
                            break;
                        }
                        case 49: {
                            result = 6;
                            break;
                        }
                        case 51: {
                            result = 8;
                            break;
                        }
                        case 54: {
                            result = 10;
                        }
                    }
                    break;
                }
                case 108: {
                    result = 15;
                    break;
                }
                case 109: {
                    result = 13;
                    break;
                }
                case 114: {
                    result = 12;
                    break;
                }
                case 115: {
                    if (name[1] == 116) {
                        result = 11;
                        break;
                    }
                    if (name[1] != 101) break;
                    result = 14;
                    break;
                }
                case 116: {
                    result = 2;
                }
            }
        }
        if (result == 0) {
            throw new TProtocolException(5, "Unrecognized type");
        }
        return (byte)result;
    }

    protected static final byte getTypeIDForPeekedByte(byte peekedByte) throws TException {
        switch (peekedByte) {
            case 93: 
            case 125: {
                return 0;
            }
            case 123: {
                return 12;
            }
            case 91: {
                return 15;
            }
            case 102: 
            case 116: {
                return 2;
            }
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return 4;
            }
            case 34: {
                return 11;
            }
        }
        throw new TProtocolException(5, "Unrecognized peeked byte: " + (char)peekedByte);
    }

    protected void pushContext(JSONBaseContext c) {
        this.contextStack_.push(this.context_);
        this.context_ = c;
    }

    protected void popContext() {
        this.context_ = this.contextStack_.pop();
    }

    protected TJSONProtocolBase(TTransport trans) {
        super(trans);
    }

    @Override
    public void reset() {
        this.contextStack_.clear();
        this.context_ = new JSONBaseContext();
        this.reader_ = new LookaheadReader();
    }

    protected void readJSONSyntaxChar(byte[] b) throws TException {
        byte ch = this.reader_.read();
        if (ch != b[0]) {
            throw new TProtocolException(1, "Unexpected character:" + (char)ch);
        }
    }

    protected static final byte hexVal(byte ch) throws TException {
        if (ch >= 48 && ch <= 57) {
            return (byte)((char)ch - 48);
        }
        if (ch >= 97 && ch <= 102) {
            return (byte)((char)ch - 97 + 10);
        }
        throw new TProtocolException(1, "Expected hex character");
    }

    protected static final byte hexChar(byte val) {
        if ((val = (byte)(val & 0xF)) < 10) {
            return (byte)((char)val + 48);
        }
        return (byte)((char)(val - 10) + 97);
    }

    protected void writeJSONString(byte[] b) throws TException {
        this.context_.write();
        this.trans_.write(QUOTE);
        int len = b.length;
        for (int i = 0; i < len; ++i) {
            if ((b[i] & 0xFF) >= 48) {
                if (b[i] == BACKSLASH[0]) {
                    this.trans_.write(BACKSLASH);
                    this.trans_.write(BACKSLASH);
                    continue;
                }
                this.trans_.write(b, i, 1);
                continue;
            }
            this.tmpbuf_[0] = JSON_CHAR_TABLE[b[i]];
            if (this.tmpbuf_[0] == 1) {
                this.trans_.write(b, i, 1);
                continue;
            }
            if (this.tmpbuf_[0] > 1) {
                this.trans_.write(BACKSLASH);
                this.trans_.write(this.tmpbuf_, 0, 1);
                continue;
            }
            this.trans_.write(ESCSEQ);
            this.tmpbuf_[0] = TJSONProtocolBase.hexChar((byte)(b[i] >> 4));
            this.tmpbuf_[1] = TJSONProtocolBase.hexChar(b[i]);
            this.trans_.write(this.tmpbuf_, 0, 2);
        }
        this.trans_.write(QUOTE);
    }

    protected void writeJSONInteger(long num) throws TException {
        this.context_.write();
        String str = Long.toString(num);
        boolean escapeNum = this.context_.escapeNum();
        if (escapeNum) {
            this.trans_.write(QUOTE);
        }
        byte[] buf = str.getBytes(StandardCharsets.UTF_8);
        this.trans_.write(buf);
        if (escapeNum) {
            this.trans_.write(QUOTE);
        }
    }

    protected void writeJSONDouble(String str) throws TException {
        boolean escapeNum;
        this.context_.write();
        boolean special = false;
        switch (str.charAt(0)) {
            case 'I': 
            case 'N': {
                special = true;
                break;
            }
            case '-': {
                if (str.charAt(1) != 'I') break;
                special = true;
            }
        }
        boolean bl = escapeNum = special || this.context_.escapeNum();
        if (escapeNum) {
            this.trans_.write(QUOTE);
        }
        byte[] b = str.getBytes(StandardCharsets.UTF_8);
        this.trans_.write(b, 0, b.length);
        if (escapeNum) {
            this.trans_.write(QUOTE);
        }
    }

    protected void writeJSONBase64(byte[] b) throws TException {
        int len;
        this.context_.write();
        this.trans_.write(QUOTE);
        int off = 0;
        for (len = b.length; len >= 3; len -= 3) {
            TBase64Utils.encode(b, off, 3, this.tmpbuf_, 0);
            this.trans_.write(this.tmpbuf_, 0, 4);
            off += 3;
        }
        if (len > 0) {
            TBase64Utils.encode(b, off, len, this.tmpbuf_, 0);
            this.trans_.write(this.tmpbuf_, 0, len + 1);
        }
        this.trans_.write(QUOTE);
    }

    protected void writeJSONObjectStart() throws TException {
        this.context_.write();
        this.trans_.write(LBRACE);
        this.pushContext(new JSONPairContext());
    }

    protected void writeJSONObjectEnd() throws TException {
        this.popContext();
        this.trans_.write(RBRACE);
    }

    protected void writeJSONArrayStart() throws TException {
        this.context_.write();
        this.trans_.write(LBRACKET);
        this.pushContext(new JSONListContext());
    }

    protected void writeJSONArrayEnd() throws TException {
        this.popContext();
        this.trans_.write(RBRACKET);
    }

    @Override
    public void writeMessageBegin(TMessage message) throws TException {
        this.writeJSONArrayStart();
        this.writeJSONInteger(1L);
        byte[] b = message.name.getBytes(StandardCharsets.UTF_8);
        this.writeJSONString(b);
        this.writeJSONInteger(message.type);
        this.writeJSONInteger(message.seqid);
    }

    @Override
    public void writeMessageEnd() throws TException {
        this.writeJSONArrayEnd();
    }

    @Override
    public void writeBool(boolean b) throws TException {
        this.context_.write();
        this.trans_.write((b ? "true" : "false").getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void writeByte(byte b) throws TException {
        this.writeJSONInteger(b);
    }

    @Override
    public void writeI16(short i16) throws TException {
        this.writeJSONInteger(i16);
    }

    @Override
    public void writeI32(int i32) throws TException {
        this.writeJSONInteger(i32);
    }

    @Override
    public void writeI64(long i64) throws TException {
        this.writeJSONInteger(i64);
    }

    @Override
    public void writeDouble(double dub) throws TException {
        this.writeJSONDouble(Double.toString(dub));
    }

    @Override
    public void writeFloat(float flt) throws TException {
        this.writeJSONDouble(Float.toString(flt));
    }

    @Override
    public void writeString(String str) throws TException {
        byte[] b = str.getBytes(StandardCharsets.UTF_8);
        this.writeJSONString(b);
    }

    @Override
    public void writeBinary(byte[] bin) throws TException {
        this.writeJSONBase64(bin);
    }

    protected TByteArrayOutputStream readJSONString(boolean skipContext) throws TException {
        byte ch;
        TByteArrayOutputStream arr = new TByteArrayOutputStream(16);
        if (!skipContext) {
            this.context_.read();
        }
        this.readJSONSyntaxChar(QUOTE);
        while ((ch = this.reader_.read()) != QUOTE[0]) {
            if (ch == ESCSEQ[0]) {
                ch = this.reader_.read();
                if (ch == ESCSEQ[1]) {
                    this.readJSONSyntaxChar(ZERO);
                    this.readJSONSyntaxChar(ZERO);
                    this.trans_.readAll(this.tmpbuf_, 0, 2);
                    ch = (byte)((TJSONProtocolBase.hexVal(this.tmpbuf_[0]) << 4) + TJSONProtocolBase.hexVal(this.tmpbuf_[1]));
                } else {
                    int off = ESCAPE_CHARS.indexOf(ch);
                    if (off == -1) {
                        throw new TProtocolException(1, "Expected control char");
                    }
                    ch = ESCAPE_CHAR_VALS[off];
                }
            }
            arr.write(ch);
        }
        return arr;
    }

    protected boolean isJSONNumeric(byte b) {
        switch (b) {
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 69: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    protected String readJSONNumericChars() throws TException {
        byte ch;
        StringBuilder strbld = new StringBuilder();
        while (this.isJSONNumeric(ch = this.reader_.peek())) {
            strbld.append((char)this.reader_.read());
        }
        return strbld.toString();
    }

    protected long readJSONInteger() throws TException {
        this.context_.read();
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        String str = this.readJSONNumericChars();
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException ex) {
            throw new TProtocolException(1, "Bad data encounted in numeric data");
        }
    }

    protected double readJSONDouble() throws TException {
        this.context_.read();
        if (this.reader_.peek() == QUOTE[0]) {
            TByteArrayOutputStream arr = this.readJSONString(true);
            double dub = Double.valueOf(arr.toString(StandardCharsets.UTF_8));
            if (!(this.context_.escapeNum() || Double.isNaN(dub) || Double.isInfinite(dub))) {
                throw new TProtocolException(1, "Numeric data unexpectedly quoted");
            }
            return dub;
        }
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        try {
            return Double.valueOf(this.readJSONNumericChars());
        }
        catch (NumberFormatException ex) {
            throw new TProtocolException(1, "Bad data encounted in numeric data");
        }
    }

    protected float readJSONFloat() throws TException {
        this.context_.read();
        if (this.reader_.peek() == QUOTE[0]) {
            TByteArrayOutputStream arr = this.readJSONString(true);
            float flt = Float.valueOf(arr.toString(StandardCharsets.UTF_8)).floatValue();
            if (!(this.context_.escapeNum() || Float.isNaN(flt) || Float.isInfinite(flt))) {
                throw new TProtocolException(1, "Numeric data unexpectedly quoted");
            }
            return flt;
        }
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        try {
            return Float.valueOf(this.readJSONNumericChars()).floatValue();
        }
        catch (NumberFormatException ex) {
            throw new TProtocolException(1, "Bad data encounted in numeric data");
        }
    }

    protected byte[] readJSONBase64() throws TException {
        TByteArrayOutputStream arr = this.readJSONString(false);
        byte[] b = arr.get();
        int len = arr.len();
        int off = 0;
        int size = 0;
        while (len >= 4) {
            TBase64Utils.decode(b, off, 4, b, size);
            off += 4;
            len -= 4;
            size += 3;
        }
        if (len > 1) {
            TBase64Utils.decode(b, off, len, b, size);
            size += len - 1;
        }
        byte[] result = new byte[size];
        System.arraycopy(b, 0, result, 0, size);
        return result;
    }

    protected void readJSONObjectStart() throws TException {
        this.context_.read();
        this.readJSONSyntaxChar(LBRACE);
        this.pushContext(new JSONPairContext());
    }

    protected void readJSONObjectEnd() throws TException {
        this.readJSONSyntaxChar(RBRACE);
        this.popContext();
    }

    protected void readJSONArrayStart() throws TException {
        this.context_.read();
        this.readJSONSyntaxChar(LBRACKET);
        this.pushContext(new JSONListContext());
    }

    protected void readJSONArrayEnd() throws TException {
        this.readJSONSyntaxChar(RBRACKET);
        this.popContext();
    }

    @Override
    public TMessage readMessageBegin() throws TException {
        this.readJSONArrayStart();
        if (this.readJSONInteger() != 1L) {
            throw new TProtocolException(4, "Message contained bad version.");
        }
        String name = this.readJSONString(false).toString(StandardCharsets.UTF_8);
        byte type = (byte)this.readJSONInteger();
        int seqid = (int)this.readJSONInteger();
        return new TMessage(name, type, seqid);
    }

    @Override
    public void readMessageEnd() throws TException {
        this.readJSONArrayEnd();
    }

    @Override
    public boolean readBool() throws TException {
        long numericResult;
        boolean isQuoted;
        this.context_.read();
        boolean literalResult = false;
        byte[] literalValue = null;
        byte ch = this.reader_.peek();
        if (ch == VALUE_FALSE[0]) {
            literalResult = false;
            literalValue = VALUE_FALSE;
        } else if (ch == VALUE_TRUE[0]) {
            literalResult = true;
            literalValue = VALUE_TRUE;
        }
        boolean bl = isQuoted = this.context_.escapeNum() && literalValue == null;
        if (isQuoted) {
            this.readJSONSyntaxChar(QUOTE);
        }
        if (literalValue != null) {
            for (byte expected : literalValue) {
                if (this.reader_.read() == expected) continue;
                throw new TProtocolException(1, "Invalid boolean literal");
            }
            if (isQuoted) {
                this.readJSONSyntaxChar(QUOTE);
            }
            return literalResult;
        }
        String str = this.readJSONNumericChars();
        if (isQuoted) {
            this.readJSONSyntaxChar(QUOTE);
        }
        try {
            numericResult = Long.valueOf(str);
        }
        catch (NumberFormatException ex) {
            throw new TProtocolException(1, "Bad data encounted in numeric data");
        }
        return numericResult != 0L;
    }

    @Override
    public byte readByte() throws TException {
        return (byte)this.readJSONInteger();
    }

    @Override
    public short readI16() throws TException {
        return (short)this.readJSONInteger();
    }

    @Override
    public int readI32() throws TException {
        return (int)this.readJSONInteger();
    }

    @Override
    public long readI64() throws TException {
        return this.readJSONInteger();
    }

    @Override
    public double readDouble() throws TException {
        return this.readJSONDouble();
    }

    @Override
    public float readFloat() throws TException {
        return this.readJSONFloat();
    }

    @Override
    public String readString() throws TException {
        return this.readJSONString(false).toString(StandardCharsets.UTF_8);
    }

    @Override
    public byte[] readBinary() throws TException {
        return this.readJSONBase64();
    }

    protected class LookaheadReader {
        private boolean hasData_ = false;
        private byte[] data_ = new byte[1];
        private boolean hasNextData_ = false;
        private byte[] nextData_ = new byte[1];

        protected LookaheadReader() {
        }

        protected byte read() throws TException {
            if (this.hasNextData_) {
                byte result = this.data_[0];
                this.data_[0] = this.nextData_[0];
                this.hasNextData_ = false;
                return result;
            }
            if (this.hasData_) {
                this.hasData_ = false;
            } else {
                TJSONProtocolBase.this.trans_.readAll(this.data_, 0, 1);
            }
            return this.data_[0];
        }

        protected byte peek() throws TException {
            if (!this.hasData_) {
                TJSONProtocolBase.this.trans_.readAll(this.data_, 0, 1);
            }
            this.hasData_ = true;
            return this.data_[0];
        }

        protected byte peekNext() throws TException {
            if (!this.hasNextData_) {
                this.peek();
                TJSONProtocolBase.this.trans_.readAll(this.nextData_, 0, 1);
                this.hasNextData_ = true;
            }
            return this.nextData_[0];
        }
    }

    protected class JSONPairContext
    extends JSONBaseContext {
        private boolean first_;
        private boolean colon_;

        protected JSONPairContext() {
            this.first_ = true;
            this.colon_ = true;
        }

        @Override
        protected void write() throws TException {
            if (this.first_) {
                this.first_ = false;
                this.colon_ = true;
            } else {
                TJSONProtocolBase.this.trans_.write(this.colon_ ? COLON : COMMA);
                this.colon_ = !this.colon_;
            }
        }

        @Override
        protected void read() throws TException {
            if (this.first_) {
                this.first_ = false;
                this.colon_ = true;
            } else {
                TJSONProtocolBase.this.readJSONSyntaxChar(this.colon_ ? COLON : COMMA);
                this.colon_ = !this.colon_;
            }
        }

        @Override
        protected byte peekNextValue() throws TException {
            if (this.first_) {
                return TJSONProtocolBase.this.reader_.peek();
            }
            return TJSONProtocolBase.this.reader_.peekNext();
        }

        @Override
        protected boolean escapeNum() {
            return this.colon_;
        }
    }

    protected class JSONListContext
    extends JSONBaseContext {
        private boolean first_;

        protected JSONListContext() {
            this.first_ = true;
        }

        @Override
        protected void write() throws TException {
            if (this.first_) {
                this.first_ = false;
            } else {
                TJSONProtocolBase.this.trans_.write(COMMA);
            }
        }

        @Override
        protected void read() throws TException {
            if (this.first_) {
                this.first_ = false;
            } else {
                TJSONProtocolBase.this.readJSONSyntaxChar(COMMA);
            }
        }

        @Override
        protected byte peekNextValue() throws TException {
            if (this.first_) {
                return TJSONProtocolBase.this.reader_.peek();
            }
            return TJSONProtocolBase.this.reader_.peekNext();
        }
    }

    protected class JSONBaseContext {
        protected JSONBaseContext() {
        }

        protected void write() throws TException {
        }

        protected void read() throws TException {
        }

        protected byte peekNextValue() throws TException {
            return TJSONProtocolBase.this.reader_.peek();
        }

        protected boolean escapeNum() {
            return false;
        }
    }
}

