/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;

public final class Dot11ChannelEntry
implements Serializable {
    private static final long serialVersionUID = -1866907693281185049L;
    private final byte operatingClass;
    private final byte channel;

    public Dot11ChannelEntry(byte operatingClass, byte channel) {
        this.operatingClass = operatingClass;
        this.channel = channel;
    }

    public byte getOperatingClass() {
        return this.operatingClass;
    }

    public int getOperatingClassAsInt() {
        return this.operatingClass & 0xFF;
    }

    public byte getChannel() {
        return this.channel;
    }

    public int getChannelAsInt() {
        return this.channel & 0xFF;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.channel;
        result = 31 * result + this.operatingClass;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dot11ChannelEntry other = (Dot11ChannelEntry)obj;
        if (this.channel != other.channel) {
            return false;
        }
        return this.operatingClass == other.operatingClass;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Operating Class: ").append(this.getOperatingClassAsInt()).append(", Channel: ").append(this.getChannelAsInt()).append("]");
        return sb.toString();
    }
}

