/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.storage.ql.exec.vector;

import org.apache.orc.storage.common.type.CalendarUtils;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.LongColumnVector;

public class DateColumnVector
extends LongColumnVector {
    private boolean usingProlepticCalendar = false;

    public DateColumnVector() {
        this(1024);
    }

    public void changeCalendar(boolean useProleptic, boolean updateData) {
        if (useProleptic == this.usingProlepticCalendar) {
            return;
        }
        this.usingProlepticCalendar = useProleptic;
        if (updateData) {
            try {
                this.updateDataAccordingProlepticSetting();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void updateDataAccordingProlepticSetting() throws Exception {
        for (int i = 0; i < this.vector.length; ++i) {
            if (this.vector[i] >= CalendarUtils.SWITCHOVER_DAYS) continue;
            this.vector[i] = this.usingProlepticCalendar ? (long)CalendarUtils.convertDateToProleptic((int)this.vector[i]) : (long)CalendarUtils.convertDateToHybrid((int)this.vector[i]);
        }
    }

    public String formatDate(int i) {
        return CalendarUtils.formatDate(this.vector[i], this.usingProlepticCalendar);
    }

    public DateColumnVector setUsingProlepticCalendar(boolean usingProlepticCalendar) {
        this.usingProlepticCalendar = usingProlepticCalendar;
        return this;
    }

    public boolean isUsingProlepticCalendar() {
        return this.usingProlepticCalendar;
    }

    public DateColumnVector(int len) {
        super(len);
    }

    @Override
    public void shallowCopyTo(ColumnVector otherCv) {
        DateColumnVector other = (DateColumnVector)otherCv;
        super.shallowCopyTo(other);
        other.vector = this.vector;
    }
}

